/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0001\u0005\u0019\u0011A\u0002V3tiJ+'/\u001e8oKJT!a\u0001\u0003\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\u0003\u0002\u0007=\u0014xm\u0005\u0003\u0001\u000f5\t\u0002C\u0001\u0005\f\u001b\u0005I!\"\u0001\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00051I!AB!osJ+g\r\u0005\u0002\u000f\u001f5\t!!\u0003\u0002\u0011\u0005\tA!+\u001a:v]:,'\u000f\u0005\u0002\u0013/5\t1C\u0003\u0002\u0015+\u0005\u0011\u0011n\u001c\u0006\u0002-\u0005!!.\u0019<b\u0013\tA2C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001d\u00039\u0019X/\u001b;f\u00072\f7o\u001d(b[\u0016\u001c\u0001\u0001\u0005\u0002\u001eA9\u0011\u0001BH\u0005\u0003?%\ta\u0001\u0015:fI\u00164\u0017BA\u0011#\u0005\u0019\u0019FO]5oO*\u0011q$\u0003\u0005\tI\u0001\u0011\t\u0011)A\u00059\u0005AA/Z:u\u001d\u0006lW\rC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q%R\u0003C\u0001\b\u0001\u0011\u0015QR\u00051\u0001\u001d\u0011\u0015!S\u00051\u0001\u001d\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0015\t\u0007\u000f\u001d7z)!q\u0013GN\u001eA\u0011B+\u0006C\u0001\u00050\u0013\t\u0001\u0014B\u0001\u0003V]&$\b\"\u0002\u001a,\u0001\u0004\u0019\u0014A\u0002:fa>\u0014H\u000f\u0005\u0002\u000fi%\u0011QG\u0001\u0002\t%\u0016\u0004xN\u001d;fe\")qg\u000ba\u0001q\u000591\u000f^8qa\u0016\u0014\bC\u0001\b:\u0013\tQ$AA\u0004Ti>\u0004\b/\u001a:\t\u000bqZ\u0003\u0019A\u001f\u0002\r\u0019LG\u000e^3s!\tqa(\u0003\u0002@\u0005\t1a)\u001b7uKJDQ!Q\u0016A\u0002\t\u000b\u0011bY8oM&<W*\u00199\u0011\tu\u0019E$R\u0005\u0003\t\n\u00121!T1q!\tAa)\u0003\u0002H\u0013\t\u0019\u0011I\\=\t\u000b%[\u0003\u0019\u0001&\u0002\u0017\u0011L7\u000f\u001e:jEV$xN\u001d\t\u0004\u0011-k\u0015B\u0001'\n\u0005\u0019y\u0005\u000f^5p]B\u0011aBT\u0005\u0003\u001f\n\u00111\u0002R5tiJL'-\u001e;pe\")\u0011k\u000ba\u0001%\u00069AO]1dW\u0016\u0014\bC\u0001\bT\u0013\t!&AA\u0004Ue\u0006\u001c7.\u001a:\t\u000bY[\u0003\u0019A,\u0002\r1|\u0017\rZ3s!\tA6,D\u0001Z\u0015\tQV#\u0001\u0003mC:<\u0017B\u0001/Z\u0005-\u0019E.Y:t\u0019>\fG-\u001a:")
public class TestRerunner
implements Rerunner,
Serializable {
    private final String suiteClassName;
    private final String testName;

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter2, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        long runStartTime = System.currentTimeMillis();
        try {
            Class<?> suiteClass = loader.loadClass(this.suiteClassName);
            Suite suite = (Suite)suiteClass.newInstance();
            report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), 1, configMap));
            suite.run((Option<String>)new Some((Object)this.testName), report, stopper, filter2, configMap, distributor, tracker);
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(throwable), (Option<Throwable>)new Some((Object)throwable), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadClass", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noClassDefFoundError.getMessage()})), (Option<Throwable>)new Some((Object)noClassDefFoundError), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (SecurityException securityException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("securityWhenRerruning", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{securityException.getMessage()})), (Option<Throwable>)new Some((Object)securityException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotFindMethod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{noSuchMethodException.getMessage()})), (Option<Throwable>)new Some((Object)noSuchMethodException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (IllegalAccessException illegalAccessException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{illegalAccessException.getMessage()})), (Option<Throwable>)new Some((Object)illegalAccessException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (InstantiationException instantiationException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotInstantiateSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{instantiationException.getMessage()})), (Option<Throwable>)new Some((Object)instantiationException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            long duration = System.currentTimeMillis() - runStartTime;
            report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.apply("cannotLoadSuite", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{classNotFoundException.getMessage()})), (Option<Throwable>)new Some((Object)classNotFoundException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration))));
        }
    }

    public TestRerunner(String suiteClassName, String testName) {
        this.suiteClassName = suiteClassName;
        this.testName = testName;
        if (suiteClassName == null || testName == null) {
            throw new NullPointerException();
        }
    }
}

