/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import java.util.Map;
import org.scalatest.Args;
import org.scalatest.Args$;
import org.scalatest.CompositeStatus;
import org.scalatest.FailedStatus$;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.Status;
import org.scalatest.StepwiseNestedSuiteExecution;
import org.scalatest.Stopper;
import org.scalatest.SucceededStatus$;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import org.scalatest.events.Formatter;
import org.scalatest.events.Location;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteCompleted$;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.SuiteStarting$;
import org.scalatest.events.TopOfClass;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public abstract class StepwiseNestedSuiteExecution$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static Status runNestedSuites(StepwiseNestedSuiteExecution $this, Args args) {
        if (args == null) {
            throw new NullPointerException("args was null");
        }
        Stopper stopRequested = args.stopper();
        Reporter report = Suite$.MODULE$.wrapReporterIfNecessary((Suite)((Object)$this), args.reporter());
        ListBuffer statusBuffer = new ListBuffer();
        if (!args.filter().excludeNestedSuites()) {
            ((Suite)((Object)$this)).nestedSuites().foreach((Function1)(JFunction1 & Serializable & scala.Serializable)nestedSuite -> {
                BoxedUnit boxedUnit;
                if (!stopRequested.apply()) {
                    Status st = StepwiseNestedSuiteExecution$class.callExecuteOnSuite$1($this, nestedSuite, stopRequested, report, args);
                    st.waitUntilCompleted();
                    boxedUnit = statusBuffer.$plus$eq((Object)st);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }
        return new CompositeStatus((Set<Status>)((Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)statusBuffer)));
    }

    private static final Status callExecuteOnSuite$1(StepwiseNestedSuiteExecution $this, Suite nestedSuite, Stopper stopRequested$1, Reporter report$1, Args args$1) {
        Serializable serializable;
        if (!stopRequested$1.apply()) {
            boolean hasPublicNoArgConstructor = Suite$.MODULE$.checkForPublicNoArgConstructor(nestedSuite.getClass());
            String rawString = Resources$.MODULE$.apply("suiteExecutionStarting");
            Option<Formatter> formatter = Suite$.MODULE$.formatterForSuiteStarting(nestedSuite);
            long suiteStartTime = System.currentTimeMillis();
            report$1.apply(new SuiteStarting(args$1.tracker().nextOrdinal(), nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)nestedSuite.getClass().getName()), formatter, (Option<Location>)new Some((Object)new TopOfClass(nestedSuite.getClass().getName())), nestedSuite.rerunner(), SuiteStarting$.MODULE$.apply$default$8(), SuiteStarting$.MODULE$.apply$default$9(), SuiteStarting$.MODULE$.apply$default$10()));
            try {
                Status status = nestedSuite.run((Option<String>)None$.MODULE$, new Args(report$1, stopRequested$1, args$1.filter(), args$1.configMap(), args$1.distributor(), args$1.tracker(), (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.apply$default$8(), Args$.MODULE$.apply$default$9(), Args$.MODULE$.apply$default$10()));
                String rawString2 = Resources$.MODULE$.apply("suiteCompletedNormally");
                Option<Formatter> formatter2 = Suite$.MODULE$.formatterForSuiteCompleted(nestedSuite);
                long duration = System.currentTimeMillis() - suiteStartTime;
                report$1.apply(new SuiteCompleted(args$1.tracker().nextOrdinal(), nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)nestedSuite.getClass().getName()), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), formatter2, (Option<Location>)new Some((Object)new TopOfClass(nestedSuite.getClass().getName())), nestedSuite.rerunner(), SuiteCompleted$.MODULE$.apply$default$9(), SuiteCompleted$.MODULE$.apply$default$10(), SuiteCompleted$.MODULE$.apply$default$11()));
                serializable = SucceededStatus$.MODULE$;
            }
            catch (RuntimeException e) {
                String eMessage = e.getMessage();
                String rawString3 = eMessage != null && eMessage.length() > 0 ? Resources$.MODULE$.apply("executeExceptionWithMessage", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{eMessage})) : Resources$.MODULE$.apply("executeException");
                Option<Formatter> formatter3 = Suite$.MODULE$.formatterForSuiteAborted(nestedSuite, rawString3);
                long duration = System.currentTimeMillis() - suiteStartTime;
                report$1.apply(new SuiteAborted(args$1.tracker().nextOrdinal(), rawString3, nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)nestedSuite.getClass().getName()), (Option<Throwable>)new Some((Object)e), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), formatter3, (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), nestedSuite.rerunner(), SuiteAborted$.MODULE$.apply$default$11(), SuiteAborted$.MODULE$.apply$default$12(), SuiteAborted$.MODULE$.apply$default$13()));
                serializable = FailedStatus$.MODULE$;
            }
        } else {
            serializable = FailedStatus$.MODULE$;
        }
        return serializable;
    }

    public static void $init$(StepwiseNestedSuiteExecution $this) {
    }
}

