/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.lang.annotation.Annotation;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.scalatest.Reporter;
import org.scalatest.Reporter$;
import org.scalatest.Resources$;
import org.scalatest.events.Event;
import org.scalatest.events.RunAborted;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y3Q!\u0001\u0002\u0001\u0005!\u00111CU;o\u001d>$\u0018NZ5feJ+\u0007o\u001c:uKJT!a\u0001\u0003\u0002\u000b),h.\u001b;\u000b\u0005\u00151\u0011!C:dC2\fG/Z:u\u0015\u00059\u0011aA8sON\u0019\u0001!C\b\u0011\u0005)iQ\"A\u0006\u000b\u00031\tQa]2bY\u0006L!AD\u0006\u0003\r\u0005s\u0017PU3g!\t\u0001\u0012#D\u0001\u0005\u0013\t\u0011BA\u0001\u0005SKB|'\u000f^3s\u0011!!\u0002A!A!\u0002\u00131\u0012a\u0003:v]:{G/\u001b4jKJ\u001c\u0001\u0001\u0005\u0002\u0018;5\t\u0001D\u0003\u0002\u001a5\u0005aan\u001c;jM&\u001c\u0017\r^5p]*\u00111\u0004H\u0001\u0007eVtg.\u001a:\u000b\u0005\r1\u0011B\u0001\u0010\u0019\u0005-\u0011VO\u001c(pi&4\u0017.\u001a:\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\t\u0011C\u0005\u0005\u0002$\u00015\t!\u0001C\u0003\u0015?\u0001\u0007a\u0003C\u0003'\u0001\u0011%q%A\nuKN$H)Z:de&\u0004H/[8o\u001d\u0006lW\r\u0006\u0003)aq\n\u0005CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011a\u0017M\\4\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u000bE*\u0003\u0019\u0001\u001a\u0002\u0013M,\u0018\u000e^3OC6,\u0007CA\u001a;\u001d\t!\u0004\b\u0005\u00026\u00175\taG\u0003\u00028+\u00051AH]8pizJ!!O\u0006\u0002\rA\u0013X\rZ3g\u0013\ty3H\u0003\u0002:\u0017!)Q(\na\u0001}\u0005q1/^5uK\u000ec\u0017m]:OC6,\u0007c\u0001\u0006@e%\u0011\u0001i\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b\t+\u0003\u0019\u0001\u001a\u0002\u0011Q,7\u000f\u001e(b[\u0016DQ\u0001\u0012\u0001\u0005\n\u0015\u000bAc];ji\u0016$Um]2sSB$\u0018n\u001c8OC6,Gc\u0001\u001aG\u000f\")\u0011g\u0011a\u0001e!)Qh\u0011a\u0001}!)\u0011\n\u0001C!\u0015\u0006)\u0011\r\u001d9msR\u00111J\u0014\t\u0003\u00151K!!T\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\"\u0003\r\u0001U\u0001\u0006KZ,g\u000e\u001e\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0012\ta!\u001a<f]R\u001c\u0018BA+S\u0005\u0015)e/\u001a8u\u0001")
public class RunNotifierReporter
implements Reporter {
    private final RunNotifier runNotifier;

    private String testDescriptionName(String suiteName, Option<String> suiteClassName, String testName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String suiteClassName2 = (String)some.x();
            string = new StringBuilder().append((Object)testName).append((Object)"(").append((Object)suiteClassName2).append((Object)")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder().append((Object)testName).append((Object)"(").append((Object)suiteName).append((Object)")").toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String suiteDescriptionName(String suiteName, Option<String> suiteClassName) {
        String string;
        Option<String> option = suiteClassName;
        if (option instanceof Some) {
            String suiteClassName2;
            Some some = (Some)option;
            string = suiteClassName2 = (String)some.x();
        } else if (None$.MODULE$.equals(option)) {
            string = suiteName;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    @Override
    public void apply(Event event) {
        Event event2 = event;
        if (event2 instanceof TestStarting) {
            TestStarting testStarting = (TestStarting)event2;
            String suiteName = testStarting.suiteName();
            Option<String> suiteClassName = testStarting.suiteClassName();
            String testName = testStarting.testName();
            this.runNotifier.fireTestStarted(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestFailed) {
            Throwable throwable;
            TestFailed testFailed = (TestFailed)event2;
            String suiteName = testFailed.suiteName();
            Option<String> suiteClassName = testFailed.suiteClassName();
            String testName = testFailed.testName();
            Option<Throwable> throwable2 = testFailed.throwable();
            Option<Throwable> option = throwable2;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.x();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestSucceeded) {
            TestSucceeded testSucceeded = (TestSucceeded)event2;
            String suiteName = testSucceeded.suiteName();
            Option<String> suiteClassName = testSucceeded.suiteClassName();
            String testName = testSucceeded.testName();
            this.runNotifier.fireTestFinished(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestIgnored) {
            TestIgnored testIgnored = (TestIgnored)event2;
            String suiteName = testIgnored.suiteName();
            Option<String> suiteClassName = testIgnored.suiteClassName();
            String testName = testIgnored.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof TestPending) {
            TestPending testPending = (TestPending)event2;
            String suiteName = testPending.suiteName();
            Option<String> suiteClassName = testPending.suiteClassName();
            String testName = testPending.testName();
            this.runNotifier.fireTestIgnored(Description.createSuiteDescription((String)this.testDescriptionName(suiteName, suiteClassName, testName), (Annotation[])new Annotation[0]));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof SuiteAborted) {
            Throwable throwable;
            SuiteAborted suiteAborted = (SuiteAborted)event2;
            String suiteName = suiteAborted.suiteName();
            Option<String> suiteClassName = suiteAborted.suiteClassName();
            Option<Throwable> throwable3 = suiteAborted.throwable();
            Option<Throwable> option = throwable3;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.x();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            Description description = Description.createSuiteDescription((String)this.suiteDescriptionName(suiteName, suiteClassName), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (event2 instanceof RunAborted) {
            Throwable throwable;
            RunAborted runAborted = (RunAborted)event2;
            String message = runAborted.message();
            Option<Throwable> throwable4 = runAborted.throwable();
            Option<Throwable> option = throwable4;
            if (option instanceof Some) {
                Throwable t;
                Some some = (Some)option;
                throwable = t = (Throwable)some.x();
            } else if (None$.MODULE$.equals(option)) {
                throwable = null;
            } else {
                throw new MatchError(option);
            }
            Throwable throwableOrNull = throwable;
            String possiblyEmptyMessage = Reporter$.MODULE$.messageOrThrowablesDetailMessage(message, throwable4);
            Description description = Description.createSuiteDescription((String)new StringBuilder().append((Object)Resources$.MODULE$.apply("runAborted")).append((Object)" ").append((Object)possiblyEmptyMessage).toString(), (Annotation[])new Annotation[0]);
            this.runNotifier.fireTestFailure(new Failure(description, throwableOrNull));
            this.runNotifier.fireTestFinished(description);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public RunNotifierReporter(RunNotifier runNotifier) {
        this.runNotifier = runNotifier;
    }
}

