/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.scalatest.NotAllowedException;
import org.scalatest.Resources$;
import org.scalatest.StackDepthExceptionHelper$;
import org.scalatest.concurrent.Conductor$ClockThread$;
import org.scalatest.concurrent.Conductor$ConductorState$;
import org.scalatest.concurrent.Conductor$Setup$;
import org.scalatest.concurrent.Conductor$TestFinished$;
import org.scalatest.concurrent.Conductor$TestStarted$;
import org.scalatest.concurrent.Conductor$TestThread$;
import org.scalatest.concurrent.PimpedReadWriteLock$;
import org.scalatest.concurrent.PimpedThreadGroup$;
import org.scalatest.concurrent.TestThreadsStartingCounter;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011Mc\u0001B\u0001\u0003\u0005%\u0011\u0011bQ8oIV\u001cGo\u001c:\u000b\u0005\r!\u0011AC2p]\u000e,(O]3oi*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7\u0001A\n\u0004\u0001)\u0011\u0002CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u00135q$A\u0003dY>\u001c7.F\u0001!!\t\t#%D\u0001\u0001\r\u0011\u0019\u0003\u0001\u0002\u0013\u0003\u000b\rcwnY6\u0014\u0007\tR!\u0003C\u0003\u001aE\u0011\u0005a\u0005F\u0001!\u0011\u001dA#\u00051A\u0005\n%\n1bY;se\u0016tG\u000fV5nKV\t!\u0006\u0005\u0002\u0014W%\u0011A\u0006\u0006\u0002\u0004\u0013:$\bb\u0002\u0018#\u0001\u0004%IaL\u0001\u0010GV\u0014(/\u001a8u)&lWm\u0018\u0013fcR\u0011\u0001g\r\t\u0003'EJ!A\r\u000b\u0003\tUs\u0017\u000e\u001e\u0005\bi5\n\t\u00111\u0001+\u0003\rAH%\r\u0005\u0007m\t\u0002\u000b\u0015\u0002\u0016\u0002\u0019\r,(O]3oiRKW.\u001a\u0011\t\u000fa\u0012#\u0019!C\u0005s\u0005!An\\2l+\u0005Q\u0001BB\u001e#A\u0003%!\"A\u0003m_\u000e\\\u0007\u0005C\u0004>E\t\u0007I\u0011\u0002 \u0002\rI<Hj\\2l+\u0005y\u0004C\u0001!G\u001b\u0005\t%B\u0001\"D\u0003\u0015awnY6t\u0015\t\u0019AI\u0003\u0002F\u001d\u0005!Q\u000f^5m\u0013\t9\u0015I\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u0019I%\u0005)A\u0005\u007f\u00059!o\u001e'pG.\u0004\u0003bB&#\u0001\u0004%I!K\u0001\u0019Q&<\u0007.Z:u\u0005\u0016\fGOQ3j]\u001e<\u0016-\u001b;fI>s\u0007bB'#\u0001\u0004%IAT\u0001\u001dQ&<\u0007.Z:u\u0005\u0016\fGOQ3j]\u001e<\u0016-\u001b;fI>sw\fJ3r)\t\u0001t\nC\u00045\u0019\u0006\u0005\t\u0019\u0001\u0016\t\rE\u0013\u0003\u0015)\u0003+\u0003eA\u0017n\u001a5fgR\u0014U-\u0019;CK&twmV1ji\u0016$wJ\u001c\u0011\t\u000bM\u0013C\u0011\u0001+\u0002\u000f\u0005$g/\u00198dKR\t\u0001\u0007C\u0003WE\u0011\u0005\u0011&A\u0006dkJ\u0014XM\u001c;CK\u0006$\b\"\u0002-#\t\u0003I\u0016aC<bSR4uN\u001d\"fCR$\"\u0001\r.\t\u000bm;\u0006\u0019\u0001\u0016\u0002\t\t,\u0017\r\u001e\u0005\u0006;\n\"\tAX\u0001\u001bSN\fe.\u001f+ie\u0016\fGmV1ji&twMR8s\u0003\n+\u0017\r^\u000b\u0002?B\u00111\u0003Y\u0005\u0003CR\u0011qAQ8pY\u0016\fg\u000eC\u0003dE\u0011\u0005A-A\bxSRD7\t\\8dW\u001a\u0013xN_3o+\t)\u0007\u000e\u0006\u0002gcB\u0011q\r\u001b\u0007\u0001\t\u0015I'M1\u0001k\u0005\u0005!\u0016CA6o!\t\u0019B.\u0003\u0002n)\t9aj\u001c;iS:<\u0007CA\np\u0013\t\u0001HCA\u0002B]fDaA\u001d2\u0005\u0002\u0004\u0019\u0018a\u00014v]B\u00191\u0003\u001e4\n\u0005U$\"\u0001\u0003\u001fcs:\fW.\u001a \t\u000b]\u0014C\u0011\u00010\u0002\u0011%\u001chI]8{K:Da!\u001f\u0001!\u0002\u001b\u0001\u0013AB2m_\u000e\\\u0007\u0005C\u0004|\u0001\t\u0007IQ\u0002?\u0002\u0017QD'/Z1e\u000fJ|W\u000f]\u000b\u0002{B\u00111B`\u0005\u0003\u007f2\u00111\u0002\u00165sK\u0006$wI]8va\"9\u00111\u0001\u0001!\u0002\u001bi\u0018\u0001\u0004;ie\u0016\fGm\u0012:pkB\u0004\u0003\"CA\u0004\u0001\t\u0007IQBA\u0005\u0003\u001d!\bN]3bIN,\"!a\u0003\u0011\r\u00055\u0011qBA\n\u001b\u0005\u0019\u0015bAA\t\u0007\n!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgR\u00042aCA\u000b\u0013\r\t9\u0002\u0004\u0002\u0007)\"\u0014X-\u00193\t\u0011\u0005m\u0001\u0001)A\u0007\u0003\u0017\t\u0001\u0002\u001e5sK\u0006$7\u000f\t\u0005\n\u0003?\u0001!\u0019!C\u0007\u0003C\t1\u0002\u001e5sK\u0006$g*Y7fgV\u0011\u00111\u0005\t\u0007\u0003\u001b\ty!!\n\u0011\t\u0005\u001d\u0012Q\u0006\b\u0004'\u0005%\u0012bAA\u0016)\u00051\u0001K]3eK\u001aLA!a\f\u00022\t11\u000b\u001e:j]\u001eT1!a\u000b\u0015\u0011!\t)\u0004\u0001Q\u0001\u000e\u0005\r\u0012\u0001\u0004;ie\u0016\fGMT1nKN\u0004\u0003\"CA\u001d\u0001\t\u0007IQBA\u001e\u0003)i\u0017-\u001b8UQJ,\u0017\rZ\u000b\u0003\u0003'A\u0001\"a\u0010\u0001A\u00035\u00111C\u0001\f[\u0006Lg\u000e\u00165sK\u0006$\u0007\u0005C\u0004\u0002D\u0001!\t!!\u0012\u0002\rQD'/Z1e)\u0011\t\u0019\"a\u0012\t\u0011I\f\t\u0005\"a\u0001\u0003\u0013\u00022a\u0005;1\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u001b\"B!a\u0014\u0002TQ!\u00111CA)\u0011!\u0011\u00181\nCA\u0002\u0005%\u0003\u0002CA+\u0003\u0017\u0002\r!!\n\u0002\t9\fW.\u001a\u0004\u0007\u00033\u0002A)a\u0017\u0003\u0015Q+7\u000f\u001e+ie\u0016\fGmE\u0005\u0002X\u0005M!#!\u0018\u0002dA\u00191#a\u0018\n\u0007\u0005\u0005DCA\u0004Qe>$Wo\u0019;\u0011\u0007M\t)'C\u0002\u0002hQ\u0011AbU3sS\u0006d\u0017N_1cY\u0016D1\"!\u0016\u0002X\tU\r\u0011\"\u0001\u0002lU\u0011\u0011Q\u0005\u0005\f\u0003_\n9F!E!\u0002\u0013\t)#A\u0003oC6,\u0007\u0005C\u0006\u0002t\u0005]#Q3A\u0005\u0002\u0005U\u0014!\u00014\u0016\u0005\u0005]\u0004\u0003B\n\u0002zAJ1!a\u001f\u0015\u0005%1UO\\2uS>t\u0007\u0007C\u0006\u0002\u0000\u0005]#\u0011#Q\u0001\n\u0005]\u0014A\u00014!\u0011\u001dI\u0012q\u000bC\u0001\u0003\u0007#b!!\"\u0002\b\u0006%\u0005cA\u0011\u0002X!A\u0011QKAA\u0001\u0004\t)\u0003\u0003\u0005\u0002t\u0005\u0005\u0005\u0019AA<\u0011\u001d\ti)a\u0016\u0005BQ\u000b1A];o\u0011)\t\t*a\u0016\u0002\u0002\u0013\u0005\u00111S\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002\u0006\u0006U\u0015q\u0013\u0005\u000b\u0003+\ny\t%AA\u0002\u0005\u0015\u0002BCA:\u0003\u001f\u0003\n\u00111\u0001\u0002x!Q\u00111TA,#\u0003%\t!!(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0014\u0016\u0005\u0003K\t\tk\u000b\u0002\u0002$B!\u0011QUAX\u001b\t\t9K\u0003\u0003\u0002*\u0006-\u0016!C;oG\",7m[3e\u0015\r\ti\u000bF\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAY\u0003O\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t),a\u0016\u0012\u0002\u0013\u0005\u0011qW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIL\u000b\u0003\u0002x\u0005\u0005\u0006\u0002CA_\u0003/\"\t%a0\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A\u000b\u0005\t\u0003\u0007\f9\u0006\"\u0011\u0002F\u00061Q-];bYN$2aXAd\u0011!!\u0014\u0011YA\u0001\u0002\u0004q\u0007\u0002CAf\u0003/\"\t%!4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\rE\u0002\f\u0003#L1!a\f\r\u0011\u001d\t).a\u0016\u0005B%\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0001\"!7\u0002X\u0011\u0005\u00131\\\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rq\u0017Q\u001c\u0005\ti\u0005]\u0017\u0011!a\u0001U!A\u0011\u0011]A,\t\u0003\n\u0019/\u0001\u0005dC:,\u0015/^1m)\ry\u0016Q\u001d\u0005\ti\u0005}\u0017\u0011!a\u0001]\u001eI\u0011\u0011\u001e\u0001\u0002\u0002#5\u00111^\u0001\u000b)\u0016\u001cH\u000f\u00165sK\u0006$\u0007cA\u0011\u0002n\u001aI\u0011\u0011\f\u0001\u0002\u0002#5\u0011q^\n\b\u0003[\f\tPEA2!)\t\u00190!?\u0002&\u0005]\u0014QQ\u0007\u0003\u0003kT1!a>\u0015\u0003\u001d\u0011XO\u001c;j[\u0016LA!a?\u0002v\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fe\ti\u000f\"\u0001\u0002\u0000R\u0011\u00111\u001e\u0005\t\u0005\u0007\ti\u000f\"\u0012\u0003\u0006\u0005AAo\\*ue&tw\r\u0006\u0002\u0002P\"Q!\u0011BAw\u0003\u0003%\tIa\u0003\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\u0015%Q\u0002B\b\u0011!\t)Fa\u0002A\u0002\u0005\u0015\u0002\u0002CA:\u0005\u000f\u0001\r!a\u001e\t\u0015\tM\u0011Q^A\u0001\n\u0003\u0013)\"A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t]!1\u0005\t\u0006'\te!QD\u0005\u0004\u00057!\"AB(qi&|g\u000eE\u0004\u0014\u0005?\t)#a\u001e\n\u0007\t\u0005BC\u0001\u0004UkBdWM\r\u0005\t\u0005K\u0011\t\u00021\u0001\u0002\u0006\u0006\u0019\u0001\u0010\n\u0019\t\u0013\t%\u0002A1A\u0005\n\t-\u0012\u0001\u00064jeN$X\t_2faRLwN\u001c+ie><h.\u0006\u0002\u0003.A1\u0011Q\u0002B\u0018\u0005gI1A!\rD\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\t\tU\"Q\t\b\u0005\u0005o\u0011\tE\u0004\u0003\u0003:\t}RB\u0001B\u001e\u0015\r\u0011i\u0004C\u0001\u0007yI|w\u000e\u001e \n\u0003UI1Aa\u0011\u0015\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0012\u0003J\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0005\u0007\"\u0002\u0002\u0003B'\u0001\u0001\u0006IA!\f\u0002+\u0019L'o\u001d;Fq\u000e,\u0007\u000f^5p]RC'o\\<oA!9!\u0011\u000b\u0001\u0005\u0002\tM\u0013\u0001D<iK:4\u0015N\\5tQ\u0016$Gc\u0001\u0019\u0003V!A!Oa\u0014\u0005\u0002\u0004\tI\u0005\u0003\u0004Y\u0001\u0011\u0005!\u0011\f\u000b\u0004a\tm\u0003BB.\u0003X\u0001\u0007!\u0006C\u0003\\\u0001\u0011\u0005\u0011\u0006C\u0004\u0003b\u0001!\tAa\u0019\u0002']LG\u000f[\"p]\u0012,8\r^8s\rJ|'0\u001a8\u0016\t\t\u0015$Q\u000e\u000b\u0004a\t\u001d\u0004\u0002\u0003:\u0003`\u0011\u0005\rA!\u001b\u0011\tM!(1\u000e\t\u0004O\n5DAB5\u0003`\t\u0007!\u000e\u0003\u0004\u0003r\u0001!\tAX\u0001\u0012SN\u001cuN\u001c3vGR|'O\u0012:pu\u0016t\u0007\"\u0003B;\u0001\t\u0007I\u0011\u0002B<\u0003i!Xm\u001d;UQJ,\u0017\rZ:Ti\u0006\u0014H/\u001b8h\u0007>,h\u000e^3s+\t\u0011I\bE\u0002\u001d\u0005wJ1A! \u0003\u0005i!Vm\u001d;UQJ,\u0017\rZ:Ti\u0006\u0014H/\u001b8h\u0007>,h\u000e^3s\u0011!\u0011\t\t\u0001Q\u0001\n\te\u0014a\u0007;fgR$\u0006N]3bIN\u001cF/\u0019:uS:<7i\\;oi\u0016\u0014\b\u0005C\u0005\u0003\u0006\u0002\u0011\r\u0011\"\u0003\u0003\b\u0006ArM]3f]2Kw\r\u001b;G_J$Vm\u001d;UQJ,\u0017\rZ:\u0016\u0005\t%\u0005\u0003BA\u0007\u0005\u0017K1A!$D\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001B!%\u0001A\u0003%!\u0011R\u0001\u001aOJ,WM\u001c'jO\"$hi\u001c:UKN$H\u000b\u001b:fC\u0012\u001c\b\u0005\u0003\u0004\u0003\u0016\u0002!\t\u0001V\u0001\bG>tG-^2u\u0011%\u0011I\n\u0001b\u0001\n\u0013\u0011Y*\u0001\u0007dkJ\u0014XM\u001c;Ti\u0006$X-\u0006\u0002\u0003\u001eB1!q\u0014BS\u0005Sk!A!)\u000b\u0007\t\r6)\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005O\u0013\tKA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\r\t#1\u0016\u0004\u0007\u0005[\u0003AKa,\u0003\u001d\r{g\u000eZ;di>\u00148\u000b^1uKNA!1\u0016\u0006\u0013\u0003;\n\u0019\u0007\u0003\u0006\u00034\n-&Q3A\u0005\u0002y\u000ba\u0002^3ti^\u000b7o\u0015;beR,G\r\u0003\u0006\u00038\n-&\u0011#Q\u0001\n}\u000bq\u0002^3ti^\u000b7o\u0015;beR,G\r\t\u0005\u000b\u0005w\u0013YK!f\u0001\n\u0003q\u0016A\u0004;fgRL5OR5oSNDW\r\u001a\u0005\u000b\u0005\u007f\u0013YK!E!\u0002\u0013y\u0016a\u0004;fgRL5OR5oSNDW\r\u001a\u0011\t\u000fe\u0011Y\u000b\"\u0001\u0003DR1!\u0011\u0016Bc\u0005\u000fDqAa-\u0003B\u0002\u0007q\fC\u0004\u0003<\n\u0005\u0007\u0019A0\t\u0015\u0005E%1VA\u0001\n\u0003\u0011Y\r\u0006\u0004\u0003*\n5'q\u001a\u0005\n\u0005g\u0013I\r%AA\u0002}C\u0011Ba/\u0003JB\u0005\t\u0019A0\t\u0015\u0005m%1VI\u0001\n\u0003\u0011\u0019.\u0006\u0002\u0003V*\u001aq,!)\t\u0015\u0005U&1VI\u0001\n\u0003\u0011\u0019\u000e\u0003\u0005\u0002>\n-F\u0011IA`\u0011!\u0011\u0019Aa+\u0005B\tuGCAA\u0013\u0011!\t\u0019Ma+\u0005B\t\u0005HcA0\u0003d\"AAGa8\u0002\u0002\u0003\u0007a\u000e\u0003\u0005\u0002L\n-F\u0011IAg\u0011\u001d\t)Na+\u0005B%B\u0001\"!7\u0003,\u0012\u0005#1\u001e\u000b\u0004]\n5\b\u0002\u0003\u001b\u0003j\u0006\u0005\t\u0019\u0001\u0016\t\u0011\u0005\u0005(1\u0016C!\u0005c$2a\u0018Bz\u0011!!$q^A\u0001\u0002\u0004q\u0017\u0006\u0003BV\u0005o\u001cYba\u0010\u0007\u000f\te\b\u0001#$\u0003|\n)1+\u001a;vaNI!q\u001fBU%\u0005u\u00131\r\u0005\b3\t]H\u0011\u0001B\u0000)\t\u0019\t\u0001E\u0002\"\u0005oD\u0001\"a1\u0003x\u0012\u00053Q\u0001\u000b\u0004?\u000e\u001d\u0001\u0002\u0003\u001b\u0004\u0004\u0005\u0005\t\u0019\u00018\t\u0011\t\r!q\u001fC#\u0005\u000bA\u0001\"a3\u0003x\u0012\u0005\u0013Q\u001a\u0005\b\u0003+\u00149\u0010\"\u0011*\u0011!\tINa>\u0005B\rEAc\u00018\u0004\u0014!AAga\u0004\u0002\u0002\u0003\u0007!\u0006\u0003\u0005\u0002b\n]H\u0011IB\f)\ry6\u0011\u0004\u0005\ti\rU\u0011\u0011!a\u0001]\u001a91Q\u0004\u0001\t\u000e\u000e}!\u0001\u0004+fgR4\u0015N\\5tQ\u0016$7#CB\u000e\u0005S\u0013\u0012QLA2\u0011\u001dI21\u0004C\u0001\u0007G!\"a!\n\u0011\u0007\u0005\u001aY\u0002\u0003\u0005\u0002D\u000emA\u0011IB\u0015)\ry61\u0006\u0005\ti\r\u001d\u0012\u0011!a\u0001]\"A!1AB\u000e\t\u000b\u0012)\u0001\u0003\u0005\u0002L\u000emA\u0011IAg\u0011\u001d\t)na\u0007\u0005B%B\u0001\"!7\u0004\u001c\u0011\u00053Q\u0007\u000b\u0004]\u000e]\u0002\u0002\u0003\u001b\u00044\u0005\u0005\t\u0019\u0001\u0016\t\u0011\u0005\u000581\u0004C!\u0007w!2aXB\u001f\u0011!!4\u0011HA\u0001\u0002\u0004qgaBB!\u0001!551\t\u0002\f)\u0016\u001cHo\u0015;beR,GmE\u0005\u0004@\t%&#!\u0018\u0002d!9\u0011da\u0010\u0005\u0002\r\u001dCCAB%!\r\t3q\b\u0005\t\u0003\u0007\u001cy\u0004\"\u0011\u0004NQ\u0019qla\u0014\t\u0011Q\u001aY%!AA\u00029D\u0001Ba\u0001\u0004@\u0011\u0015#Q\u0001\u0005\t\u0003\u0017\u001cy\u0004\"\u0011\u0002N\"9\u0011Q[B \t\u0003J\u0003\u0002CAm\u0007\u007f!\te!\u0017\u0015\u00079\u001cY\u0006\u0003\u00055\u0007/\n\t\u00111\u0001+\u0011!\t\toa\u0010\u0005B\r}CcA0\u0004b!AAg!\u0018\u0002\u0002\u0003\u0007a\u000e\u0003\u0005\u0004f\u0001\u0001\u000b\u0011\u0002BO\u00035\u0019WO\u001d:f]R\u001cF/\u0019;fA!11\u0011\u000e\u0001\u0005\u0002y\u000b!cY8oIV\u001cG/\u001b8h\u0011\u0006\u001c()Z4v]\"9!Q\u0013\u0001\u0005\u0002\r5D#\u0002\u0019\u0004p\rM\u0004bBB9\u0007W\u0002\rAK\u0001\fG2|7m\u001b)fe&|G\rC\u0004\u0004v\r-\u0004\u0019\u0001\u0016\u0002\u000fQLW.Z8vi\"91\u0011\u0010\u0001\u0005\n\rm\u0014AD<bSR4uN\u001d+ie\u0016\fGm]\u000b\u0002a\u001911q\u0010\u0001E\u0007\u0003\u00131b\u00117pG.$\u0006N]3bINI1QPA\n%\u0005u\u00131\r\u0005\u000b\u0007c\u001aiH!f\u0001\n\u0003I\u0003BCBD\u0007{\u0012\t\u0012)A\u0005U\u0005a1\r\\8dWB+'/[8eA!Q11RB?\u0005+\u0007I\u0011A\u0015\u0002\u00155\f\u0007PU;o)&lW\r\u0003\u0006\u0004\u0010\u000eu$\u0011#Q\u0001\n)\n1\"\\1y%VtG+[7fA!9\u0011d! \u0005\u0002\rMECBBK\u0007/\u001bI\nE\u0002\"\u0007{Bqa!\u001d\u0004\u0012\u0002\u0007!\u0006C\u0004\u0004\f\u000eE\u0005\u0019\u0001\u0016\t\u0015\ru5Q\u0010a\u0001\n\u0013\u0019y*\u0001\u0007mCN$\bK]8he\u0016\u001c8/\u0006\u0002\u0004\"B\u00191ca)\n\u0007\r\u0015FC\u0001\u0003M_:<\u0007BCBU\u0007{\u0002\r\u0011\"\u0003\u0004,\u0006\u0001B.Y:u!J|wM]3tg~#S-\u001d\u000b\u0004a\r5\u0006\"\u0003\u001b\u0004(\u0006\u0005\t\u0019ABQ\u0011%\u0019\tl! !B\u0013\u0019\t+A\u0007mCN$\bK]8he\u0016\u001c8\u000f\t\u0005\n\u0007k\u001bi\b1A\u0005\n%\nQ\u0002Z3bI2|7m[\"pk:$\bBCB]\u0007{\u0002\r\u0011\"\u0003\u0004<\u0006\tB-Z1eY>\u001c7nQ8v]R|F%Z9\u0015\u0007A\u001ai\f\u0003\u00055\u0007o\u000b\t\u00111\u0001+\u0011!\u0019\tm! !B\u0013Q\u0013A\u00043fC\u0012dwnY6D_VtG\u000f\t\u0005\n\u0007\u000b\u001ciH1A\u0005\n%\n1%T1y\t\u0016\fG\r\\8dW\u0012+G/Z2uS>t7OQ3g_J,G)Z1eY>\u001c7\u000e\u0003\u0005\u0004J\u000eu\u0004\u0015!\u0003+\u0003\u0011j\u0015\r\u001f#fC\u0012dwnY6EKR,7\r^5p]N\u0014UMZ8sK\u0012+\u0017\r\u001a7pG.\u0004\u0003bBAG\u0007{\"\t\u0005\u0016\u0005\b\u0007\u001f\u001ci\b\"\u0003_\u00039\u0011XO\u001c8j]\u001e$vn\u001c'p]\u001eDqa!\u001e\u0004~\u0011%A\u000bC\u0004\u0004V\u000euD\u0011\u0002+\u0002\u001d\u0011,G/Z2u\t\u0016\fG\r\\8dW\"Q\u0011\u0011SB?\u0003\u0003%\ta!7\u0015\r\rU51\\Bo\u0011%\u0019\tha6\u0011\u0002\u0003\u0007!\u0006C\u0005\u0004\f\u000e]\u0007\u0013!a\u0001U!Q\u00111TB?#\u0003%\ta!9\u0016\u0005\r\r(f\u0001\u0016\u0002\"\"Q\u0011QWB?#\u0003%\ta!9\t\u0011\u0005u6Q\u0010C!\u0003\u007fC\u0001\"a1\u0004~\u0011\u000531\u001e\u000b\u0004?\u000e5\b\u0002\u0003\u001b\u0004j\u0006\u0005\t\u0019\u00018\t\u0011\u0005-7Q\u0010C!\u0003\u001bDq!!6\u0004~\u0011\u0005\u0013\u0006\u0003\u0005\u0002Z\u000euD\u0011IB{)\rq7q\u001f\u0005\ti\rM\u0018\u0011!a\u0001U!A\u0011\u0011]B?\t\u0003\u001aY\u0010F\u0002`\u0007{D\u0001\u0002NB}\u0003\u0003\u0005\rA\\\u0004\n\t\u0003\u0001\u0011\u0011!E\u0007\t\u0007\t1b\u00117pG.$\u0006N]3bIB\u0019\u0011\u0005\"\u0002\u0007\u0013\r}\u0004!!A\t\u000e\u0011\u001d1c\u0002C\u0003\t\u0013\u0011\u00121\r\t\t\u0003g\fIP\u000b\u0016\u0004\u0016\"9\u0011\u0004\"\u0002\u0005\u0002\u00115AC\u0001C\u0002\u0011!\u0011\u0019\u0001\"\u0002\u0005F\t\u0015\u0001B\u0003B\u0005\t\u000b\t\t\u0011\"!\u0005\u0014Q11Q\u0013C\u000b\t/Aqa!\u001d\u0005\u0012\u0001\u0007!\u0006C\u0004\u0004\f\u0012E\u0001\u0019\u0001\u0016\t\u0015\tMAQAA\u0001\n\u0003#Y\u0002\u0006\u0003\u0005\u001e\u0011\u0005\u0002#B\n\u0003\u001a\u0011}\u0001#B\n\u0003 )R\u0003\u0002\u0003B\u0013\t3\u0001\ra!&\b\u0013\u0011\u0015\u0002!!A\t\u000e\u0011\u001d\u0012AD\"p]\u0012,8\r^8s'R\fG/\u001a\t\u0004C\u0011%b!\u0003BW\u0001\u0005\u0005\tR\u0002C\u0016'\u001d!I\u0003\"\f\u0013\u0003G\u0002\u0002\"a=\u0002z~{&\u0011\u0016\u0005\b3\u0011%B\u0011\u0001C\u0019)\t!9\u0003\u0003\u0005\u0003\u0004\u0011%BQ\tB\u0003\u0011)\u0011I\u0001\"\u000b\u0002\u0002\u0013\u0005Eq\u0007\u000b\u0007\u0005S#I\u0004b\u000f\t\u000f\tMFQ\u0007a\u0001?\"9!1\u0018C\u001b\u0001\u0004y\u0006B\u0003B\n\tS\t\t\u0011\"!\u0005@Q!A\u0011\tC#!\u0015\u0019\"\u0011\u0004C\"!\u0015\u0019\"qD0`\u0011!\u0011)\u0003\"\u0010A\u0002\t%va\u0002C%\u0001!55\u0011A\u0001\u0006'\u0016$X\u000f]\u0004\b\t\u001b\u0002\u0001RRB%\u0003-!Vm\u001d;Ti\u0006\u0014H/\u001a3\b\u000f\u0011E\u0003\u0001#$\u0004&\u0005aA+Z:u\r&t\u0017n\u001d5fI\u0002")
public final class Conductor
implements ScalaObject {
    private final Clock org$scalatest$concurrent$Conductor$$clock = new Clock(this);
    private final ThreadGroup org$scalatest$concurrent$Conductor$$threadGroup = new ThreadGroup("Orchestra");
    private final CopyOnWriteArrayList<Thread> threads = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<String> threadNames = new CopyOnWriteArrayList();
    private final Thread org$scalatest$concurrent$Conductor$$mainThread = package$.MODULE$.currentThread();
    private final ArrayBlockingQueue<Throwable> org$scalatest$concurrent$Conductor$$firstExceptionThrown = new ArrayBlockingQueue(1);
    private final TestThreadsStartingCounter org$scalatest$concurrent$Conductor$$testThreadsStartingCounter = new TestThreadsStartingCounter();
    private final CountDownLatch org$scalatest$concurrent$Conductor$$greenLightForTestThreads = new CountDownLatch(1);
    private final AtomicReference<ConductorState> currentState = new AtomicReference<Conductor$Setup$>(this.Setup());
    private volatile Conductor$TestThread$ TestThread$module;
    private volatile Conductor$ClockThread$ ClockThread$module;
    private volatile Conductor$ConductorState$ ConductorState$module;
    private volatile Conductor$Setup$ Setup$module;
    private volatile Conductor$TestStarted$ TestStarted$module;
    private volatile Conductor$TestFinished$ TestFinished$module;

    public final Clock org$scalatest$concurrent$Conductor$$clock() {
        return this.org$scalatest$concurrent$Conductor$$clock;
    }

    public final ThreadGroup org$scalatest$concurrent$Conductor$$threadGroup() {
        return this.org$scalatest$concurrent$Conductor$$threadGroup;
    }

    private final CopyOnWriteArrayList<Thread> threads() {
        return this.threads;
    }

    private final CopyOnWriteArrayList<String> threadNames() {
        return this.threadNames;
    }

    public final Thread org$scalatest$concurrent$Conductor$$mainThread() {
        return this.org$scalatest$concurrent$Conductor$$mainThread;
    }

    public Thread thread(Function0<BoxedUnit> fun) {
        return this.thread(new StringBuilder().append((Object)"Conductor-Thread-").append((Object)BoxesRunTime.boxToInteger((int)this.threads().size())).toString(), fun);
    }

    public Thread thread(String name, Function0<BoxedUnit> fun) {
        ConductorState conductorState = this.currentState().get();
        Conductor$TestFinished$ conductor$TestFinished$ = this.TestFinished();
        ConductorState conductorState2 = conductorState;
        if (!(conductor$TestFinished$ != null ? !((Object)conductor$TestFinished$).equals(conductorState2) : conductorState2 != null)) {
            throw new NotAllowedException(Resources$.MODULE$.apply("threadCalledAfterConductingHasCompleted"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "thread"));
        }
        if (this.threadNames().contains(name)) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cantRegisterThreadsWithSameName", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{name})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "thread"));
        }
        TestThread t = new TestThread(this, name, fun);
        this.threads().add(t);
        this.threadNames().add(name);
        t.start();
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$TestThread$ TestThread() {
        if (this.TestThread$module != null) return this.TestThread$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.TestThread$module == null) {
                this.TestThread$module = new Conductor$TestThread$(this);
            }
            return this.TestThread$module;
        }
    }

    public final ArrayBlockingQueue<Throwable> org$scalatest$concurrent$Conductor$$firstExceptionThrown() {
        return this.org$scalatest$concurrent$Conductor$$firstExceptionThrown;
    }

    public void whenFinished(Function0<BoxedUnit> fun) {
        Thread thread2 = package$.MODULE$.currentThread();
        Thread thread3 = this.org$scalatest$concurrent$Conductor$$mainThread();
        if (!(thread2 != null ? !thread2.equals(thread3) : thread3 != null)) {
            if (this.conductingHasBegun()) {
                throw new NotAllowedException(Resources$.MODULE$.apply("cannotInvokeWhenFinishedAfterConduct"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "whenFinished"));
            }
            this.conduct();
            fun.apply();
            return;
        }
        throw new NotAllowedException(Resources$.MODULE$.apply("whenFinishedCanOnlyBeCalledByMainThread"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "whenFinished"));
    }

    public void waitForBeat(int beat) {
        if (beat == 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotWaitForBeatZero"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "waitForBeat"));
        }
        if (beat < 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotWaitForNegativeBeat"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "waitForBeat"));
        }
        this.org$scalatest$concurrent$Conductor$$clock().waitForBeat(beat);
    }

    public int beat() {
        return this.org$scalatest$concurrent$Conductor$$clock().currentBeat();
    }

    public <T> void withConductorFrozen(Function0<T> fun) {
        this.org$scalatest$concurrent$Conductor$$clock().withClockFrozen(fun);
    }

    public boolean isConductorFrozen() {
        return this.org$scalatest$concurrent$Conductor$$clock().isFrozen();
    }

    public final TestThreadsStartingCounter org$scalatest$concurrent$Conductor$$testThreadsStartingCounter() {
        return this.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter;
    }

    public final CountDownLatch org$scalatest$concurrent$Conductor$$greenLightForTestThreads() {
        return this.org$scalatest$concurrent$Conductor$$greenLightForTestThreads;
    }

    public void conduct() {
        int DefaultClockPeriod = 10;
        int DefaultRunLimit = 5;
        this.conduct(10, 5);
    }

    private AtomicReference<ConductorState> currentState() {
        return this.currentState;
    }

    public boolean conductingHasBegun() {
        return this.currentState().get().testWasStarted();
    }

    public void conduct(int clockPeriod, int timeout) {
        if (clockPeriod <= 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotPassNonPositiveClockPeriod", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)clockPeriod)).toString()})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        if (timeout <= 0) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotPassNonPositiveTimeout", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)timeout)).toString()})), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        if (this.conductingHasBegun()) {
            throw new NotAllowedException(Resources$.MODULE$.apply("cannotCallConductTwice"), StackDepthExceptionHelper$.MODULE$.getStackDepth("Conductor.scala", "conduct"));
        }
        this.currentState().set(this.TestStarted());
        this.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().waitUntilAllTestThreadsHaveStarted();
        this.org$scalatest$concurrent$Conductor$$greenLightForTestThreads().countDown();
        ClockThread clockThread = new ClockThread(this, clockPeriod, timeout);
        clockThread.start();
        this.waitForThreads();
        this.currentState().set(this.TestFinished());
        if (this.org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) {
            return;
        }
        throw this.org$scalatest$concurrent$Conductor$$firstExceptionThrown().peek();
    }

    private void waitForThreads() {
        BooleanRef interrupted$1 = new BooleanRef(false);
        while (!interrupted$1.elem && PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsAlive()) {
            PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$$threadGroup()).getThreads().foreach((Function1)new Serializable(this, interrupted$1){
                public static final long serialVersionUID;
                private final Conductor $outer;
                private final BooleanRef interrupted$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Thread t) {
                    if (!this.interrupted$1.elem && t.isAlive() && this.$outer.org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) {
                        try {
                            t.join();
                        }
                        catch (InterruptedException interruptedException) {
                            this.interrupted$1.elem = true;
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.interrupted$1 = booleanRef;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$ClockThread$ ClockThread() {
        if (this.ClockThread$module != null) return this.ClockThread$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.ClockThread$module == null) {
                this.ClockThread$module = new Conductor$ClockThread$(this);
            }
            return this.ClockThread$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$ConductorState$ ConductorState() {
        if (this.ConductorState$module != null) return this.ConductorState$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.ConductorState$module == null) {
                this.ConductorState$module = new Conductor$ConductorState$(this);
            }
            return this.ConductorState$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$Setup$ Setup() {
        if (this.Setup$module != null) return this.Setup$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.Setup$module == null) {
                this.Setup$module = new Conductor$Setup$(this);
            }
            return this.Setup$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$TestStarted$ TestStarted() {
        if (this.TestStarted$module != null) return this.TestStarted$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.TestStarted$module == null) {
                this.TestStarted$module = new Conductor$TestStarted$(this);
            }
            return this.TestStarted$module;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Conductor$TestFinished$ TestFinished() {
        if (this.TestFinished$module != null) return this.TestFinished$module;
        Conductor conductor = this;
        synchronized (conductor) {
            if (this.TestFinished$module == null) {
                this.TestFinished$module = new Conductor$TestFinished$(this);
            }
            return this.TestFinished$module;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Clock
    implements ScalaObject {
        private int org$scalatest$concurrent$Conductor$Clock$$currentTime;
        private final Object lock;
        private final ReentrantReadWriteLock rwLock;
        private int highestBeatBeingWaitedOn;
        public final Conductor $outer;

        public final int org$scalatest$concurrent$Conductor$Clock$$currentTime() {
            return this.org$scalatest$concurrent$Conductor$Clock$$currentTime;
        }

        public final void org$scalatest$concurrent$Conductor$Clock$$currentTime_$eq(int n) {
            this.org$scalatest$concurrent$Conductor$Clock$$currentTime = n;
        }

        private Object lock() {
            return this.lock;
        }

        private ReentrantReadWriteLock rwLock() {
            return this.rwLock;
        }

        private int highestBeatBeingWaitedOn() {
            return this.highestBeatBeingWaitedOn;
        }

        private void highestBeatBeingWaitedOn_$eq(int n) {
            this.highestBeatBeingWaitedOn = n;
        }

        public void advance() {
            Object object = this.lock();
            synchronized (object) {
                PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).write(new Serializable(this){
                    public static final long serialVersionUID;
                    private final Clock $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.$outer.org$scalatest$concurrent$Conductor$Clock$$currentTime_$eq(this.$outer.org$scalatest$concurrent$Conductor$Clock$$currentTime() + 1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.lock().notifyAll();
                return;
            }
        }

        public int currentBeat() {
            Object object = this.lock();
            synchronized (object) {
                Object t = PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).read(new Serializable(this){
                    public static final long serialVersionUID;
                    private final Clock $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply() {
                        return this.$outer.org$scalatest$concurrent$Conductor$Clock$$currentTime();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                return BoxesRunTime.unboxToInt(t);
            }
        }

        public void waitForBeat(int beat) {
            Object object = this.lock();
            synchronized (object) {
                if (beat > this.highestBeatBeingWaitedOn()) {
                    this.highestBeatBeingWaitedOn_$eq(beat);
                }
                while (this.currentBeat() < beat) {
                    this.liftedTree1$1();
                }
                return;
            }
        }

        public boolean isAnyThreadWaitingForABeat() {
            Object object = this.lock();
            synchronized (object) {
                Boolean bl = BoxesRunTime.boxToBoolean((this.highestBeatBeingWaitedOn() > this.org$scalatest$concurrent$Conductor$Clock$$currentTime() ? 1 : 0) != 0);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
        }

        public <T> T withClockFrozen(Function0<T> fun) {
            return PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock()).read(fun);
        }

        public boolean isFrozen() {
            return this.rwLock().getReadLockCount() > 0;
        }

        public Conductor org$scalatest$concurrent$Conductor$Clock$$$outer() {
            return this.$outer;
        }

        private final void liftedTree1$1() {
            try {
                this.lock().wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)interruptedException);
            }
        }

        public Clock(Conductor $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.org$scalatest$concurrent$Conductor$Clock$$currentTime = 0;
            this.lock = new Object();
            this.rwLock = new ReentrantReadWriteLock();
            this.highestBeatBeingWaitedOn = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestThread
    extends Thread
    implements ScalaObject,
    Product,
    Serializable {
        private final String name;
        private final Function0<BoxedUnit> f;
        public final Conductor $outer;

        public String name() {
            return this.name;
        }

        public Function0<BoxedUnit> f() {
            return this.f;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().decrement();
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$greenLightForTestThreads().await();
                    this.f().apply();
                }
                catch (Throwable throwable) {
                    if (!this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) break block2;
                    this.org$scalatest$concurrent$Conductor$TestThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(throwable);
                }
            }
        }

        public Function0 copy$default$2() {
            return this.f();
        }

        public String copy$default$1() {
            return this.name();
        }

        public TestThread copy(String name, Function0 f) {
            return new TestThread(this.org$scalatest$concurrent$Conductor$TestThread$$$outer(), name, (Function0<BoxedUnit>)f);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            Function0<BoxedUnit> function0;
            Function0<BoxedUnit> f$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof TestThread)) return false;
            if (((TestThread)object2).org$scalatest$concurrent$Conductor$TestThread$$$outer() != this.org$scalatest$concurrent$Conductor$TestThread$$$outer()) return false;
            TestThread testThread = (TestThread)object2;
            String string = testThread.name();
            String name$1 = string;
            if (!this.gd1$1(name$1, f$1 = (function0 = testThread.f()))) return false;
            boolean bl = ((TestThread)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "TestThread";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Function0<BoxedUnit> function0;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    function0 = this.name();
                    break;
                }
                case 1: {
                    function0 = this.f();
                }
            }
            return function0;
        }

        public boolean canEqual(Object object) {
            return object instanceof TestThread;
        }

        public Conductor org$scalatest$concurrent$Conductor$TestThread$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(String string, Function0 function0) {
            String string2 = string;
            String string3 = this.name();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Function0 function02 = function0;
            Function0<BoxedUnit> function03 = this.f();
            if (function02 == null) {
                if (function03 == null) return true;
                return false;
            } else {
                if (!function02.equals(function03)) return false;
                return true;
            }
        }

        public TestThread(Conductor $outer, String name, Function0<BoxedUnit> f) {
            this.name = name;
            this.f = f;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.org$scalatest$concurrent$Conductor$$threadGroup(), name);
            Product.class.$init$((Product)this);
            $outer.org$scalatest$concurrent$Conductor$$testThreadsStartingCounter().increment();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClockThread
    extends Thread
    implements ScalaObject,
    Product,
    Serializable {
        private final int clockPeriod;
        private final int maxRunTime;
        private long lastProgress;
        private int deadlockCount;
        private final int MaxDeadlockDetectionsBeforeDeadlock;
        public final Conductor $outer;

        public int clockPeriod() {
            return this.clockPeriod;
        }

        public int maxRunTime() {
            return this.maxRunTime;
        }

        private long lastProgress() {
            return this.lastProgress;
        }

        private void lastProgress_$eq(long l) {
            this.lastProgress = l;
        }

        private int deadlockCount() {
            return this.deadlockCount;
        }

        private void deadlockCount_$eq(int n) {
            this.deadlockCount = n;
        }

        private int MaxDeadlockDetectionsBeforeDeadlock() {
            return this.MaxDeadlockDetectionsBeforeDeadlock;
        }

        @Override
        public void run() {
            while (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsAlive()) {
                if (this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().isEmpty()) {
                    if (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsRunning()) {
                        if (this.runningTooLong()) {
                            this.timeout();
                        }
                    } else if (this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$clock().isAnyThreadWaitingForABeat()) {
                        this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$clock().advance();
                        this.deadlockCount_$eq(0);
                        this.lastProgress_$eq(System.currentTimeMillis());
                    } else if (!PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).areAnyThreadsInTimedWaiting()) {
                        this.detectDeadlock();
                    }
                } else {
                    PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$threadGroup()).getThreads().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Thread t) {
                            if (t.isAlive()) {
                                t.stop();
                            }
                        }
                    });
                }
                Thread.sleep(this.clockPeriod());
            }
        }

        private boolean runningTooLong() {
            return System.currentTimeMillis() - this.lastProgress() > 1000L * (long)this.maxRunTime();
        }

        private void timeout() {
            String errorMessage = Resources$.MODULE$.apply("testTimedOut", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.maxRunTime())).toString()}));
            this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(new RuntimeException(errorMessage));
            this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$mainThread().interrupt();
        }

        private void detectDeadlock() {
            if (this.deadlockCount() >= this.MaxDeadlockDetectionsBeforeDeadlock()) {
                String errorMessage = Resources$.MODULE$.apply("suspectedDeadlock", (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{((Object)BoxesRunTime.boxToInteger((int)this.MaxDeadlockDetectionsBeforeDeadlock())).toString(), ((Object)BoxesRunTime.boxToInteger((int)(this.clockPeriod() * this.MaxDeadlockDetectionsBeforeDeadlock()))).toString()}));
                this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$firstExceptionThrown().offer(new RuntimeException(errorMessage));
                this.org$scalatest$concurrent$Conductor$ClockThread$$$outer().org$scalatest$concurrent$Conductor$$mainThread().interrupt();
            } else {
                this.deadlockCount_$eq(this.deadlockCount() + 1);
            }
        }

        public int copy$default$2() {
            return this.maxRunTime();
        }

        public int copy$default$1() {
            return this.clockPeriod();
        }

        public ClockThread copy(int clockPeriod, int maxRunTime) {
            return new ClockThread(this.org$scalatest$concurrent$Conductor$ClockThread$$$outer(), clockPeriod, maxRunTime);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            int n;
            int maxRunTime$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof ClockThread)) return false;
            if (((ClockThread)object2).org$scalatest$concurrent$Conductor$ClockThread$$$outer() != this.org$scalatest$concurrent$Conductor$ClockThread$$$outer()) return false;
            ClockThread clockThread = (ClockThread)object2;
            int n2 = clockThread.clockPeriod();
            int clockPeriod$1 = n2;
            if (!this.gd2$1(clockPeriod$1, maxRunTime$1 = (n = clockThread.maxRunTime()))) return false;
            boolean bl = ((ClockThread)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "ClockThread";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Integer n2;
            int n3 = n;
            switch (n3) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    n2 = BoxesRunTime.boxToInteger((int)this.clockPeriod());
                    break;
                }
                case 1: {
                    n2 = BoxesRunTime.boxToInteger((int)this.maxRunTime());
                }
            }
            return n2;
        }

        public boolean canEqual(Object object) {
            return object instanceof ClockThread;
        }

        public Conductor org$scalatest$concurrent$Conductor$ClockThread$$$outer() {
            return this.$outer;
        }

        private final boolean gd2$1(int n, int n2) {
            return n == this.clockPeriod() && n2 == this.maxRunTime();
        }

        public ClockThread(Conductor $outer, int clockPeriod, int maxRunTime) {
            this.clockPeriod = clockPeriod;
            this.maxRunTime = maxRunTime;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super("Conductor-Clock");
            Product.class.$init$((Product)this);
            this.setDaemon(true);
            this.lastProgress = System.currentTimeMillis();
            this.deadlockCount = 0;
            this.MaxDeadlockDetectionsBeforeDeadlock = 50;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConductorState
    implements ScalaObject,
    Product,
    Serializable {
        private final boolean testWasStarted;
        private final boolean testIsFinished;
        public final Conductor $outer;

        public boolean testWasStarted() {
            return this.testWasStarted;
        }

        public boolean testIsFinished() {
            return this.testIsFinished;
        }

        public boolean copy$default$2() {
            return this.testIsFinished();
        }

        public boolean copy$default$1() {
            return this.testWasStarted();
        }

        public ConductorState copy(boolean testWasStarted, boolean testIsFinished) {
            return new ConductorState(this.org$scalatest$concurrent$Conductor$ConductorState$$$outer(), testWasStarted, testIsFinished);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean testIsFinished$1;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof ConductorState)) return false;
            if (((ConductorState)object2).org$scalatest$concurrent$Conductor$ConductorState$$$outer() != this.org$scalatest$concurrent$Conductor$ConductorState$$$outer()) return false;
            ConductorState conductorState = (ConductorState)object2;
            boolean bl2 = conductorState.testWasStarted();
            boolean testWasStarted$1 = bl2;
            if (!this.gd3$1(testWasStarted$1, testIsFinished$1 = (bl = conductorState.testIsFinished()))) return false;
            boolean bl3 = ((ConductorState)object).canEqual(this);
            if (!bl3) return false;
            return true;
        }

        public String productPrefix() {
            return "ConductorState";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int n) {
            Boolean bl;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 0: {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.testWasStarted());
                    break;
                }
                case 1: {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.testIsFinished());
                }
            }
            return bl;
        }

        public boolean canEqual(Object object) {
            return object instanceof ConductorState;
        }

        public Conductor org$scalatest$concurrent$Conductor$ConductorState$$$outer() {
            return this.$outer;
        }

        private final boolean gd3$1(boolean bl, boolean bl2) {
            return bl == this.testWasStarted() && bl2 == this.testIsFinished();
        }

        public ConductorState(Conductor $outer, boolean testWasStarted, boolean testIsFinished) {
            this.testWasStarted = testWasStarted;
            this.testIsFinished = testIsFinished;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

