/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import org.scalatest.Assertions;
import org.scalatest.Engine;
import org.scalatest.FunSuite;
import org.scalatest.Suite;
import org.scalatest.Tag;
import org.scalatest.matchers.Matchers;
import org.scalatest.matchers.Matchers$ByteTolerance$;
import org.scalatest.matchers.Matchers$DoubleTolerance$;
import org.scalatest.matchers.Matchers$FloatTolerance$;
import org.scalatest.matchers.Matchers$IntTolerance$;
import org.scalatest.matchers.Matchers$LongTolerance$;
import org.scalatest.matchers.Matchers$ShortTolerance$;
import org.scalatest.matchers.ShouldMatchers;
import org.scalatest.matchers.ShouldMatchers$ShouldMethodHelper$;
import org.scalatest.tools.StringReporter$;
import org.scalatest.tools.StringReporterSuite$;
import org.scalatest.verb.ShouldVerb;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u0013\t\u00192\u000b\u001e:j]\u001e\u0014V\r]8si\u0016\u00148+^5uK*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0003\u000b\u0019\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003\u001d\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0006\u0013-q\u0001\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0003'Qi\u0011\u0001B\u0005\u0003+\u0011\u0011\u0001BR;o'VLG/\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t\u0001\"\\1uG\",'o]\u0005\u00037a\u0011ab\u00155pk2$W*\u0019;dQ\u0016\u00148\u000f\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcDA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\u0003\u0011\u001dA\u0003A1A\u0005\u0002%\n\u0011bY=b]J+w-\u001a=\u0016\u0003)\u0002\"aC\u0016\n\u00051b!AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006IAK\u0001\u000bGf\fgNU3hKb\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t!K\u0001\u000be\u0016\u001cX\r\u001e*fO\u0016D\bB\u0002\u001a\u0001A\u0003%!&A\u0006sKN,GOU3hKb\u0004\u0003\"\u0002\u001b\u0001\t\u0003)\u0014a\u00019bIR\u0011!F\u000e\u0005\u0006oM\u0002\r\u0001O\u0001\u0002gB\u0011\u0011\b\u0010\b\u0003;iJ!a\u000f\u0010\u0002\rA\u0013X\rZ3g\u0013\taSH\u0003\u0002<=!)q\b\u0001C\u0001\u0001\u0006I1m\\;oi\u000eK\u0018M\u001c\u000b\u0003\u0003\u0012\u0003\"!\b\"\n\u0005\rs\"aA%oi\")qG\u0010a\u0001q!)a\t\u0001C\u0001\u000f\u0006Q1m\\;oiJ+7/\u001a;\u0015\u0005\u0005C\u0005\"B\u001cF\u0001\u0004A\u0004")
public class StringReporterSuite
implements FunSuite,
ShouldMatchers,
ScalaObject {
    private final String cyanRegex;
    private final String resetRegex;
    private final Matchers.NotWord not;
    private final Matchers.BeWord be;
    private final Matchers.HaveWord have;
    private final Matchers.ContainWord contain;
    private final Matchers.IncludeWord include;
    private final Matchers.FullyMatchWord fullyMatch;
    private final Matchers.StartWithWord startWith;
    private final Matchers.EndWithWord endWith;
    private final Matchers.LengthWord length;
    private final Matchers.SizeWord size;
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Engine org$scalatest$FunSuite$$engine;
    private volatile ShouldMatchers$ShouldMethodHelper$ org$scalatest$matchers$ShouldMatchers$$ShouldMethodHelper$module;
    private volatile Matchers$DoubleTolerance$ DoubleTolerance$module;
    private volatile Matchers$FloatTolerance$ FloatTolerance$module;
    private volatile Matchers$LongTolerance$ LongTolerance$module;
    private volatile Matchers$IntTolerance$ IntTolerance$module;
    private volatile Matchers$ShortTolerance$ ShortTolerance$module;
    private volatile Matchers$ByteTolerance$ ByteTolerance$module;

    public String cyanRegex() {
        return this.cyanRegex;
    }

    public String resetRegex() {
        return this.resetRegex;
    }

    public String pad(String s) {
        return new StringBuilder().append((Object)" ").append((Object)s).append((Object)" ").toString();
    }

    public int countCyan(String s) {
        return this.pad(s).split(this.cyanRegex()).length - 1;
    }

    public int countReset(String s) {
        return this.pad(s).split(this.resetRegex()).length - 1;
    }

    public StringReporterSuite() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        FunSuite.class.$init$((FunSuite)this);
        Matchers.class.$init$((Matchers)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        ShouldMatchers.class.$init$((ShouldMatchers)this);
        this.test("Empty string should just come back as an empty string.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.$outer.assert(this.$outer.convertToEqualizer(StringReporter$.MODULE$.colorizeLinesIndividually("", "\u001b[36m")).$eq$eq$eq((Object)""));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Blank string should just come back as the same string.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.$outer.assert(this.$outer.convertToEqualizer(StringReporter$.MODULE$.colorizeLinesIndividually(" ", "\u001b[36m")).$eq$eq$eq((Object)" "));
                this.$outer.assert(this.$outer.convertToEqualizer(StringReporter$.MODULE$.colorizeLinesIndividually("  ", "\u001b[36m")).$eq$eq$eq((Object)"  "));
                this.$outer.assert(this.$outer.convertToEqualizer(StringReporter$.MODULE$.colorizeLinesIndividually("   ", "\u001b[36m")).$eq$eq$eq((Object)"   "));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.cyanRegex = "\u001b\\[36m";
        this.resetRegex = "\u001b\\[0m";
        this.test("A non-blank string with no EOLs should come back surrounded by ansiColor and ansiReset, with no other occurrences of them in the returned string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                String aResult = StringReporter$.MODULE$.colorizeLinesIndividually("a", "\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.startWith().apply("\u001b[36m"));
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.endWith().apply("\u001b[0m"));
                this.$outer.convertToIntShouldWrapper(this.$outer.countCyan(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToIntShouldWrapper(this.$outer.countReset(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("A non-blank string with one EOL should come back surrounded by ansiColor and ansiReset, with two occurrences of them in the returned string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                String aResult = StringReporter$.MODULE$.colorizeLinesIndividually("a\nb", "\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.startWith().apply("\u001b[36m"));
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.endWith().apply("\u001b[0m"));
                this.$outer.convertToIntShouldWrapper(this.$outer.countCyan(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(this.$outer.countReset(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("countTrailingEOLs should return the number of EOLs at the end of the passed string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("howdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("hohoho\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\n\nhohoho\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\n\nhohoho\nhowdy\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("\n\nhohoho\nhowdy")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("not a single one ")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countTrailingEOLs("not a single one")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("countLeadingEOLs should return the number of EOLs at the beginning of the passed string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n\nhowdy")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n\nhowdy\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n\nhohoho\nhowdy")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\n\nhohoho\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("\nhohoho\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("hohoho\nhowdy\n\n")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("not a single one ")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.convertToIntShouldWrapper(StringReporter$.MODULE$.countLeadingEOLs("not a single one")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("A non-blank string with one EOL in the middle and one EOL at the end should come back with the first two strings surrounded by ansiColor and ansiReset, but nothing after the trailing EOL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                String aResult = StringReporter$.MODULE$.colorizeLinesIndividually("a\nb\n", "\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.startWith().apply("\u001b[36m"));
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.not()).endWith("\u001b[0m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.endWith().apply("\u001b[0m\n"));
                this.$outer.convertToIntShouldWrapper(this.$outer.countCyan(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(this.$outer.countReset(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("A non-blank string with one EOL in the middle and two EOLs at the end should come back with the first two strings surrounded by ansiColor and ansiReset, but nothing after the trailing EOLs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                String aResult = StringReporter$.MODULE$.colorizeLinesIndividually("a\nb\n\n", "\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.startWith().apply("\u001b[36m"));
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.not()).endWith("\u001b[0m");
                this.$outer.convertToStringShouldWrapper(aResult).should(this.$outer.endWith().apply("\u001b[0m\n\n"));
                this.$outer.convertToIntShouldWrapper(this.$outer.countCyan(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
                this.$outer.convertToIntShouldWrapper(this.$outer.countReset(aResult)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("A non-blank string with one EOL in the middle and one EOL at the beginning should come back with the last two strings surrounded by ansiColor and ansiReset, but nothing before the initial EOL", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final StringReporterSuite $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                String aResult$1 = StringReporter$.MODULE$.colorizeLinesIndividually("\na\nb", "\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult$1).should(this.$outer.not()).startWith("\u001b[36m");
                this.$outer.convertToStringShouldWrapper(aResult$1).should(this.$outer.endWith().apply("\u001b[0m"));
                this.$outer.convertToStringShouldWrapper(aResult$1).should(this.$outer.startWith().apply("\n\u001b[36m"));
                this.$outer.withClue(new StringBuilder().append((Object)"\"").append((Object)Predef$.MODULE$.augmentString(aResult$1).toList().mkString(" ").replaceAll("\n", "EOL")).append((Object)"\"").toString(), (Function0)new Serializable(this, aResult$1){
                    public static final long serialVersionUID;
                    private final $anonfun$9 $outer;
                    private final String aResult$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().convertToIntShouldWrapper(this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().countCyan(this.aResult$1)).should(this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().equal(BoxesRunTime.boxToInteger((int)2)));
                        this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().convertToIntShouldWrapper(this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().countReset(this.aResult$1)).should(this.$outer.org$scalatest$tools$StringReporterSuite$$anonfun$$$outer().equal(BoxesRunTime.boxToInteger((int)2)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.aResult$1 = string;
                    }
                });
            }

            public StringReporterSuite org$scalatest$tools$StringReporterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

