/*
 * Copyright 2001-2008 Artima, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.scalatest.junit

import org.scalatest._
import _root_.junit.framework.AssertionFailedError
import org.scalatest.WordSpec

class MustMatchersForJUnitWordSpec extends WordSpec with MustMatchersForJUnit
  with AssertionsForJUnit3SharedTests {

  val throwAssertionFailedError = afterWord("throw AssertionFailedError")

  "the MustMatchersForJUnit3 trait" must throwAssertionFailedError {

    // MustMatchersForJUnit3 mixes in AssertionsForJUnit3, so MustMatchersForJUnit3
    // must behave like AsssertionsForJUnit3. (I don't want to use the 'behave like'
    // sugar here, because I want to use the throwAssertionFailedError "after word," and
    // it doesn't read well with the sugar in that case
    fromAssertExpectInterceptAndFail()

    "from failed MustMatcher expressions" in {
      intercept[AssertionFailedError] {
       7 must equal (3)
      }
      intercept[AssertionFailedError] {
       "hi" must have length 3
      }
      intercept[AssertionFailedError] {
       Set(1, 2, 3) must have size (4)
      }
      intercept[AssertionFailedError] {
        "hello, world" must startWith ("world")
      }
      intercept[AssertionFailedError] {
        "hello, world" must endWith ("hello")
      }
      intercept[AssertionFailedError] {
        "hello, world" must include ("seven")
      }
      intercept[AssertionFailedError] {
        "hello, world" must startWith regex ("wor*")
      }
      intercept[AssertionFailedError] {
        "hello, world" must endWith regex ("hel*")
      }
      intercept[AssertionFailedError] {
        "hello, world" must include regex ("sev.n")
      }
      intercept[AssertionFailedError] {
       "hi" must fullyMatch regex ("""(-)?(\d+)(\.\d*)?""")
      }
      intercept[AssertionFailedError] {
        7 must be < (7)
      }
      intercept[AssertionFailedError] {
        -1 must be > (0)
      }
      intercept[AssertionFailedError] {
        8 must be <= (7)
      }
      intercept[AssertionFailedError] {
        6 must be >= (7)
      }
      intercept[AssertionFailedError] {
       Set(1, 2, 3) must be ('empty)
      }
      intercept[AssertionFailedError] {
       (new Object) must be theSameInstanceAs (new Object)
      }
      intercept[AssertionFailedError] {
       21.0 must be (6.9 plusOrMinus 0.2)
      }
      intercept[AssertionFailedError] {
       17 must be (6 plusOrMinus 2)
      }
      intercept[AssertionFailedError] {
       List(1, 2, 3) must contain (5)
      }
      intercept[AssertionFailedError] {
       Map("hi" -> 1) must contain key ("ho")
      }
      intercept[AssertionFailedError] {
        Map("hi" -> 1) must contain value (9)
      }
      intercept[AssertionFailedError] {
       "hi" must be ("ho")
      }
      intercept[AssertionFailedError] {
       "hi" must not be ("hi")
      }
      intercept[AssertionFailedError] {
       10 must not be <= (11)
      }
      intercept[AssertionFailedError] {
       Map("hi" -> 5) must (contain key ("hi") and not contain value (5))
      }
      intercept[AssertionFailedError] {
       "ho ho ho" must (
         equal ("fee") or
         equal ("fie") or
         equal ("foe") or
         equal ("fum")
        )
      }
      intercept[AssertionFailedError] {
       11 must (be > (0) and be <= (10))
      }
    }

    "including as its cause an unexpected exception" in {
      val wrongException = new RuntimeException("oops!")
      val caught =
        intercept[AssertionFailedError] {
          evaluating { throw wrongException } must produce [IllegalArgumentException]
        }
      assert(caught.getCause eq wrongException)
    }
  }
}

