/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.Location;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.exceptions.PayloadField;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001\tA!!D'z%VtG*[:uK:,'O\u0003\u0002\u0004\t\u0005)!.\u001e8ji*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7c\u0001\u0001\n%A\u0011!\u0002E\u0007\u0002\u0017)\u0011A\"D\u0001\r]>$\u0018NZ5dCRLwN\u001c\u0006\u0003\u001d=\taA];o]\u0016\u0014(BA\u0002\u0007\u0013\t\t2BA\u0006Sk:d\u0015n\u001d;f]\u0016\u0014\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0007e\u0016\u0004xN\u001d;\u0004\u0001A\u0011A$H\u0007\u0002\t%\u0011a\u0004\u0002\u0002\t%\u0016\u0004xN\u001d;fe\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0004d_:4\u0017n\u001a\t\u0005E\u0015B3F\u0004\u0002\u0014G%\u0011A\u0005F\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#aA'ba*\u0011A\u0005\u0006\t\u0003E%J!AK\u0014\u0003\rM#(/\u001b8h!\t\u0019B&\u0003\u0002.)\t\u0019\u0011I\\=\t\u0011=\u0002!\u0011!Q\u0001\nA\n!\u0002\u001e5f)J\f7m[3s!\ta\u0012'\u0003\u00023\t\t9AK]1dW\u0016\u0014\b\"\u0002\u001b\u0001\t\u0003)\u0014A\u0002\u001fj]&$h\b\u0006\u00037qeR\u0004CA\u001c\u0001\u001b\u0005\u0011\u0001\"B\r4\u0001\u0004Y\u0002\"\u0002\u00114\u0001\u0004\t\u0003\"B\u00184\u0001\u0004\u0001\u0004b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\fM\u0006LG.\u001a3UKN$8/F\u0001?!\ryD\tK\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%aA*fi\"1q\t\u0001Q\u0001\ny\nABZ1jY\u0016$G+Z:ug\u0002BQ!\u0013\u0001\u0005\u0002)\u000babZ3u)>\u0004xJZ'fi\"|G\rF\u0002L)Z\u00032a\u0005'O\u0013\tiEC\u0001\u0003T_6,\u0007CA(S\u001b\u0005\u0001&BA)\u0005\u0003\u0019)g/\u001a8ug&\u00111\u000b\u0015\u0002\f)>\u0004xJZ'fi\"|G\rC\u0003V\u0011\u0002\u0007\u0001&A\u0005dY\u0006\u001c8OT1nK\")q\u000b\u0013a\u0001Q\u0005QQ.\u001a;i_\u0012t\u0015-\\3\t\u000be\u0003A\u0011\t.\u0002\u0017Q,7\u000f\u001e$bS2,(/\u001a\u000b\u00037z\u0003\"a\u0005/\n\u0005u#\"\u0001B+oSRDQa\u0018-A\u0002\u0001\fqAZ1jYV\u0014X\r\u0005\u0002\u000bC&\u0011!m\u0003\u0002\b\r\u0006LG.\u001e:f\u0011\u0015!\u0007\u0001\"\u0011f\u00031!Xm\u001d;GS:L7\u000f[3e)\tYf\rC\u0003hG\u0002\u0007\u0001.A\u0006eKN\u001c'/\u001b9uS>t\u0007CA5k\u001b\u0005i\u0011BA6\u000e\u0005-!Um]2sSB$\u0018n\u001c8\t\u000b5\u0004A\u0011\t8\u0002\u0017Q,7\u000f^%h]>\u0014X\r\u001a\u000b\u00037>DQa\u001a7A\u0002!DQ!\u001d\u0001\u0005BI\fq\u0002^3tiJ+hNR5oSNDW\r\u001a\u000b\u00037NDQ\u0001\u001e9A\u0002U\faA]3tk2$\bCA5w\u0013\t9XB\u0001\u0004SKN,H\u000e\u001e\u0005\u0006s\u0002!\tE_\u0001\u000fi\u0016\u001cHOU;o'R\f'\u000f^3e)\tY6\u0010C\u0003hq\u0002\u0007\u0001\u000eC\u0003~\u0001\u0011\u0005c0A\u0006uKN$8\u000b^1si\u0016$GCA.\u0000\u0011\u00159G\u00101\u0001i\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)!\u0001\rU\u000bN#v\fR#T\u0007JK\u0005\u000bV%P\u001d~\u0003\u0016\t\u0016+F%:+\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004A\u0003\u0015\u0011XmZ3y\u0013\u0011\t\t\"a\u0003\u0003\u000fA\u000bG\u000f^3s]\"A\u0011Q\u0003\u0001!\u0002\u0013\t9!A\rU\u000bN#v\fR#T\u0007JK\u0005\u000bV%P\u001d~\u0003\u0016\t\u0016+F%:\u0003\u0003bBA\r\u0001\u0011%\u00111D\u0001\u0015a\u0006\u00148/\u001a+fgR$Um]2sSB$\u0018n\u001c8\u0015\t\u0005u\u00111\u0005\t\u0007'\u0005}\u0001\u0006\u000b\u0015\n\u0007\u0005\u0005BC\u0001\u0004UkBdWm\r\u0005\u0007O\u0006]\u0001\u0019\u00015")
public class MyRunListener
extends RunListener
implements ScalaObject {
    private final Reporter report;
    private final Tracker theTracker;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return new Some((Object)new TopOfMethod(className, new StringBuilder().append((Object)"public void ").append((Object)className).append((Object)".").append((Object)methodName).append((Object)"()").toString()));
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            Throwable throwableOrNull = failure.getException();
            None$ throwable = throwableOrNull == null ? None$.MODULE$ : new Some((Object)throwableOrNull);
            String message = throwableOrNull == null ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
            IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
            None$ none$ = throwable;
            Option<Object> payload = none$ instanceof Option && none$ instanceof PayloadField ? ((PayloadField)none$).payload() : None$.MODULE$;
            this.report.apply(new TestFailed(this.theTracker.nextOrdinal(), message, testClassName, testClass, (Option<String>)new Some((Object)testClass), Suite$.MODULE$.getDecodedName(testClassName), testName, testName, Suite$.MODULE$.getDecodedName(testName), (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), (Option<String>)None$.MODULE$, payload, TestFailed$.MODULE$.apply$default$17(), TestFailed$.MODULE$.apply$default$18()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testFinished(Description description) {
        Tuple3<String, String, String> tuple3;
        block3: {
            block2: {
                if (this.failedTests().contains(description.getDisplayName())) break block2;
                tuple3 = this.parseTestDescription(description);
                if (tuple3 == null) break block3;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                String testName = (String)tuple32._1();
                String testClass = (String)tuple32._2();
                String testClassName = (String)tuple32._3();
                IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
                this.report.apply(new TestSucceeded(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), Suite$.MODULE$.getDecodedName(testClassName), testName, testName, Suite$.MODULE$.getDecodedName(testName), (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<String>)TestSucceeded$.MODULE$.apply$default$13(), (Option<Object>)TestSucceeded$.MODULE$.apply$default$14(), TestSucceeded$.MODULE$.apply$default$15(), TestSucceeded$.MODULE$.apply$default$16()));
            }
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
            this.report.apply(new TestIgnored(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), Suite$.MODULE$.getDecodedName(testClassName), testName, testName, Suite$.MODULE$.getDecodedName(testName), (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<Object>)TestIgnored$.MODULE$.apply$default$11(), TestIgnored$.MODULE$.apply$default$12(), TestIgnored$.MODULE$.apply$default$13()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            this.report.apply(new TestStarting(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), Suite$.MODULE$.getDecodedName(testClassName), testName, testName, Suite$.MODULE$.getDecodedName(testName), (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<String>)TestStarting$.MODULE$.apply$default$11(), (Option<Object>)TestStarting$.MODULE$.apply$default$12(), TestStarting$.MODULE$.apply$default$13(), TestStarting$.MODULE$.apply$default$14()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker) {
        this.report = report;
        this.theTracker = theTracker;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

