/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scalactic.Prettifier$;
import org.scalactic.Requirements$;
import org.scalactic.exceptions.NullArgumentException;
import org.scalactic.source.Position;
import org.scalatest.ConfigMap;
import org.scalatest.Resources$;
import org.scalatest.tools.FilterInfoProvided$;
import org.scalatest.tools.FilterMarkupProvided$;
import org.scalatest.tools.FilterScopeClosed$;
import org.scalatest.tools.FilterScopeOpened$;
import org.scalatest.tools.FilterScopePending$;
import org.scalatest.tools.FilterSuiteCompleted$;
import org.scalatest.tools.FilterSuiteStarting$;
import org.scalatest.tools.FilterTestIgnored$;
import org.scalatest.tools.FilterTestPending$;
import org.scalatest.tools.FilterTestStarting$;
import org.scalatest.tools.FilterTestSucceeded$;
import org.scalatest.tools.ParsedArgs;
import org.scalatest.tools.PresentAllDurations$;
import org.scalatest.tools.PresentFilePathname$;
import org.scalatest.tools.PresentFullStackTraces$;
import org.scalatest.tools.PresentReminderWithFullStackTraces$;
import org.scalatest.tools.PresentReminderWithShortStackTraces$;
import org.scalatest.tools.PresentReminderWithoutCanceledTests$;
import org.scalatest.tools.PresentReminderWithoutStackTraces$;
import org.scalatest.tools.PresentShortStackTraces$;
import org.scalatest.tools.PresentUnformatted$;
import org.scalatest.tools.PresentWithoutColor$;
import org.scalatest.tools.ReporterConfigParam;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ArgsParser$ {
    public static ArgsParser$ MODULE$;
    private final Pattern ROOT_DIR_PATTERN;
    private final Pattern START_TOKEN_PATTERN;
    private final Pattern FULL_TOKEN_PATTERN;

    static {
        new ArgsParser$();
    }

    public Option<String> checkArgsForValidity(String[] args) {
        None$ none$;
        if (args == null) {
            throw new IllegalArgumentException("args was null.");
        }
        ListBuffer lb = new ListBuffer();
        BufferedIterator it = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).iterator().buffered();
        while (it.hasNext()) {
            Object object;
            String s = (String)it.next();
            if (s.startsWith("-r")) {
                throw new IllegalArgumentException("ERROR: -r has been deprecated for a very long time and is no longer supported, to prepare for reusing it for a different purpose in the near future. Please change all uses of -r to -C.");
            }
            if (s.startsWith("-c")) {
                throw new IllegalArgumentException("ERROR: -c has been deprecated for a very long time and is no longer supported, to prepare for reusing it for a different purpose in the near future. Please change all uses of -c to -P.");
            }
            if (s.startsWith("-p")) {
                throw new IllegalArgumentException("ERROR: -p has been deprecated for a very long time and is no longer supported, to prepare for reusing it for a different purpose in the near future. Please change all uses of -p to -R.");
            }
            if (s.startsWith("-R") || s.startsWith("-f") || s.startsWith("-M") || s.startsWith("-A") || s.startsWith("-u") || s.startsWith("-C") || s.startsWith("-n") || s.startsWith("-l") || s.startsWith("-s") || s.startsWith("-i") || s.startsWith("-j") || s.startsWith("-m") || s.startsWith("-w") || s.startsWith("-b") || s.startsWith("-y") || s.startsWith("-t") || s.startsWith("-z") || s.startsWith("-q") || s.startsWith("-Q") || s.startsWith("-F") || s.startsWith("-T")) {
                if (it.hasNext()) {
                    object = it.next();
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (s.startsWith("-k") || s.startsWith("-K") || s.startsWith("-W")) {
                Object object2 = it.hasNext() ? it.next() : BoxedUnit.UNIT;
                if (it.hasNext()) {
                    object = it.next();
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (s.startsWith("-h")) {
                Object object3 = it.hasNext() ? it.next() : BoxedUnit.UNIT;
                if (it.hasNext()) {
                    Object object4 = it.head();
                    String string = "-Y";
                    if (!(object4 != null ? !object4.equals(string) : string != null)) {
                        it.next();
                        object = it.next();
                        continue;
                    }
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = !s.startsWith("-D") && !s.startsWith("-g") && !s.startsWith("-o") && !s.startsWith("-e") && !s.startsWith("-P") ? lb.$plus$eq((Object)s) : BoxedUnit.UNIT;
        }
        List argsList = lb.toList();
        if (argsList.length() != 0) {
            String argWord = "Argument" + (argsList.size() == 1 ? "" : "s");
            none$ = new Some((Object)(argWord + " unrecognized by ScalaTest's Runner: " + argsList.mkString("", ", ", ".")));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Pattern> genSuffixesPattern(List<String> suffixesList) {
        return suffixesList.isEmpty() ? None$.MODULE$ : new Some((Object)Pattern.compile(".*(" + suffixesList.mkString("|") + ")$"));
    }

    public ParsedArgs parseArgs(String[] args) {
        ListBuffer reporters = new ListBuffer();
        ListBuffer suites = new ListBuffer();
        ListBuffer includes = new ListBuffer();
        ListBuffer excludes = new ListBuffer();
        ListBuffer membersOnly = new ListBuffer();
        ListBuffer wildcard = new ListBuffer();
        ListBuffer suffixes = new ListBuffer();
        BufferedIterator it = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).iterator().buffered();
        while (it.hasNext()) {
            ListBuffer listBuffer;
            String s = (String)it.next();
            if (s.startsWith("-D")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            if (s.startsWith("-R")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            if (s.startsWith("-g")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            if (s.startsWith("-o")) {
                listBuffer = reporters.$plus$eq((Object)s);
                continue;
            }
            if (s.startsWith("-e")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            if (s.startsWith("-f")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string = s;
            String string2 = "-M";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string3 = s;
            String string4 = "-u";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            if (s.startsWith("-h")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string5 = s;
            String string6 = "-n";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                includes.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = includes.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string7 = s;
            String string8 = "-l";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                excludes.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = excludes.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            if (s.startsWith("-C")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string9 = s;
            String string10 = "-s";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                suites.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = suites.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string11 = s;
            String string12 = "-A";
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string13 = s;
            String string14 = "-i";
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                suites.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = suites.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string15 = s;
            String string16 = "-t";
            if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                suites.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = suites.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string17 = s;
            String string18 = "-z";
            if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                suites.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = suites.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string19 = s;
            String string20 = "-j";
            if (!(string19 != null ? !string19.equals(string20) : string20 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string21 = s;
            String string22 = "-m";
            if (!(string21 != null ? !string21.equals(string22) : string22 != null)) {
                membersOnly.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = membersOnly.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string23 = s;
            String string24 = "-w";
            if (!(string23 != null ? !string23.equals(string24) : string24 != null)) {
                wildcard.$plus$eq((Object)s);
                if (it.hasNext()) {
                    listBuffer = wildcard.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            if (s.startsWith("-P")) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string25 = s;
            String string26 = "-b";
            if (!(string25 != null ? !string25.equals(string26) : string26 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string27 = s;
            String string28 = "-q";
            if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                if (it.hasNext()) {
                    listBuffer = suffixes.$plus$eq(it.next());
                    continue;
                }
                listBuffer = BoxedUnit.UNIT;
                continue;
            }
            String string29 = s;
            String string30 = "-Q";
            if (!(string29 != null ? !string29.equals(string30) : string30 != null)) {
                listBuffer = suffixes.$plus$eq((Object)"Spec|Suite");
                continue;
            }
            String string31 = s;
            String string32 = "-k";
            if (!(string31 != null ? !string31.equals(string32) : string32 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string33 = s;
            String string34 = "-K";
            if (!(string33 != null ? !string33.equals(string34) : string34 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string35 = s;
            String string36 = "-y";
            if (!(string35 != null ? !string35.equals(string36) : string36 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string37 = s;
            String string38 = "-F";
            if (!(string37 != null ? !string37.equals(string38) : string38 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string39 = s;
            String string40 = "-T";
            if (!(string39 != null ? !string39.equals(string40) : string40 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            String string41 = s;
            String string42 = "-W";
            if (!(string41 != null ? !string41.equals(string42) : string42 != null)) {
                throw new IllegalArgumentException("Argument not supported by ScalaTest-js: " + s);
            }
            throw new IllegalArgumentException("Argument unrecognized by ScalaTest's Runner: " + s);
        }
        return new ParsedArgs((List<String>)reporters.toList(), (List<String>)suites.toList(), (List<String>)includes.toList(), (List<String>)excludes.toList(), (List<String>)membersOnly.toList(), (List<String>)wildcard.toList());
    }

    public List<String> parseSuiteArgsIntoNameStrings(List<String> args, String dashArg) {
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((Object[])new String[]{"args"}), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args}), ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), new Position("ArgsParser.scala", "/home/cheeseng/git/scalatest/scalatest.js/target/scala-2.12.0-RC1/src_managed/main/scala/org/scalatest/tools/ArgsParser.scala", 280));
        if (args.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parseSuiteArgsIntoNameStrings$1(x$1)))) {
            throw new NullArgumentException("an arg String was null");
        }
        String string = dashArg;
        String string2 = "-j";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = dashArg;
            String string4 = "-w";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String string5 = dashArg;
                String string6 = "-m";
                if (string5 == null ? string6 != null : !string5.equals(string6)) {
                    String string7 = dashArg;
                    String string8 = "-b";
                    if (string7 == null ? string8 != null : !string7.equals(string8)) {
                        throw new IllegalArgumentException("dashArg invalid: " + dashArg);
                    }
                }
            }
        }
        ListBuffer lb = new ListBuffer();
        Iterator it = args.iterator();
        while (it.hasNext()) {
            String dashS;
            String string9 = dashS = (String)it.next();
            String string10 = dashArg;
            if (string9 == null ? string10 != null : !string9.equals(string10)) {
                throw new IllegalArgumentException("Every other element, starting with the first, must be " + dashArg);
            }
            if (it.hasNext()) {
                String suiteName = (String)it.next();
                if (!suiteName.startsWith("-")) {
                    lb.$plus$eq((Object)suiteName);
                    continue;
                }
                throw new IllegalArgumentException("Expecting a Suite class name or package name to follow " + dashArg + ", but got: " + suiteName);
            }
            throw new IllegalArgumentException("Last element must be a Suite class name or package name, not a " + dashArg + ".");
        }
        return lb.toList();
    }

    public Set<ReporterConfigParam> parseConfigSet(String reporterArg) {
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((Object[])new String[]{"reporterArg"}), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reporterArg}), ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), new Position("ArgsParser.scala", "/home/cheeseng/git/scalatest/scalatest.js/target/scala-2.12.0-RC1/src_managed/main/scala/org/scalatest/tools/ArgsParser.scala", 329));
        if (reporterArg.length() < 2) {
            throw new IllegalArgumentException("reporterArg < 2");
        }
        String configString = reporterArg.substring(2);
        Iterator it = new StringOps(Predef$.MODULE$.augmentString(configString)).iterator();
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        while (it.hasNext()) {
            BoxedUnit boxedUnit;
            char c = BoxesRunTime.unboxToChar((Object)it.next());
            if ('Y' == c) {
                throw new IllegalArgumentException("Use of Y was deprecated in ScalaTest 1.0 and removed in 1.5. Please check the Scaladoc documentation of org.scalatest.Runner for information on valid Reporter config parameters.");
            }
            if ('Z' == c) {
                throw new IllegalArgumentException("Use of Z was deprecated in ScalaTest 1.0 and removed in 1.5. Please check the Scaladoc documentation of org.scalatest.Runner for information on valid Reporter config parameters.");
            }
            if ('B' == c) {
                throw new IllegalArgumentException("Use of B was deprecated in ScalaTest 1.0 and removed in 1.5. Please check the Scaladoc documentation of org.scalatest.Runner for information on valid Reporter config parameters.");
            }
            if ('A' == c) {
                throw new IllegalArgumentException("Use of A was deprecated in ScalaTest 1.0 and removed in 1.5. Please check the Scaladoc documentation of org.scalatest.Runner for information on valid Reporter config parameters.");
            }
            if ('I' == c) {
                set = (Set)set.$plus((Object)PresentReminderWithoutStackTraces$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('T' == c) {
                set = (Set)set.$plus((Object)PresentReminderWithShortStackTraces$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('G' == c) {
                set = (Set)set.$plus((Object)PresentReminderWithFullStackTraces$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('K' == c) {
                set = (Set)set.$plus((Object)PresentReminderWithoutCanceledTests$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('N' == c) {
                set = (Set)set.$plus((Object)FilterTestStarting$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('C' == c) {
                set = (Set)set.$plus((Object)FilterTestSucceeded$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('X' == c) {
                set = (Set)set.$plus((Object)FilterTestIgnored$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('E' == c) {
                set = (Set)set.$plus((Object)FilterTestPending$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('H' == c) {
                set = (Set)set.$plus((Object)FilterSuiteStarting$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('L' == c) {
                set = (Set)set.$plus((Object)FilterSuiteCompleted$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('O' == c) {
                set = (Set)set.$plus((Object)FilterInfoProvided$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('P' == c) {
                set = (Set)set.$plus((Object)FilterScopeOpened$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('Q' == c) {
                set = (Set)set.$plus((Object)FilterScopeClosed$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('R' == c) {
                set = (Set)set.$plus((Object)FilterScopePending$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('M' == c) {
                set = (Set)set.$plus((Object)FilterMarkupProvided$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('W' == c) {
                set = (Set)set.$plus((Object)PresentWithoutColor$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('F' == c) {
                set = (Set)set.$plus((Object)PresentFullStackTraces$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('S' == c) {
                set = (Set)set.$plus((Object)PresentShortStackTraces$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('D' == c) {
                set = (Set)set.$plus((Object)PresentAllDurations$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('U' == c) {
                set = (Set)set.$plus((Object)PresentUnformatted$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ('V' == c) {
                set = (Set)set.$plus((Object)PresentFilePathname$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            char c2 = c;
            String msg1 = Resources$.MODULE$.invalidConfigOption(String.valueOf(c2)) + '\n';
            String msg2 = Resources$.MODULE$.probarg(reporterArg) + '\n';
            throw new IllegalArgumentException(msg1 + msg2);
        }
        return set;
    }

    private Pattern ROOT_DIR_PATTERN() {
        return this.ROOT_DIR_PATTERN;
    }

    private boolean isCompleteToken(String token) {
        Matcher matcher = this.ROOT_DIR_PATTERN().matcher(token);
        return matcher.matches() || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(token), token.length() - 1) != '\\';
    }

    private Pattern START_TOKEN_PATTERN() {
        return this.START_TOKEN_PATTERN;
    }

    private Pattern FULL_TOKEN_PATTERN() {
        return this.FULL_TOKEN_PATTERN;
    }

    private List<String> splitPath(String pathArg) {
        Nil$ nil$;
        String path = pathArg.trim();
        if (path.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            Matcher startMatcher = this.START_TOKEN_PATTERN().matcher(path);
            if (!startMatcher.find()) {
                throw new RuntimeException("unexpected startMatcher path [" + path + "]");
            }
            String token = startMatcher.group(1);
            if (this.isCompleteToken(token)) {
                String string = token;
                nil$ = this.splitPath(path.substring(startMatcher.end())).$colon$colon((Object)string);
            } else {
                String fullToken;
                Matcher fullMatcher = this.FULL_TOKEN_PATTERN().matcher(path);
                if (!fullMatcher.find()) {
                    throw new RuntimeException("unexpected fullMatcher path [" + path + "]");
                }
                String string = fullToken = fullMatcher.group(1).replaceAll("\\\\(\\s)", "$1");
                nil$ = this.splitPath(path.substring(fullMatcher.end())).$colon$colon((Object)string);
            }
        }
        return nil$;
    }

    public Set<String> parseCompoundArgIntoSet(List<String> args, String expectedDashArg) {
        return (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus(this.parseCompoundArgIntoList(args, expectedDashArg));
    }

    public List<String> parseRunpathArgIntoList(List<String> args) {
        return this.parseCompoundArgIntoList(args, "-R");
    }

    public List<String> parseCompoundArgIntoList(List<String> args, String expectedDashArg) {
        Nil$ nil$;
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((Object[])new String[]{"args"}), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args}), ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), new Position("ArgsParser.scala", "/home/cheeseng/git/scalatest/scalatest.js/target/scala-2.12.0-RC1/src_managed/main/scala/org/scalatest/tools/ArgsParser.scala", 446));
        if (args.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parseCompoundArgIntoList$1(x$4)))) {
            throw new NullArgumentException("an arg String was null");
        }
        if (args.length() == 0) {
            nil$ = Nil$.MODULE$;
        } else if (args.length() % 2 == 0) {
            nil$ = args.grouped(2).flatMap((Function1 & Serializable & scala.Serializable)p -> this.parsePair$1((String)p.apply(0), (String)p.apply(1), expectedDashArg)).toList();
        } else {
            throw new IllegalArgumentException("Compound arg must be either zero-length or have even number of args: " + args);
        }
        return nil$;
    }

    public Set<String> parseChosenStylesIntoChosenStyleSet(List<String> args, String dashArg) {
        Iterator it = args.iterator();
        ListBuffer lb = new ListBuffer();
        while (it.hasNext()) {
            String dash;
            String string = dash = (String)it.next();
            String string2 = dashArg;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException("Every other element, starting with the first, must be " + dashArg);
            }
            if (it.hasNext()) {
                lb.$plus$eq(it.next());
                continue;
            }
            throw new IllegalArgumentException("Last element must be a style name, not a " + dashArg + ".");
        }
        return lb.toSet();
    }

    public double parseDoubleArgument(List<String> args, String dashArg, double defaultValue) {
        double d;
        Iterator it = args.iterator();
        ListBuffer lb = new ListBuffer();
        while (it.hasNext()) {
            String dash;
            String string = dash = (String)it.next();
            String string2 = dashArg;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException("Every other element, starting with the first, must be " + dashArg);
            }
            if (it.hasNext()) {
                String spanString = (String)it.next();
                try {
                    lb.$plus$eq((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(spanString)).toDouble()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(dashArg + " must be followed by a number, but '" + spanString + "' is not a number.");
                }
            }
            throw new IllegalArgumentException("Last element must be a number, not a " + dashArg + ".");
        }
        if (lb.size() == 0) {
            d = defaultValue;
        } else if (lb.size() == 1) {
            d = BoxesRunTime.unboxToDouble((Object)lb.apply(0));
        } else {
            throw new IllegalArgumentException("Only one " + dashArg + " can be specified.");
        }
        return d;
    }

    public ConfigMap parsePropertiesArgsIntoMap(List<String> args) {
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((Object[])new String[]{"args"}), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args}), ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), new Position("ArgsParser.scala", "/home/cheeseng/git/scalatest/scalatest.js/target/scala-2.12.0-RC1/src_managed/main/scala/org/scalatest/tools/ArgsParser.scala", 517));
        if (args.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parsePropertiesArgsIntoMap$1(x$5)))) {
            throw new NullArgumentException("an arg String was null");
        }
        if (args.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parsePropertiesArgsIntoMap$2(x$6)))) {
            throw new IllegalArgumentException("A -D arg does not contain an equals sign.");
        }
        if (args.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parsePropertiesArgsIntoMap$3(x$7)))) {
            throw new IllegalArgumentException("A spice arg does not start with -D.");
        }
        if (args.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parsePropertiesArgsIntoMap$4(x$8)))) {
            throw new IllegalArgumentException("A spice arg does not have a key to the left of the equals sign.");
        }
        if (args.exists((Function1 & Serializable & scala.Serializable)arg -> BoxesRunTime.boxToBoolean((boolean)ArgsParser$.$anonfun$parsePropertiesArgsIntoMap$5(arg)))) {
            throw new IllegalArgumentException("A spice arg does not have a value to the right of the equals sign.");
        }
        List tuples = (List)args.map((Function1 & Serializable & scala.Serializable)arg -> {
            String keyValue = arg.substring(2);
            int equalsPos = keyValue.indexOf(61);
            String key = keyValue.substring(0, equalsPos);
            String value = keyValue.substring(equalsPos + 1);
            return new Tuple2((Object)key, (Object)value);
        }, List$.MODULE$.canBuildFrom());
        return new ConfigMap((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)tuples)));
    }

    public static final /* synthetic */ boolean $anonfun$parseSuiteArgsIntoNameStrings$1(String x$1) {
        return x$1 == null;
    }

    public static final /* synthetic */ boolean $anonfun$parseCompoundArgIntoList$1(String x$4) {
        return x$4 == null;
    }

    private final List parsePair$1(String dashArg, String compoundArg, String expectedDashArg$1) {
        String string = dashArg;
        String string2 = expectedDashArg$1;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException("First arg must be " + expectedDashArg$1 + ", but was: " + dashArg);
        }
        if (compoundArg.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument string must actually include some non-whitespace characters.");
        }
        return this.splitPath(compoundArg);
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertiesArgsIntoMap$1(String x$5) {
        return x$5 == null;
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertiesArgsIntoMap$2(String x$6) {
        return x$6.indexOf(61) == -1;
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertiesArgsIntoMap$3(String x$7) {
        return !x$7.startsWith("-D");
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertiesArgsIntoMap$4(String x$8) {
        return x$8.indexOf(61) == 2;
    }

    public static final /* synthetic */ boolean $anonfun$parsePropertiesArgsIntoMap$5(String arg) {
        return arg.indexOf(61) == arg.length() - 1;
    }

    private ArgsParser$() {
        MODULE$ = this;
        this.ROOT_DIR_PATTERN = Pattern.compile("(?i)\\\\|[a-z]:\\\\");
        this.START_TOKEN_PATTERN = Pattern.compile("^\\s*(.*?)(\\s|$)");
        this.FULL_TOKEN_PATTERN = Pattern.compile("^\\s*(.+?[^\\\\])(\\s|$)");
    }
}

