// bateman -- Copyright 2021 -- Justin Patterson
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.scalawag.bateman.json

import cats.data.ValidatedNec

/** Tokenizer -> turns a stream of chars into tokens
  *  Parser -> turns a stream of tokens into a stream of JSON events
  *  Eventer -> turns a stream of events into a stream of JAnys
  *  Documenter -> turns a stream of events into a JAny (just pukes on extra? maybe doesn't need to exist.)
  * */
package object parser2 {
  type ParseResult[+A] = ValidatedNec[SyntaxError, A]
}
