/*
 * Decompiled with CFR 0.152.
 */
package scales.utils;

import scala.Either;
import scala.Function1;
import scala.Function2;
import scala.Left;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Right;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.generic.CanBuildFrom;
import scala.reflect.ClassManifest;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Sorting$;
import scalaz.Equal;
import scalaz.Scalaz$;
import scales.utils.EitherLike;
import scales.utils.FoldError;
import scales.utils.FoldOperation;
import scales.utils.Node;
import scales.utils.Path;
import scales.utils.PathFold$;
import scales.utils.Paths;
import scales.utils.Position;
import scales.utils.Top;
import scales.utils.Tree;
import scales.utils.package$;

public abstract class Paths$class {
    public static Path noPath(Paths $this, CanBuildFrom cbf$3) {
        return new Path<Item, Section, CC>($this, cbf$3){};
    }

    public static Path rootPath(Paths $this, Path path) {
        Path newPath = path;
        while (!newPath.top().isLeft()) {
            newPath = newPath.zipUp();
        }
        return newPath;
    }

    public static Path moveTo(Paths $this, Path path, Position newPos, CanBuildFrom cbf$2) {
        Path root = $this.rootPath(path);
        return (Path)newPos.position().pop().foldLeft(root, (Function2)new Serializable($this, cbf$2){
            public static final long serialVersionUID;
            public final CanBuildFrom cbf$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Path<Item, Section, CC> apply(Path<Item, Section, CC> path, int pos2) {
                return new Path<Item, Section, CC>(path, new Node<Item, Section, CC>(pos2, (EitherLike)path.children().apply(pos2)), this.cbf$2);
            }
            {
                this.cbf$2 = canBuildFrom;
            }
        });
    }

    public static Either foldPositions(Paths $this, Iterable locations, Object accumulator, Function2 folder, CanBuildFrom cbf, ClassManifest cm) {
        return PathFold$.MODULE$.foldPositions(locations, accumulator, folder, cbf, cm);
    }

    public static Either foldPositions(Paths $this, Iterable locations, Function1 folder$1, CanBuildFrom cbf, ClassManifest cm) {
        return (Either)$this.foldPositions(locations, BoxedUnit.UNIT, new Serializable($this, folder$1){
            public static final long serialVersionUID;
            public final Function1 folder$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<BoxedUnit, FoldOperation<Item, Section, CC>> apply(BoxedUnit u, Path<Item, Section, CC> p) {
                return new Tuple2((Object)BoxedUnit.UNIT, this.folder$1.apply(p));
            }
            {
                this.folder$1 = function1;
            }
        }, cbf, cm).fold((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Left<Path<Item, Section, CC>, Nothing$> apply(Tuple2<BoxedUnit, Path<Item, Section, CC>> x) {
                return new Left(x._2());
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Right<Nothing$, FoldError> apply(FoldError foldError) {
                return new Right((Object)foldError);
            }
        });
    }

    public static int comparePathPositions(Paths $this, Position path1, Position path2) {
        int n;
        if (path1 == path2) {
            n = 0;
        } else if (path1.root() != path2.root()) {
            int p1R = System.identityHashCode(path1.root());
            int p2R = System.identityHashCode(path2.root());
            n = $this.NotSameRoot() + (p1R < p2R ? 1 : -1);
        } else {
            n = package$.MODULE$.compareStack(path1.position(), path2.position());
        }
        return n;
    }

    public static boolean comparePathsDirect(Paths $this, Path path1, Path path2) {
        return path1 == path2 ? true : BoxesRunTime.unboxToInt((Object)$this.comparePathsP(new Tuple2(path1.position(), (Object)path1), new Tuple2(path2.position(), (Object)path2))._1()) == 0;
    }

    public static Tuple3 comparePaths(Paths $this, Path path1, Path path2) {
        return $this.comparePathsP(new Tuple2(path1.position(), (Object)path1), new Tuple2(path2.position(), (Object)path2));
    }

    public static Tuple3 comparePathsP(Paths $this, Tuple2 path1, Tuple2 path2) {
        Tuple2 tuple2;
        block4: {
            Tuple3 tuple3;
            block3: {
                block2: {
                    if (path1._2() != path2._2()) break block2;
                    Position pos2 = (Position)path1._1();
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)pos2, (Object)pos2);
                    break block3;
                }
                tuple2 = new Tuple2(path1._1(), path2._1());
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Position pos1 = (Position)tuple22._1();
                Position pos2 = (Position)tuple22._2();
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)$this.comparePathPositions(pos1, pos2)), (Object)pos1, (Object)pos2);
            }
            return tuple3;
        }
        throw new MatchError((Object)tuple2);
    }

    public static Tuple3 comparePathsT(Paths $this, Tuple2 path1, Tuple2 path2) {
        Tuple2 tuple2;
        block4: {
            Tuple3 tuple3;
            block3: {
                block2: {
                    if (((Tuple2)path1._2())._2() != ((Tuple2)path2._2())._2()) break block2;
                    Position pos2 = (Position)path1._1();
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)pos2, (Object)pos2);
                    break block3;
                }
                tuple2 = new Tuple2(path1._1(), path2._1());
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Position pos1 = (Position)tuple22._1();
                Position pos2 = (Position)tuple22._2();
                tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)$this.comparePathPositions(pos1, pos2)), (Object)pos1, (Object)pos2);
            }
            return tuple3;
        }
        throw new MatchError((Object)tuple2);
    }

    public static Equal toPositionalEqual(Paths $this) {
        return Scalaz$.MODULE$.equal((Function2)new Serializable($this){
            public static final long serialVersionUID;
            public final Paths $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Path<Item, Section, CC> path, Path<Item, Section, CC> path2) {
                return this.$outer.comparePathsDirect(path, path2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Path top(Paths $this, Tree tree, CanBuildFrom cbf) {
        return new Path(new Top(), new Node(0, tree), cbf);
    }

    public static Iterable positionsT(Paths $this, Iterable paths) {
        return (Iterable)paths.map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Position<Item, Section, CC>, Tuple2<T, Path<Item, Section, CC>>> apply(Tuple2<T, Path<Item, Section, CC>> x) {
                return new Tuple2(((Path)x._2()).position(), x);
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static Iterable positions(Paths $this, Iterable paths) {
        return (Iterable)paths.map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Position<Item, Section, CC>, Path<Item, Section, CC>> apply(Path<Item, Section, CC> x) {
                return new Tuple2(x.position(), x);
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static Iterable sortPositionsT(Paths $this, Iterable paths, boolean isDescending$2, ClassManifest cm) {
        return Predef$.MODULE$.wrapRefArray((Object[])Sorting$.MODULE$.stableSort($this.positionsT(paths).toSeq(), (Function2)new Serializable($this, isDescending$2){
            public static final long serialVersionUID;
            public final Paths $outer;
            public final boolean isDescending$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Position<Item, Section, CC>, Tuple2<T, Path<Item, Section, CC>>> p1, Tuple2<Position<Item, Section, CC>, Tuple2<T, Path<Item, Section, CC>>> p2) {
                Tuple3<Object, Position<Item, Section, CC>, Position<Item, Section, CC>> tuple3 = this.$outer.comparePathsT(p1, p2);
                if (tuple3 != null) {
                    boolean order;
                    Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                    int res = BoxesRunTime.unboxToInt((Object)tuple32._1());
                    tuple32._2();
                    tuple32._3();
                    boolean bl = order = res == 1 || res == this.$outer.NotSameRoot() + 1;
                    return this.isDescending$2 ? order : !order;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.isDescending$2 = bl;
            }
        }, cm));
    }

    public static Iterable sortPositions(Paths $this, Iterable paths, boolean isDescending$1, ClassManifest cm) {
        return Predef$.MODULE$.wrapRefArray((Object[])Sorting$.MODULE$.stableSort($this.positions(paths).toSeq(), (Function2)new Serializable($this, isDescending$1){
            public static final long serialVersionUID;
            public final Paths $outer;
            public final boolean isDescending$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Position<Item, Section, CC>, Path<Item, Section, CC>> p1, Tuple2<Position<Item, Section, CC>, Path<Item, Section, CC>> p2) {
                Tuple3<Object, Position<Item, Section, CC>, Position<Item, Section, CC>> tuple3 = this.$outer.comparePathsP(p1, p2);
                if (tuple3 != null) {
                    boolean order;
                    Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                    int res = BoxesRunTime.unboxToInt((Object)tuple32._1());
                    tuple32._2();
                    tuple32._3();
                    boolean bl = order = res == 1 || res == this.$outer.NotSameRoot() + 1;
                    return this.isDescending$1 ? order : !order;
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.isDescending$1 = bl;
            }
        }, cm));
    }

    public static Iterable sort(Paths $this, Iterable paths, boolean isDescending, ClassManifest cm) {
        return (Iterable)$this.sortPositions(paths, isDescending, cm).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Path<Item, Section, CC> apply(Tuple2<Position<Item, Section, CC>, Path<Item, Section, CC>> x) {
                return (Path)x._2();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static boolean sort$default$2(Paths $this) {
        return true;
    }

    public static boolean sortPositionsT$default$2(Paths $this) {
        return true;
    }

    public static boolean sortPositions$default$2(Paths $this) {
        return true;
    }

    public static Iterable sortT(Paths $this, Iterable paths, boolean isDescending, ClassManifest cm) {
        return (Iterable)$this.sortPositionsT(paths, isDescending, cm).map((Function1)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<T, Path<Item, Section, CC>> apply(Tuple2<Position<Item, Section, CC>, Tuple2<T, Path<Item, Section, CC>>> x) {
                return (Tuple2)x._2();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public static boolean sortT$default$2(Paths $this) {
        return true;
    }

    public static Path deepestLast(Paths $this, Path path) {
        Path npath;
        return path.hasChildren() ? ((npath = (Path)path.lastChild().get()).isItem() ? npath : $this.deepestLast(npath)) : path;
    }

    public static Option preceding(Paths $this, Path path) {
        Path t;
        return path.hasPreviousSibling() ? new Some((t = path.previousSibling()).isItem() ? t : $this.deepestLast(t)) : (path.top().isLeft() ? None$.MODULE$ : $this.preceding(path.top().getRight()));
    }

    public static Option following(Paths $this, Path path) {
        return path.hasNextSibling() ? new Option(path.nextSibling()) : (path.top().isLeft() ? None$.MODULE$ : $this.following(path.top().getRight()));
    }

    public static void $init$(Paths $this) {
        $this.scales$utils$Paths$_setter_$NotSameRoot_$eq(1000);
    }
}

