/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.platform.event.AppAboutEvent;
import org.scijava.platform.event.AppPreferencesEvent;
import org.scijava.platform.event.AppQuitEvent;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultAppService
extends AbstractSingletonService<App>
implements AppService {
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;
    private Map<String, App> apps;

    @Override
    public App getApp(String name) {
        return this.apps().get(name);
    }

    @Override
    public Map<String, App> getApps() {
        return this.apps();
    }

    @EventHandler(key="org.scijava.app.AppService#about")
    protected void onEvent(AppAboutEvent event) {
        this.getApp().about();
    }

    @EventHandler(key="org.scijava.app.AppService#prefs")
    protected void onEvent(AppPreferencesEvent event) {
        this.getApp().prefs();
    }

    @EventHandler(key="org.scijava.app.AppService#quit")
    protected void onEvent(AppQuitEvent event) {
        this.getApp().quit();
    }

    private Map<String, App> apps() {
        if (this.apps == null) {
            this.initApps();
        }
        return this.apps;
    }

    private synchronized void initApps() {
        if (this.apps != null) {
            return;
        }
        HashMap<String, App> map = new HashMap<String, App>();
        for (App app : this.getInstances()) {
            String name = app.getInfo().getName();
            if (map.containsKey(name)) continue;
            map.put(name, app);
        }
        this.apps = Collections.unmodifiableMap(map);
    }
}

