/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import org.scijava.Context;
import org.scijava.event.SciJavaEvent;

public class OutputEvent
extends SciJavaEvent {
    private final Source source;
    private final String output;
    private final boolean contextual;

    public OutputEvent(Context context, Source source, String output, boolean contextual) {
        this.source = source;
        this.output = output;
        this.contextual = contextual;
        this.setContext(context);
        this.setCallingThread(Thread.currentThread());
    }

    public Source getSource() {
        return this.source;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isContextual() {
        return this.contextual;
    }

    public boolean isStdout() {
        return this.source == Source.STDOUT;
    }

    public boolean isStderr() {
        return this.source == Source.STDERR;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\tsource = " + (Object)((Object)this.source) + "\n\toutput = " + this.output + "\n\tcontextual = " + this.contextual;
    }

    public static enum Source {
        STDOUT,
        STDERR;

    }
}

