/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.download;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public class MultiWriteHandle
extends AbstractDataHandle<Location> {
    private final List<DataHandle<?>> handles;

    public MultiWriteHandle(DataHandle<?> ... handles) {
        this.handles = new ArrayList(Arrays.asList(handles));
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        boolean writable = true;
        for (DataHandle<?> h : this.handles) {
            writable &= h.isWritable();
        }
        return writable;
    }

    @Override
    public boolean exists() throws IOException {
        boolean exists = true;
        for (DataHandle<?> h : this.handles) {
            exists |= h.isWritable();
        }
        return exists;
    }

    @Override
    public Date lastModified() throws IOException {
        for (DataHandle<?> h : this.handles) {
            Date lastModified = h.lastModified();
            if (lastModified == null) continue;
            return lastModified;
        }
        return null;
    }

    @Override
    public String checksum() throws IOException {
        for (DataHandle<?> h : this.handles) {
            String checksum = h.checksum();
            if (checksum == null) continue;
            return checksum;
        }
        return null;
    }

    @Override
    public long offset() throws IOException {
        return this.handles.get(0).offset();
    }

    @Override
    public void seek(long pos) throws IOException {
        for (DataHandle<?> h : this.handles) {
            h.seek(pos);
        }
    }

    @Override
    public long length() throws IOException {
        return this.handles.get(0).length();
    }

    @Override
    public void setLength(long length) throws IOException {
        for (DataHandle<?> h : this.handles) {
            h.setLength(length);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<Location> getType() {
        return null;
    }

    @Override
    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(int b) throws IOException {
        for (DataHandle<?> h : this.handles) {
            h.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (DataHandle<?> h : this.handles) {
            h.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        for (DataHandle<?> h : this.handles) {
            h.close();
        }
    }
}

