/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.scijava.event.SciJavaEvent;

public class EventDetails {
    private final Date timestamp = new Date();
    private final Class<? extends SciJavaEvent> eventType;
    private final String eventString;

    public EventDetails(SciJavaEvent event) {
        this.eventType = event.getClass();
        this.eventString = event.toString();
    }

    public Class<? extends SciJavaEvent> getEventType() {
        return this.eventType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getEventString() {
        return this.eventString;
    }

    public String toHTML(boolean bold) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p style=\"font-family: monospaced;\"");
        if (bold) {
            sb.append("<b>");
        }
        sb.append("<font color=\"gray\">[");
        sb.append(this.timestampAsString());
        sb.append("] </font>");
        sb.append("<font color=\"green\">");
        sb.append(this.eventType.getSimpleName());
        sb.append("</font>");
        sb.append("<font color=\"black\">");
        sb.append(this.htmlize(this.eventString));
        sb.append("</font>");
        if (bold) {
            sb.append("</b>");
        }
        sb.append("</p>");
        return sb.toString();
    }

    private String timestampAsString() {
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss.SS", Locale.getDefault());
        String dateStr = formatter.format(this.timestamp);
        return dateStr;
    }

    private String htmlize(String s) {
        String tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
        return s.replaceAll("\\t", "&nbsp;&nbsp;&nbsp;&nbsp;").replaceAll("\\n", "<br>");
    }
}

