/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import org.scijava.log.LogService;
import org.scijava.log.Logger;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class)
public class LoggerPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private LogService logService;
    @Parameter(required=false)
    private ModuleService moduleService;

    @Override
    public void process(Module module) {
        if (this.logService == null || this.moduleService == null) {
            return;
        }
        ModuleItem<Logger> loggerInput = this.moduleService.getSingleInput(module, Logger.class);
        if (loggerInput == null || !loggerInput.isAutoFill()) {
            return;
        }
        String loggerName = loggerInput.getLabel();
        if (loggerName == null || loggerName.isEmpty()) {
            loggerName = module.getDelegateObject().getClass().getSimpleName();
        }
        Logger logger = this.logService.subLogger(loggerName);
        String name = loggerInput.getName();
        module.setInput(name, logger);
        module.resolveInput(name);
    }
}

