/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import java.util.List;
import org.scijava.display.Display;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;
import org.scijava.ui.dnd.DragAndDropData;
import org.scijava.ui.dnd.DragAndDropHandler;

public interface DragAndDropService
extends HandlerService<Object, DragAndDropHandler<Object>>,
SciJavaService {
    default public boolean supports(DragAndDropData data, Display<?> display) {
        return this.getHandler(data, display) != null;
    }

    default public boolean supports(Object object, Display<?> display) {
        return this.getHandler(object, display) != null;
    }

    default public boolean drop(DragAndDropData data, Display<?> display) {
        DragAndDropHandler<?> handler = this.getHandler(data, display);
        if (handler == null) {
            return false;
        }
        return handler.dropData(data, display);
    }

    default public boolean drop(Object data, Display<?> display) {
        DragAndDropHandler<?> handler = this.getHandler(data, display);
        if (handler == null) {
            return false;
        }
        return handler.dropObject(data, display);
    }

    default public DragAndDropHandler<?> getHandler(DragAndDropData data, Display<?> display) {
        for (DragAndDropHandler<Object> handler : this.getInstances()) {
            if (!handler.supportsData(data, display)) continue;
            return handler;
        }
        return null;
    }

    default public DragAndDropHandler<?> getHandler(Object object, Display<?> display) {
        for (DragAndDropHandler<Object> handler : this.getInstances()) {
            if (!handler.supportsObject(object, display)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public List<DragAndDropHandler<Object>> getInstances();

    @Override
    default public Class<DragAndDropHandler<Object>> getPluginType() {
        return DragAndDropHandler.class;
    }

    @Override
    default public Class<Object> getType() {
        return Object.class;
    }
}

