/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Timing {
    private long total = 0L;
    private long start;
    private long tick = this.start = System.nanoTime();
    private List<Map.Entry<Long, String>> list = new ArrayList<Map.Entry<Long, String>>();

    public void reset() {
        this.tick = System.nanoTime();
    }

    public void addTiming(Object message) {
        this.addTiming(System.nanoTime() - this.tick, message == null ? Timing.getCaller() : message);
        this.tick = System.nanoTime();
    }

    public void addTiming(final long duration, final Object message) {
        final long now = System.nanoTime();
        this.total += duration;
        this.list.add(new Map.Entry<Long, String>(){

            @Override
            public Long getKey() {
                return duration;
            }

            @Override
            public String getValue() {
                return message.toString() + ": " + (double)(now - Timing.this.start - duration) / 1000000.0 + " - " + (double)(now - Timing.this.start) / 1000000.0;
            }

            @Override
            public String setValue(String value) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void report(String description) {
        System.err.println(description == null ? Timing.getCaller() : description);
        Collections.sort(this.list, new Comparator<Map.Entry<Long, String>>(){

            @Override
            public int compare(Map.Entry<Long, String> o1, Map.Entry<Long, String> o2) {
                return Double.compare(o1.getKey().longValue(), o2.getKey().longValue());
            }
        });
        for (Map.Entry<Long, String> e : this.list) {
            System.err.printf("% 5.3f ms %s\n", (double)e.getKey().longValue() / 1000000.0, e.getValue());
        }
        System.err.println("Total time: " + this.total + " = " + (double)this.total / 1.0E9 + " sec");
    }

    private static String getCaller() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int i = 1;
        while (i + 1 < trace.length && Timing.class.getName().equals(trace[i].getClassName())) {
            ++i;
        }
        return i >= trace.length ? "?" : trace[i].getClassName() + "." + trace[i].getMethodName() + "(" + trace[i].getFileName() + ":" + trace[i].getLineNumber() + ")";
    }

    public static Timing start(boolean condition) {
        return condition ? new Timing() : null;
    }

    public static void tick(Timing timing) {
        if (timing != null) {
            timing.addTiming(null);
        }
    }

    public static void tick(Timing timing, Object message) {
        if (timing != null) {
            timing.addTiming(message);
        }
    }

    public static void stop(Timing timing) {
        if (timing == null) {
            return;
        }
        timing.addTiming(null);
        timing.report(null);
    }
}

