/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import javax.crypto.Cipher;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.util.Either;
import scodec.bits.BitVector;
import scodec.bits.BitVector$;
import scodec.bits.ByteVector;

public interface BitVectorCrossPlatform {
    public static BitVector deflate$(BitVectorCrossPlatform $this, int level, int strategy, boolean nowrap, int chunkSize) {
        return $this.deflate(level, strategy, nowrap, chunkSize);
    }

    default public BitVector deflate(int level, int strategy, boolean nowrap, int chunkSize) {
        return ((BitVector)this).bytes().deflate(level, strategy, nowrap, chunkSize).bits();
    }

    public static int deflate$default$1$(BitVectorCrossPlatform $this) {
        return $this.deflate$default$1();
    }

    default public int deflate$default$1() {
        return -1;
    }

    public static int deflate$default$2$(BitVectorCrossPlatform $this) {
        return $this.deflate$default$2();
    }

    default public int deflate$default$2() {
        return 0;
    }

    public static boolean deflate$default$3$(BitVectorCrossPlatform $this) {
        return $this.deflate$default$3();
    }

    default public boolean deflate$default$3() {
        return false;
    }

    public static int deflate$default$4$(BitVectorCrossPlatform $this) {
        return $this.deflate$default$4();
    }

    default public int deflate$default$4() {
        return 4096;
    }

    public static Either inflate$(BitVectorCrossPlatform $this, int chunkSize) {
        return $this.inflate(chunkSize);
    }

    default public Either<DataFormatException, BitVector> inflate(int chunkSize) {
        ByteVector byteVector = ((BitVector)this).bytes();
        return byteVector.inflate(chunkSize, byteVector.inflate$default$2()).map((Function1 & Serializable)_$1 -> _$1.bits());
    }

    public static int inflate$default$1$(BitVectorCrossPlatform $this) {
        return $this.inflate$default$1();
    }

    default public int inflate$default$1() {
        return 4096;
    }

    public static BitVector sha1$(BitVectorCrossPlatform $this) {
        return $this.sha1();
    }

    default public BitVector sha1() {
        return this.digest("SHA-1");
    }

    public static BitVector sha256$(BitVectorCrossPlatform $this) {
        return $this.sha256();
    }

    default public BitVector sha256() {
        return this.digest("SHA-256");
    }

    public static BitVector md5$(BitVectorCrossPlatform $this) {
        return $this.md5();
    }

    default public BitVector md5() {
        return this.digest("MD5");
    }

    public static BitVector digest$(BitVectorCrossPlatform $this, String algorithm) {
        return $this.digest(algorithm);
    }

    default public BitVector digest(String algorithm) {
        return this.digest(MessageDigest.getInstance(algorithm));
    }

    public static BitVector digest$(BitVectorCrossPlatform $this, MessageDigest digest) {
        return $this.digest(digest);
    }

    default public BitVector digest(MessageDigest digest) {
        return BitVector$.MODULE$.apply(((BitVector)this).bytes().digest(digest));
    }

    public static Either encrypt$(BitVectorCrossPlatform $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.encrypt(ci, key, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, BitVector> encrypt(Cipher ci, Key key, Option<AlgorithmParameters> aparams, SecureRandom sr) {
        return this.cipher(ci, key, 1, aparams, sr);
    }

    public static Option encrypt$default$3$(BitVectorCrossPlatform $this) {
        return $this.encrypt$default$3();
    }

    default public Option<AlgorithmParameters> encrypt$default$3() {
        return None$.MODULE$;
    }

    public static Either decrypt$(BitVectorCrossPlatform $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.decrypt(ci, key, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, BitVector> decrypt(Cipher ci, Key key, Option<AlgorithmParameters> aparams, SecureRandom sr) {
        return this.cipher(ci, key, 2, aparams, sr);
    }

    public static Option decrypt$default$3$(BitVectorCrossPlatform $this) {
        return $this.decrypt$default$3();
    }

    default public Option<AlgorithmParameters> decrypt$default$3() {
        return None$.MODULE$;
    }

    public static Either cipher$(BitVectorCrossPlatform $this, Cipher ci, Key key, int opmode, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, opmode, (Option<AlgorithmParameters>)aparams, sr);
    }

    default public Either<GeneralSecurityException, BitVector> cipher(Cipher ci, Key key, int opmode, Option<AlgorithmParameters> aparams, SecureRandom sr) {
        return ((BitVector)this).bytes().cipher(ci, key, opmode, (Option)aparams, sr).map((Function1 & Serializable)_$2 -> _$2.bits());
    }

    public static Option cipher$default$4$(BitVectorCrossPlatform $this) {
        return $this.cipher$default$4();
    }

    default public Option<AlgorithmParameters> cipher$default$4() {
        return None$.MODULE$;
    }
}

