/*
 * Decompiled with CFR 0.152.
 */
package gf2t;

import gf2t.GF2_192;
import gf2t.GF2_192_Poly;
import gf2t.ReadableTest;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ReadableTest.class)
public class GF2_192Test {
    private static long[][] testValues = null;
    private static GF2_192 zero = new GF2_192(0);
    private static GF2_192 one = new GF2_192(1);
    private static int[] pentanomial = new int[]{192, 7, 2, 1, 0};
    private static GF2t_slow.Modulus m = new GF2t_slow.Modulus(pentanomial);

    private static void genTestValues() {
        if (testValues == null) {
            int n;
            testValues = new long[250][];
            for (n = 0; n < testValues.length; ++n) {
                GF2_192Test.testValues[n] = new long[3];
            }
            n = 0;
            int n2 = 1;
            while (n2 < 64) {
                GF2_192Test.testValues[n][0] = 1L << n2;
                GF2_192Test.testValues[n][1] = 0L;
                GF2_192Test.testValues[n][2] = 0L;
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < 64) {
                GF2_192Test.testValues[n][0] = 0L;
                GF2_192Test.testValues[n][1] = 1L << n2;
                GF2_192Test.testValues[n][2] = 0L;
                ++n2;
                ++n;
            }
            n2 = 0;
            while (n2 < 64) {
                GF2_192Test.testValues[n][0] = 0L;
                GF2_192Test.testValues[n][1] = 0L;
                GF2_192Test.testValues[n][2] = 1L << n2;
                ++n2;
                ++n;
            }
            Random random = new Random();
            int n3 = 0;
            while (n3 < 5) {
                GF2_192Test.testValues[n][0] = 0L;
                GF2_192Test.testValues[n][1] = random.nextLong();
                GF2_192Test.testValues[n][2] = random.nextLong();
                ++n3;
                ++n;
            }
            n3 = 0;
            while (n3 < 5) {
                GF2_192Test.testValues[n][0] = random.nextLong();
                GF2_192Test.testValues[n][1] = 0L;
                GF2_192Test.testValues[n][2] = 0L;
                ++n3;
                ++n;
            }
            n3 = 0;
            while (n3 < 5) {
                GF2_192Test.testValues[n][0] = random.nextLong();
                GF2_192Test.testValues[n][1] = 1L;
                GF2_192Test.testValues[n][2] = 0L;
                ++n3;
                ++n;
            }
            n3 = 0;
            while (n3 < 5) {
                GF2_192Test.testValues[n][0] = 0L;
                GF2_192Test.testValues[n][1] = 1L;
                GF2_192Test.testValues[n][2] = random.nextLong();
                ++n3;
                ++n;
            }
            while (n < testValues.length) {
                GF2_192Test.testValues[n][0] = random.nextLong();
                GF2_192Test.testValues[n][1] = random.nextLong();
                GF2_192Test.testValues[n++][2] = random.nextLong();
            }
        }
    }

    @Test
    public void constructorAndEqualityTest() {
        int n;
        int n2;
        GF2_192 gF2_192 = new GF2_192();
        long[] lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: empty constructor.", (!gF2_192.isZero() || lArray.length != 3 || lArray[0] != 0L || lArray[1] != 0L || lArray[2] != 0L ? 1 : 0) != 0);
        gF2_192 = new GF2_192(0);
        lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on 0 int", (!gF2_192.isZero() || lArray.length != 3 || lArray[0] != 0L || lArray[1] != 0L || lArray[2] != 0L ? 1 : 0) != 0);
        gF2_192 = new GF2_192(1);
        lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on 1 int", (!gF2_192.isOne() || lArray.length != 3 || lArray[0] != 1L || lArray[1] != 0L || lArray[2] != 0L ? 1 : 0) != 0);
        gF2_192 = new GF2_192(-1);
        lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)("Fail: constructor on 0xFFFFFFFF int " + gF2_192), (lArray[0] != 0xFFFFFFFFL || lArray[1] != 0L || lArray[2] != 0L ? 1 : 0) != 0);
        long[] lArray2 = new long[]{123345L, 123567891234567L, 487237823242367L};
        gF2_192 = new GF2_192(lArray2);
        GF2_192 gF2_1922 = new GF2_192(gF2_192);
        lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on long array", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        lArray = gF2_1922.toLongArray();
        Assert.assertFalse((String)"Fail: copy constructor", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        byte[] byArray = new byte[24];
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2] = (byte)(lArray[0] >>> n2 * 8);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2 + 8] = (byte)(lArray[1] >>> n2 * 8);
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2 + 16] = (byte)(lArray[2] >>> n2 * 8);
        }
        gF2_192 = new GF2_192(byArray);
        lArray2 = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on byte array", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        byte[] byArray2 = gF2_192.toByteArray();
        Assert.assertFalse((String)"Fail: toByteArray", (!Arrays.equals(byArray, byArray2) ? 1 : 0) != 0);
        byte[] byArray3 = new byte[30];
        for (int i = 0; i < 24; ++i) {
            byArray3[i + 6] = byArray[i];
        }
        gF2_192 = new GF2_192(byArray3, 6);
        lArray2 = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on byte array with offset", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        byte[] byArray4 = gF2_192.toByteArray();
        Assert.assertFalse((String)"Fail: toByteArray", (!Arrays.equals(byArray, byArray4) ? 1 : 0) != 0);
        byte[] byArray5 = new byte[40];
        gF2_192.toByteArray(byArray5, 10);
        for (n = 0; n < byArray.length; ++n) {
            Assert.assertFalse((String)"Fail: toByteArray with offset", (byArray5[n + 10] != byArray[n] ? 1 : 0) != 0);
        }
        lArray2[0] = -1L;
        lArray2[1] = -1L;
        lArray2[2] = -1L;
        gF2_192 = new GF2_192(lArray2);
        gF2_1922 = new GF2_192(gF2_192);
        lArray = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on long array of all 1s", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        lArray = gF2_1922.toLongArray();
        Assert.assertFalse((String)"Fail: copy constructor", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(lArray[0] >>> n * 8);
        }
        for (n = 0; n < 8; ++n) {
            byArray[n + 8] = (byte)(lArray[1] >>> n * 8);
        }
        for (n = 0; n < 8; ++n) {
            byArray[n + 16] = (byte)(lArray[2] >>> n * 8);
        }
        gF2_192 = new GF2_192(byArray);
        lArray2 = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on byte array of all 1s", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        byArray4 = gF2_192.toByteArray();
        Assert.assertFalse((String)"Fail: toByteArray all 1s", (!Arrays.equals(byArray, byArray4) ? 1 : 0) != 0);
        byArray3 = new byte[30];
        for (n = 0; n < 24; ++n) {
            byArray3[n + 6] = byArray[n];
        }
        gF2_192 = new GF2_192(byArray3, 6);
        lArray2 = gF2_192.toLongArray();
        Assert.assertFalse((String)"Fail: constructor on byte array with offset of all 1s", (lArray[0] != lArray2[0] || lArray[1] != lArray2[1] || lArray[2] != lArray2[2] ? 1 : 0) != 0);
        byArray4 = gF2_192.toByteArray();
        Assert.assertFalse((String)"Fail: toByteArray all 1s", (!Arrays.equals(byArray, byArray4) ? 1 : 0) != 0);
        byArray5 = new byte[40];
        gF2_192.toByteArray(byArray5, 10);
        for (n = 0; n < byArray.length; ++n) {
            Assert.assertFalse((String)"Fail: toByteArray all 1s with offset", (byArray5[n + 10] != byArray[n] ? 1 : 0) != 0);
        }
    }

    @Test
    public void pow2To2ToKTest() {
        GF2_192 gF2_192;
        GF2_192 gF2_1922 = new GF2_192();
        int n = 15;
        for (int i = 0; i < n; ++i) {
            GF2_192.power2To2ToK((GF2_192)gF2_1922, (GF2_192)zero, (int)i);
            Assert.assertFalse((String)("Fail: power2To2ToK of 0 for k=" + i), (!gF2_1922.isZero() ? 1 : 0) != 0);
            gF2_192 = new GF2_192(zero);
            GF2_192.power2To2ToK((GF2_192)gF2_192, (GF2_192)gF2_192, (int)i);
            Assert.assertFalse((String)("Fail: power2To2ToK of 0 in place for k=" + i), (!gF2_192.isZero() ? 1 : 0) != 0);
            GF2_192.power2To2ToK((GF2_192)gF2_1922, (GF2_192)one, (int)i);
            Assert.assertFalse((String)("Fail: power2To2ToK of 1 for k=" + i), (!gF2_1922.isOne() ? 1 : 0) != 0);
            gF2_192 = new GF2_192(one);
            GF2_192.power2To2ToK((GF2_192)gF2_192, (GF2_192)gF2_192, (int)i);
            Assert.assertFalse((String)("Fail: power2To2ToK of 1 in place for k=" + i), (!gF2_192.isOne() ? 1 : 0) != 0);
        }
        GF2_192.sqr((GF2_192)gF2_1922, (GF2_192)zero);
        Assert.assertFalse((String)"Fail: sqr of 0", (!gF2_1922.isZero() ? 1 : 0) != 0);
        gF2_192 = new GF2_192(zero);
        GF2_192.sqr((GF2_192)gF2_192, (GF2_192)gF2_192);
        Assert.assertFalse((String)"Fail: sqr of 0 in place", (!gF2_192.isZero() ? 1 : 0) != 0);
        GF2_192.sqr((GF2_192)gF2_1922, (GF2_192)one);
        Assert.assertFalse((String)"Fail: sqr of 1", (!gF2_1922.isOne() ? 1 : 0) != 0);
        gF2_192 = new GF2_192(one);
        GF2_192.sqr((GF2_192)gF2_192, (GF2_192)gF2_192);
        Assert.assertFalse((String)"Fail: sqr of 1 in place", (!gF2_192.isOne() ? 1 : 0) != 0);
        GF2_192 gF2_1923 = new GF2_192();
        GF2_192 gF2_1924 = new GF2_192();
        for (long[] lArray : testValues) {
            for (int i = 0; i < n; ++i) {
                gF2_192 = new GF2_192(lArray);
                GF2_192.power2To2ToK((GF2_192)gF2_1922, (GF2_192)gF2_192, (int)i);
                if (i == 0) {
                    GF2_192.mul((GF2_192)gF2_1923, (GF2_192)gF2_192, (GF2_192)gF2_192);
                    Assert.assertFalse((String)("Fail: power2To2To1  " + gF2_192), (!gF2_1922.equals(gF2_1923) ? 1 : 0) != 0);
                    GF2_192.sqr((GF2_192)gF2_1924, (GF2_192)gF2_192);
                    Assert.assertFalse((String)("Fail: sqr for k = " + i + " value = " + gF2_192), (!gF2_1922.equals(gF2_1924) ? 1 : 0) != 0);
                } else {
                    GF2_192.power2To2ToK((GF2_192)gF2_1923, (GF2_192)gF2_1923, (int)(i - 1));
                    Assert.assertFalse((String)("Fail: power2To2ToK for k = " + i + " value = " + gF2_192), (!gF2_1922.equals(gF2_1923) ? 1 : 0) != 0);
                }
                GF2_192.power2To2ToK((GF2_192)gF2_192, (GF2_192)gF2_192, (int)i);
                Assert.assertFalse((String)("Fail: power2To2ToK in place for k = " + i + " value = " + new GF2_192(lArray)), (!gF2_1922.equals(gF2_192) ? 1 : 0) != 0);
                if (i != 0) continue;
                gF2_192 = new GF2_192(lArray);
                GF2_192.sqr((GF2_192)gF2_192, (GF2_192)gF2_192);
                Assert.assertFalse((String)("Fail: sqr in place " + new GF2_192(lArray)), (!gF2_1922.equals(gF2_192) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void specialMultTest() {
        Object object;
        GF2_192 gF2_192 = new GF2_192();
        GF2t_slow gF2t_slow = new GF2t_slow();
        for (long[] lArray : testValues) {
            object = new GF2_192(lArray);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)object, (GF2_192)zero);
            Assert.assertFalse((String)("Fail: " + object + " * 0"), (!gF2_192.isZero() ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)object, (GF2_192)zero);
            Assert.assertFalse((String)("Fail: " + object + " * 0 in place "), (!object.isZero() ? 1 : 0) != 0);
            object = new GF2_192(lArray);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)zero, (GF2_192)object);
            Assert.assertFalse((String)("Fail: 0 * " + object), (!gF2_192.isZero() ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)zero, (GF2_192)object);
            Assert.assertFalse((String)("Fail: 0 * " + object + " in place "), (!object.isZero() ? 1 : 0) != 0);
            object = new GF2_192(lArray);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)object, (GF2_192)one);
            Assert.assertFalse((String)("Fail: " + object + " * 1"), (!gF2_192.equals(object) ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)object, (GF2_192)one);
            Assert.assertFalse((String)("Fail: " + object + " * 1 in place"), (!gF2_192.equals(object) ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)one, (GF2_192)object);
            Assert.assertFalse((String)("Fail: 1 * " + object), (!gF2_192.equals(object) ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)one, (GF2_192)object);
            Assert.assertFalse((String)("Fail: 1 * " + object + " in place"), (!gF2_192.equals(object) ? 1 : 0) != 0);
        }
        for (long[] lArray : testValues) {
            object = new GF2_192(lArray);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)object, (byte)1);
            Assert.assertFalse((String)("Fail: " + object + " * 1 byte "), (!gF2_192.equals(object) ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)object, (byte)1);
            Assert.assertFalse((String)("Fail: " + object + " * 1 byte in place"), (!gF2_192.equals(object) ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)object, (byte)0);
            Assert.assertFalse((String)("Fail: " + object + " * 0 byte"), (!gF2_192.isZero() ? 1 : 0) != 0);
            GF2_192.mul((GF2_192)object, (GF2_192)object, (byte)0);
            Assert.assertFalse((String)("Fail: " + object + " * 0 byte in place"), (!object.isZero() ? 1 : 0) != 0);
        }
        long[] lArray = new long[1];
        long[][] lArray2 = testValues;
        int n = lArray2.length;
        for (int i = 0; i < n; ++i) {
            object = lArray2[i];
            for (int j = 2; j < 256; ++j) {
                GF2_192 gF2_1922 = new GF2_192((long[])object);
                lArray[0] = j;
                GF2_192.mul((GF2_192)gF2_192, (GF2_192)gF2_1922, (byte)((byte)j));
                GF2t_slow.mulBits(gF2t_slow, (long[])object, lArray);
                GF2t_slow.modReduce(gF2t_slow, GF2_192Test.m);
                Assert.assertFalse((String)("Fail: " + gF2_1922 + " * " + j + " byte"), (!gF2t_slow.equals(gF2_192.toLongArray()) ? 1 : 0) != 0);
                GF2_192.mul((GF2_192)gF2_1922, (GF2_192)gF2_1922, (byte)((byte)j));
                Assert.assertFalse((String)("Fail: " + gF2_1922 + " * " + j + " byte in place"), (!gF2_192.equals(gF2_1922) ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void specialAddTest() {
        GF2_192 gF2_192 = new GF2_192();
        for (long[] lArray : testValues) {
            GF2_192 gF2_1922 = new GF2_192(lArray);
            GF2_192.add((GF2_192)gF2_192, (GF2_192)gF2_1922, (GF2_192)zero);
            Assert.assertFalse((String)("Fail: " + gF2_1922 + " + 0"), (!gF2_192.equals(gF2_1922) ? 1 : 0) != 0);
            GF2_192.add((GF2_192)gF2_1922, (GF2_192)gF2_1922, (GF2_192)zero);
            Assert.assertFalse((String)("Fail: " + gF2_1922 + " + 0 in place"), (!gF2_192.equals(gF2_1922) ? 1 : 0) != 0);
            GF2_192.add((GF2_192)gF2_192, (GF2_192)zero, (GF2_192)gF2_1922);
            Assert.assertFalse((String)("Fail: 0 + " + gF2_1922), (!gF2_192.equals(gF2_1922) ? 1 : 0) != 0);
            GF2_192.add((GF2_192)gF2_1922, (GF2_192)zero, (GF2_192)gF2_1922);
            Assert.assertFalse((String)("Fail: " + gF2_1922 + " + 0 in place"), (!gF2_192.equals(gF2_1922) ? 1 : 0) != 0);
        }
    }

    @Test
    public void generalAddTest() {
        GF2_192 gF2_192;
        GF2_192 gF2_1922 = new GF2_192();
        GF2t_slow gF2t_slow = new GF2t_slow();
        GF2t_slow.access$402(gF2t_slow, new long[3]);
        for (long[] lArray : testValues) {
            gF2_192 = new GF2_192(lArray);
            for (long[] lArray2 : testValues) {
                GF2_192 gF2_1923 = new GF2_192(lArray2);
                GF2_192.add((GF2_192)gF2_1922, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                ((GF2t_slow)gF2t_slow).x[0] = lArray[0] ^ lArray2[0];
                ((GF2t_slow)gF2t_slow).x[1] = lArray[1] ^ lArray2[1];
                ((GF2t_slow)gF2t_slow).x[2] = lArray[2] ^ lArray2[2];
                Assert.assertFalse((String)("Fail: " + gF2_192 + " + " + gF2_1923 + " = " + gF2_1922 + " not " + gF2t_slow), (!gF2t_slow.equals(gF2_1922.toLongArray()) ? 1 : 0) != 0);
                GF2_192.add((GF2_192)gF2_192, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                Assert.assertFalse((String)("Fail: " + gF2_192 + " + " + gF2_1923 + " in place 1 "), (!gF2_1922.equals(gF2_192) ? 1 : 0) != 0);
                gF2_192 = new GF2_192(lArray);
                GF2_192.add((GF2_192)gF2_1923, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                Assert.assertFalse((String)("Fail: " + gF2_192 + " + " + gF2_1923 + " in place 2 "), (!gF2_1922.equals(gF2_1923) ? 1 : 0) != 0);
            }
        }
        for (long[] lArray : testValues) {
            gF2_192 = new GF2_192(lArray);
            GF2_192.add((GF2_192)gF2_1922, (GF2_192)gF2_192, (GF2_192)gF2_192);
            Assert.assertFalse((String)("Fail: " + gF2_192 + " + self"), (!gF2_1922.isZero() ? 1 : 0) != 0);
            GF2_192.add((GF2_192)gF2_192, (GF2_192)gF2_192, (GF2_192)gF2_192);
            Assert.assertFalse((String)("Fail: " + gF2_192 + " self in place"), (!gF2_192.isZero() ? 1 : 0) != 0);
        }
    }

    @Test
    public void generalMultTest() {
        GF2_192 gF2_192;
        GF2_192 gF2_1922 = new GF2_192();
        GF2t_slow gF2t_slow = new GF2t_slow();
        for (long[] lArray : testValues) {
            gF2_192 = new GF2_192(lArray);
            for (long[] lArray2 : testValues) {
                GF2_192 gF2_1923 = new GF2_192(lArray2);
                GF2_192.mul((GF2_192)gF2_1922, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                GF2t_slow.mulBits(gF2t_slow, lArray, lArray2);
                GF2t_slow.modReduce(gF2t_slow, GF2_192Test.m);
                Assert.assertFalse((String)("Fail: " + gF2_192 + " * " + gF2_1923), (!gF2t_slow.equals(gF2_1922.toLongArray()) ? 1 : 0) != 0);
                GF2_192.mul((GF2_192)gF2_192, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                Assert.assertFalse((String)("Fail: " + gF2_192 + " * " + gF2_1923 + " in place 1 "), (!gF2_1922.equals(gF2_192) ? 1 : 0) != 0);
                gF2_192 = new GF2_192(lArray);
                GF2_192.mul((GF2_192)gF2_1923, (GF2_192)gF2_192, (GF2_192)gF2_1923);
                Assert.assertFalse((String)("Fail: " + gF2_192 + " * " + gF2_1923 + " in place 2 "), (!gF2_1922.equals(gF2_1923) ? 1 : 0) != 0);
            }
        }
        for (long[] lArray : testValues) {
            gF2_192 = new GF2_192(lArray);
            GF2_192.sqr((GF2_192)gF2_1922, (GF2_192)gF2_192);
            GF2_192.mul((GF2_192)gF2_192, (GF2_192)gF2_192, (GF2_192)gF2_192);
            Assert.assertFalse((String)("Fail: " + gF2_192 + " * self in place"), (!gF2_1922.equals(gF2_192) ? 1 : 0) != 0);
        }
    }

    @Test
    public void inversionTest() {
        GF2_192 gF2_192 = new GF2_192();
        GF2_192 gF2_1922 = new GF2_192();
        GF2t_slow gF2t_slow = new GF2t_slow();
        GF2_192.invert((GF2_192)gF2_192, (GF2_192)one);
        Assert.assertFalse((String)"Fail: inversion of 1", (!gF2_192.isOne() ? 1 : 0) != 0);
        for (long[] lArray : testValues) {
            GF2_192 gF2_1923 = new GF2_192(lArray);
            if (gF2_1923.isZero()) continue;
            GF2_192.invert((GF2_192)gF2_192, (GF2_192)gF2_1923);
            GF2_192.mul((GF2_192)gF2_1922, (GF2_192)gF2_1923, (GF2_192)gF2_192);
            Assert.assertFalse((String)("Fail: inversion of " + gF2_1923 + " self-test "), (!gF2_1922.isOne() ? 1 : 0) != 0);
            GF2t_slow.mulBits(gF2t_slow, gF2_192.toLongArray(), lArray);
            GF2t_slow.modReduce(gF2t_slow, GF2_192Test.m);
            Assert.assertFalse((String)("Fail: inversion of " + gF2_1923 + " GF2t_slow-test"), (!gF2t_slow.isOne() ? 1 : 0) != 0);
            GF2_192.invert((GF2_192)gF2_1923, (GF2_192)gF2_1923);
            Assert.assertFalse((String)("Fail: inversion of " + gF2_1923 + " in place "), (!gF2_1923.equals(gF2_192) ? 1 : 0) != 0);
        }
    }

    @Test
    public void interpolateTest() {
        GF2_192 gF2_192;
        GF2_192 gF2_1922;
        GF2_192_Poly gF2_192_Poly;
        Object object;
        GF2_192[] gF2_192Array;
        byte[] byArray;
        int n;
        GF2_192 gF2_1923 = new GF2_192[]{null, new GF2_192(17)};
        Random random = new Random();
        GF2_192_Poly gF2_192_Poly2 = GF2_192_Poly.interpolate((byte[])new byte[0], (GF2_192[])new GF2_192[0], (GF2_192)new GF2_192(0));
        Assert.assertFalse((String)"Zero polynomial should be 0 at 0", (!gF2_192_Poly2.evaluate((byte)0).isZero() ? 1 : 0) != 0);
        Assert.assertFalse((String)"Zero polynomial should be 0 at 5", (!gF2_192_Poly2.evaluate((byte)5).isZero() ? 1 : 0) != 0);
        GF2_192 gF2_1924 = new GF2_192(17);
        gF2_192_Poly2 = GF2_192_Poly.interpolate((byte[])new byte[0], (GF2_192[])new GF2_192[0], (GF2_192)gF2_1924);
        Assert.assertFalse((String)"Constant 17 polynomial should be 17 at 0", (!gF2_192_Poly2.evaluate((byte)0).equals(gF2_1924) ? 1 : 0) != 0);
        Assert.assertFalse((String)"Constant 17 polynomial should be 17 at 5", (!gF2_192_Poly2.evaluate((byte)5).equals(gF2_1924) ? 1 : 0) != 0);
        for (n = 1; n < 100; ++n) {
            int n2;
            byArray = new byte[n];
            gF2_192Array = new GF2_192[n];
            object = new byte[24];
            for (n2 = 0; n2 < n; ++n2) {
                byte by;
                while (true) {
                    int n3;
                    if ((by = (byte)random.nextInt()) == 0) {
                        continue;
                    }
                    for (n3 = 0; n3 < n2 && by != byArray[n3]; ++n3) {
                    }
                    if (n3 == n2) break;
                }
                byArray[n2] = by;
            }
            for (n2 = 0; n2 < n; ++n2) {
                random.nextBytes((byte[])object);
                gF2_192Array[n2] = new GF2_192(object);
            }
            gF2_192_Poly = GF2_192_Poly.interpolate((byte[])byArray, (GF2_192[])gF2_192Array, null);
            for (n2 = 0; n2 < n; ++n2) {
                GF2_192 gF2_1925 = gF2_192_Poly.evaluate(byArray[n2]);
                Assert.assertFalse((String)("Interpolation error on length = " + n + " at input point number " + n2), (!gF2_1925.equals(gF2_192Array[n2]) ? 1 : 0) != 0);
            }
            random.nextBytes((byte[])object);
            gF2_1922 = new GF2_192(object);
            gF2_192_Poly = GF2_192_Poly.interpolate((byte[])byArray, (GF2_192[])gF2_192Array, (GF2_192)gF2_1922);
            for (int i = 0; i < n; ++i) {
                GF2_192 gF2_1926 = gF2_192_Poly.evaluate(byArray[i]);
                Assert.assertFalse((String)("Interpolation error on length =  " + n + " at input point number " + i + "(with optional 0)"), (!gF2_1926.equals(gF2_192Array[i]) ? 1 : 0) != 0);
            }
            GF2_192 gF2_1927 = gF2_192_Poly.evaluate((byte)0);
            Assert.assertFalse((String)("Interpolation error on length =  " + n + " at input optional 0"), (!gF2_1927.equals(gF2_1922) ? 1 : 0) != 0);
            byte[] byArray2 = gF2_192_Poly.toByteArray(Boolean.valueOf(false));
            gF2_192 = GF2_192_Poly.fromByteArray((byte[])gF2_1922.toByteArray(), (byte[])byArray2);
            byte[] byArray3 = gF2_192.toByteArray(Boolean.valueOf(false));
            Assert.assertFalse((String)("To byte array round trip error " + Arrays.toString(byArray2) + " " + Arrays.toString(byArray3)), (!Arrays.equals(byArray2, byArray3) ? 1 : 0) != 0);
            byte[] byArray4 = gF2_192.toByteArray(Boolean.valueOf(true));
            Assert.assertFalse((String)"To byte array round trip error at coeff0", (!Arrays.equals(gF2_1922.toByteArray(), Arrays.copyOfRange(byArray4, 0, 24)) ? 1 : 0) != 0);
            Assert.assertFalse((String)"To byte array round trip error with coeff0 at later coeff", (!Arrays.equals(byArray3, Arrays.copyOfRange(byArray4, 24, byArray4.length)) ? 1 : 0) != 0);
            byte[] byArray5 = gF2_192.coeff0Bytes();
            Assert.assertFalse((String)"To byte array round trip error on coeff0", (!Arrays.equals(byArray5, gF2_1922.toByteArray()) ? 1 : 0) != 0);
        }
        for (n = 1; n < 100; ++n) {
            int n4;
            int n5;
            byArray = new byte[n];
            gF2_192Array = new GF2_192[n];
            object = new byte[24];
            for (n5 = 0; n5 < n; ++n5) {
                byte by;
                do {
                    by = (byte)random.nextInt();
                    for (n4 = 0; n4 < n5 && by != byArray[n4]; ++n4) {
                    }
                } while (n4 != n5);
                byArray[n5] = by;
            }
            for (n5 = 0; n5 < n; ++n5) {
                random.nextBytes((byte[])object);
                gF2_192Array[n5] = new GF2_192(object);
            }
            gF2_192_Poly = GF2_192_Poly.interpolate((byte[])byArray, (GF2_192[])gF2_192Array, null);
            for (n5 = 0; n5 < n; ++n5) {
                GF2_192 gF2_1928 = gF2_192_Poly.evaluate(byArray[n5]);
                Assert.assertFalse((String)("Interpolation error on length =  " + n + " " + n5 + "(with 0 allowed but not additional)"), (!gF2_1928.equals(gF2_192Array[n5]) ? 1 : 0) != 0);
            }
            gF2_1922 = gF2_1923;
            int n6 = ((GF2_192)gF2_1922).length;
            for (n4 = 0; n4 < n6; ++n4) {
                gF2_192 = gF2_1922[n4];
                gF2_192_Poly = GF2_192_Poly.interpolate(null, (GF2_192[])gF2_192Array, (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on points = null", (gF2_192_Poly != null ? 1 : 0) != 0);
                gF2_192_Poly = GF2_192_Poly.interpolate((byte[])byArray, null, (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on values =  null", (gF2_192_Poly != null ? 1 : 0) != 0);
                gF2_192_Poly = GF2_192_Poly.interpolate((byte[])byArray, (GF2_192[])new GF2_192[0], (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on values of length 0", (gF2_192_Poly != null ? 1 : 0) != 0);
                gF2_192_Poly = GF2_192_Poly.interpolate((byte[])new byte[0], (GF2_192[])gF2_192Array, (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on points of length 0", (gF2_192_Poly != null ? 1 : 0) != 0);
                gF2_192_Poly = GF2_192_Poly.interpolate((byte[])new byte[n - 1], (GF2_192[])gF2_192Array, (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on not enough points", (gF2_192_Poly != null ? 1 : 0) != 0);
                gF2_192_Poly = GF2_192_Poly.interpolate((byte[])new byte[n + 1], (GF2_192[])gF2_192Array, (GF2_192)gF2_192);
                Assert.assertFalse((String)"Fail: interpolate should output null on too many points", (gF2_192_Poly != null ? 1 : 0) != 0);
            }
        }
        GF2_192 gF2_1929 = gF2_1923;
        int n7 = ((GF2_192[])gF2_1929).length;
        for (int i = 0; i < n7; ++i) {
            object = gF2_1929[i];
            gF2_192_Poly = GF2_192_Poly.interpolate(null, null, (GF2_192)object);
            Assert.assertFalse((String)"Fail: interpolate should output null on both points and values = null", (gF2_192_Poly != null ? 1 : 0) != 0);
        }
    }

    static {
        GF2_192Test.genTestValues();
    }

    private static class GF2t_slow {
        private long[] x;

        private GF2t_slow() {
        }

        public boolean isOne() {
            if (this.x[0] != 1L) {
                return false;
            }
            for (int i = 1; i < this.x.length; ++i) {
                if (this.x[i] == 0L) continue;
                return false;
            }
            return true;
        }

        public boolean equals(long[] lArray) {
            int n;
            for (n = 0; n < Math.min(this.x.length, lArray.length); ++n) {
                if (this.x[n] == lArray[n]) continue;
                return false;
            }
            while (n < this.x.length) {
                if (this.x[n] != 0L) {
                    return false;
                }
                ++n;
            }
            while (n < lArray.length) {
                if (lArray[n] != 0L) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public static void mulBits(GF2t_slow gF2t_slow, long[] lArray, long[] lArray2) {
            long[] lArray3 = new long[lArray.length + lArray2.length];
            for (int i = 0; i < lArray.length; ++i) {
                for (int j = 0; j < 64; ++j) {
                    for (int k = 0; k < lArray2.length; ++k) {
                        for (int i2 = 0; i2 < 64; ++i2) {
                            if ((lArray[i] & 1L << j) == 0L || (lArray2[k] & 1L << i2) == 0L) continue;
                            int n = i * 64 + j + k * 64 + i2;
                            int n2 = n / 64;
                            lArray3[n2] = lArray3[n2] ^ 1L << n % 64;
                        }
                    }
                }
            }
            gF2t_slow.x = lArray3;
        }

        private static void modReduce(GF2t_slow gF2t_slow, Modulus modulus) {
            for (int i = gF2t_slow.x.length * 64 - 1; i >= modulus.degree; --i) {
                if ((gF2t_slow.x[i >> 6] & 1L << (i & 0x3F)) == 0L) continue;
                for (int j = 0; j < modulus.offset.length; ++j) {
                    int n = i - modulus.offset[j];
                    int n2 = n >> 6;
                    gF2t_slow.x[n2] = gF2t_slow.x[n2] ^ 1L << (n & 0x3F);
                }
            }
        }

        public String toString() {
            String string = "";
            for (int i = this.x.length - 1; i >= 0; --i) {
                string = string + this.x[i];
            }
            return string;
        }

        static /* synthetic */ long[] access$402(GF2t_slow gF2t_slow, long[] lArray) {
            gF2t_slow.x = lArray;
            return lArray;
        }

        public static class Modulus {
            private final int[] offset;
            private final int degree;

            Modulus(int[] nArray) {
                this.degree = nArray[0];
                this.offset = new int[nArray.length];
                this.offset[0] = 0;
                for (int i = 1; i < nArray.length; ++i) {
                    this.offset[i] = this.degree - nArray[i];
                }
            }
        }
    }
}

