/*
 * Decompiled with CFR 0.152.
 */
package scalan.util;

import java.io.File;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scalan.BaseNestedTests;
import scalan.util.FileUtil$;

@ScalaSignature(bytes="\u0006\u0001E1AAA\u0002\u0001\u0011!)Q\u0002\u0001C\u0001\u001d\tia)\u001b7f+RLG\u000eV3tiNT!\u0001B\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0002\r\u000511oY1mC:\u001c\u0001a\u0005\u0002\u0001\u0013A\u0011!bC\u0007\u0002\u000b%\u0011A\"\u0002\u0002\u0010\u0005\u0006\u001cXMT3ti\u0016$G+Z:ug\u00061A(\u001b8jiz\"\u0012a\u0004\t\u0003!\u0001i\u0011a\u0001")
public class FileUtilTests
extends BaseNestedTests {
    public FileUtilTests() {
        this.describe("File traversals", (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            File root = FileUtil$.MODULE$.file("common/src/test/resources/root", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            File subdir = FileUtil$.MODULE$.file(root, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subdir"}));
            File subsubdir = FileUtil$.MODULE$.file(subdir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subsubdir"}));
            File dir = FileUtil$.MODULE$.file(root, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty"}));
            dir.mkdir();
            File empty = dir;
            File A2 = FileUtil$.MODULE$.file(root, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.txt"}));
            File B = FileUtil$.MODULE$.file(root, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B.txt"}));
            File C = FileUtil$.MODULE$.file(subdir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C.txt"}));
            File D = FileUtil$.MODULE$.file(subsubdir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D.txt"}));
            this.it().apply("list all files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
                this.convertToAnyShouldWrapper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listFiles(root, FileUtil$.MODULE$.listFiles$default$2()))).toSet(), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 18), Prettifier$.MODULE$.default()).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{A2, B})));
                return this.convertToAnyShouldWrapper(FileUtil$.MODULE$.listFiles(empty, FileUtil$.MODULE$.listFiles$default$2()), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 19), Prettifier$.MODULE$.default()).shouldBe(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()));
            }, new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 17));
            this.it().apply("list directories", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> this.convertToAnyShouldWrapper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listDirectories(root))).toSet(), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 22), Prettifier$.MODULE$.default()).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{subdir, empty}))), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 21));
            this.it().apply("list directories recursive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> this.convertToAnyShouldWrapper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listDirectoriesRecursive(root))).toSet(), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25), Prettifier$.MODULE$.default()).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{root, subdir, empty, subsubdir}))), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
            this.it().apply("list files recursive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> this.convertToAnyShouldWrapper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listFilesRecursive(root))).toSet(), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28), Prettifier$.MODULE$.default()).shouldBe((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{A2, B, C, D}))), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        }, new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 7));
        this.describe("file path methods", (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.it().apply("extractModuleName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            this.convertToStringShouldWrapper(FileUtil$.MODULE$.extractModuleName("src/main/scala/d", FileUtil$.MODULE$.extractModuleName$default$2()), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33), Prettifier$.MODULE$.default()).shouldBe((Object)"");
            this.convertToStringShouldWrapper(FileUtil$.MODULE$.extractModuleName("/src/main/scala/d", FileUtil$.MODULE$.extractModuleName$default$2()), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34), Prettifier$.MODULE$.default()).shouldBe((Object)"");
            this.convertToStringShouldWrapper(FileUtil$.MODULE$.extractModuleName("b/src/main/scala/d", FileUtil$.MODULE$.extractModuleName$default$2()), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35), Prettifier$.MODULE$.default()).shouldBe((Object)"b");
            return this.convertToStringShouldWrapper(FileUtil$.MODULE$.extractModuleName("a/b/src/main/scala/d", FileUtil$.MODULE$.extractModuleName$default$2()), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36), Prettifier$.MODULE$.default()).shouldBe((Object)"b");
        }, new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32)), new Position("FileUtilTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
    }
}

