/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.utxo.blockchain;

import java.io.Serializable;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.ErgoBoxReader;
import org.ergoplatform.ErgoLikeContext;
import org.ergoplatform.ErgoLikeTransaction;
import org.ergoplatform.ErgoLikeTransactionTemplate;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.UnsignedErgoLikeTransaction$;
import org.ergoplatform.UnsignedInput;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import scalan.RType$;
import scorex.crypto.authds.avltree.batch.BatchAVLProver;
import scorex.crypto.authds.avltree.batch.Insert;
import scorex.crypto.authds.avltree.batch.Operation;
import scorex.crypto.authds.avltree.batch.Remove;
import scorex.crypto.authds.package;
import scorex.crypto.hash.Blake2b256$;
import sigmastate.Values;
import sigmastate.Values$;
import sigmastate.basics.DLogProtocol;
import sigmastate.eval.IRContext;
import sigmastate.helpers.BlockchainState;
import sigmastate.helpers.ErgoLikeContextTesting$;
import sigmastate.helpers.ErgoLikeTestProvingInterpreter;
import sigmastate.helpers.ErgoTransactionValidator;
import sigmastate.helpers.SigmaTestingCommons;
import sigmastate.interpreter.ContextExtension;
import sigmastate.interpreter.ContextExtension$;
import sigmastate.interpreter.CostedProverResult;
import sigmastate.interpreter.Interpreter$;
import sigmastate.interpreter.InterpreterContext;
import sigmastate.utils.Helpers;
import sigmastate.utils.Helpers$;
import sigmastate.utxo.blockchain.BlockchainSimulationTestingCommons$;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0011\rba\u0002,X!\u0003\r\tA\u0018\u0005\u0006[\u0002!\tA\u001c\u0005\u0006k\u0002!)B\u001e\u0005\n\u0007\u007f\u0004\u0011\u0013!C\u000b\t\u0003A\u0011\u0002\"\u0002\u0001#\u0003%)\u0002b\u0002\t\u000f\u0011-\u0001\u0001\"\u0005\u0005\u000e!IAQ\u0004\u0001\u0012\u0002\u0013EA\u0011\u0001\u0005\n\t?\u0001\u0011\u0013!C\t\t\u000fAq\u0001\"\t\u0001\t#\t9bB\u0004\u0002\n]C\t!a\u0003\u0007\rY;\u0006\u0012AA\b\u0011\u001d\t\tB\u0003C\u0001\u0003'A\u0011\"!\u0006\u000b\u0005\u0004%I!a\u0006\t\u0011\u0005}!\u0002)A\u0005\u000331a!!\t\u000b\u0001\u0006\r\u0002BCA\u001c\u001d\tU\r\u0011\"\u0001\u0002:!Q\u0011\u0011\f\b\u0003\u0012\u0003\u0006I!a\u000f\t\u0015\u0005mcB!f\u0001\n\u0003\ti\u0006\u0003\u0006\u0002l9\u0011\t\u0012)A\u0005\u0003?Bq!!\u0005\u000f\t\u0003\ti\u0007C\u0005\u0002x9\t\t\u0011\"\u0001\u0002z!I\u0011q\u0010\b\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003/s\u0011\u0013!C\u0001\u00033C\u0011\"!(\u000f\u0003\u0003%\t%a(\t\u0013\u0005Ef\"!A\u0005\u0002\u0005]\u0001\"CAZ\u001d\u0005\u0005I\u0011AA[\u0011%\t\tMDA\u0001\n\u0003\n\u0019\rC\u0005\u0002R:\t\t\u0011\"\u0001\u0002T\"I\u0011Q\u001c\b\u0002\u0002\u0013\u0005\u0013q\u001c\u0005\n\u0003Ct\u0011\u0011!C!\u0003GD\u0011\"!:\u000f\u0003\u0003%\t%a:\b\u0013\u0005-(\"!A\t\u0002\u00055h!CA\u0011\u0015\u0005\u0005\t\u0012AAx\u0011\u001d\t\t\u0002\tC\u0001\u0003{D\u0011\"!9!\u0003\u0003%)%a9\t\u0013\u0005}\b%!A\u0005\u0002\n\u0005\u0001\"\u0003B\u0004A\u0005\u0005I\u0011\u0011B\u0005\u0011%\u0011Y\u0002IA\u0001\n\u0013\u0011iB\u0002\u0004\u0003&)\u0001!q\u0005\u0005\u000b\u0005_1#\u0011!Q\u0001\n\tE\u0002bBA\tM\u0011\u00051qD\u0003\u0007\u0007G1Ca!\n\t\u000f\rmb\u0005\"\u0003\u0004>!I1q\t\u0014C\u0002\u0013%1\u0011\n\u0005\t\u000732\u0003\u0015!\u0003\u0004L!911\f\u0014\u0005B\ru\u0003bBB.M\u0011\u00051Q\u000f\u0005\b\u0007s2C\u0011AB>\u0011\u001d\u00199I\nC\u0001\u0007\u0013Cqaa+'\t\u0003\u0019i\u000bC\u0004\u0003H\u001a\"\ta!-\t\u000f\rUf\u0005\"\u0001\u00048\u001a1!\u0011\b\u0006A\u0005\u001fC\u0011\u0002\u001f\u001b\u0003\u0016\u0004%\tA!%\t\u0015\teEG!E!\u0002\u0013\u0011\u0019\n\u0003\u0006\u0003\u001cR\u0012)\u001a!C\u0001\u0005;C!B!)5\u0005#\u0005\u000b\u0011\u0002BP\u0011)\u0011\u0019\u000b\u000eB\u0001B\u0003-!Q\u0015\u0005\b\u0003#!D\u0011\u0001BY\u0011%\u0011Y\f\u000eb\u0001\n\u0003\u0011i\f\u0003\u0005\u0003FR\u0002\u000b\u0011\u0002B`\u0011\u001d\u00119\r\u000eC\u0001\u0005\u0013D\u0011Ba85#\u0003%\tA!9\t\u0013\u0005]D'!A\u0005\u0002\t\u0015\b\"CA@iE\u0005I\u0011\u0001Bx\u0011%\t9\nNI\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0002\u001eR\n\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0017\u001b\u0002\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003g#\u0014\u0011!C\u0001\u0005oD\u0011\"!15\u0003\u0003%\t%a1\t\u0013\u0005EG'!A\u0005\u0002\tm\b\"CAoi\u0005\u0005I\u0011IAp\u0011%\t\t\u000fNA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002fR\n\t\u0011\"\u0011\u0003\u0000\u001e9!Q\u0007\u0006\t\u0002\t]ba\u0002B\u001d\u0015!\u0005!1\b\u0005\b\u0003#YE\u0011\u0001B\u001f\u000b\u0019\u0011yd\u0013\u0001\u0003B!I!\u0011Q&C\u0002\u0013\u0005!1\u0011\u0005\t\u0005\u000b[\u0005\u0015!\u0003\u0002p!9!qQ&\u0005\u0002\t%\u0005\"CB\u0004\u0017F\u0005I\u0011AB\u0005\u0011%\typSA\u0001\n\u0003\u001bi\u0001C\u0005\u0003\b-\u000b\t\u0011\"!\u0004\u0018!I!1D&\u0002\u0002\u0013%!Q\u0004\u0005\n\u00057Q\u0011\u0011!C\u0005\u0005;\u0011!E\u00117pG.\u001c\u0007.Y5o'&lW\u000f\\1uS>tG+Z:uS:<7i\\7n_:\u001c(B\u0001-Z\u0003)\u0011Gn\\2lG\"\f\u0017N\u001c\u0006\u00035n\u000bA!\u001e;y_*\tA,\u0001\u0006tS\u001el\u0017m\u001d;bi\u0016\u001c\u0001aE\u0002\u0001?\u001e\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u0013M\u001c\u0017\r\\1uKN$(\"\u00013\u0002\u0007=\u0014x-\u0003\u0002gC\nA\u0001K]8q'B,7\r\u0005\u0002iW6\t\u0011N\u0003\u0002k7\u00069\u0001.\u001a7qKJ\u001c\u0018B\u00017j\u0005M\u0019\u0016nZ7b)\u0016\u001cH/\u001b8h\u0007>lWn\u001c8t\u0003\u0019!\u0013N\\5uIQ\tq\u000e\u0005\u0002qg6\t\u0011OC\u0001s\u0003\u0015\u00198-\u00197b\u0013\t!\u0018O\u0001\u0003V]&$\u0018AC2iK\u000e\\7\u000b^1uKRaqn^B`\u0007\u0013\u001cim!5\u0004f\")\u0001P\u0001a\u0001s\u0006)1\u000f^1uKB\u0011!\u0010\u000e\b\u0003w&q1\u0001`A\u0004\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q,\u0001\u0004=e>|GOP\u0005\u00029&\u0011!lW\u0005\u00031f\u000b!E\u00117pG.\u001c\u0007.Y5o'&lW\u000f\\1uS>tG+Z:uS:<7i\\7n_:\u001c\bcAA\u0007\u00155\tqkE\u0002\u000b?\u001e\fa\u0001P5oSRtDCAA\u0006\u00031i\u0015\r\u001f\"m_\u000e\\7i\\:u+\t\tI\u0002E\u0002q\u00037I1!!\br\u0005\rIe\u000e^\u0001\u000e\u001b\u0006D(\t\\8dW\u000e{7\u000f\u001e\u0011\u0003\u0013\u0019+H\u000e\u001c\"m_\u000e\\7c\u0002\b\u0002&\u0005-\u0012\u0011\u0007\t\u0004a\u0006\u001d\u0012bAA\u0015c\n1\u0011I\\=SK\u001a\u00042\u0001]A\u0017\u0013\r\ty#\u001d\u0002\b!J|G-^2u!\r\u0001\u00181G\u0005\u0004\u0003k\t(\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0001;ygV\u0011\u00111\b\t\u0007\u0003{\t9%!\u0014\u000f\t\u0005}\u00121\t\b\u0004}\u0006\u0005\u0013\"\u0001:\n\u0007\u0005\u0015\u0013/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00131\n\u0002\u000b\u0013:$W\r_3e'\u0016\f(bAA#cB!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\r\fA\"\u001a:h_Bd\u0017\r\u001e4pe6LA!a\u0016\u0002R\t\u0019RI]4p\u0019&\\W\r\u0016:b]N\f7\r^5p]\u0006!A\u000f_:!\u0003-i\u0017N\\3s!V\u00147.Z=\u0016\u0005\u0005}\u0003#\u00029\u0002b\u0005\u0015\u0014bAA2c\n)\u0011I\u001d:bsB\u0019\u0001/a\u001a\n\u0007\u0005%\u0014O\u0001\u0003CsR,\u0017\u0001D7j]\u0016\u0014\b+\u001e2lKf\u0004CCBA8\u0003g\n)\bE\u0002\u0002r9i\u0011A\u0003\u0005\b\u0003o\u0019\u0002\u0019AA\u001e\u0011\u001d\tYf\u0005a\u0001\u0003?\nAaY8qsR1\u0011qNA>\u0003{B\u0011\"a\u000e\u0015!\u0003\u0005\r!a\u000f\t\u0013\u0005mC\u0003%AA\u0002\u0005}\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007SC!a\u000f\u0002\u0006.\u0012\u0011q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012F\f!\"\u00198o_R\fG/[8o\u0013\u0011\t)*a#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m%\u0006BA0\u0003\u000b\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAQ!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bA\u0001\\1oO*\u0011\u00111V\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0006\u0015&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0016Q\u0018\t\u0004a\u0006e\u0016bAA^c\n\u0019\u0011I\\=\t\u0013\u0005}\u0016$!AA\u0002\u0005e\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002FB1\u0011qYAg\u0003ok!!!3\u000b\u0007\u0005-\u0017/\u0001\u0006d_2dWm\u0019;j_:LA!a4\u0002J\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t).a7\u0011\u0007A\f9.C\u0002\u0002ZF\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002@n\t\t\u00111\u0001\u00028\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001a\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\"\u00061Q-];bYN$B!!6\u0002j\"I\u0011q\u0018\u0010\u0002\u0002\u0003\u0007\u0011qW\u0001\n\rVdGN\u00117pG.\u00042!!\u001d!'\u0015\u0001\u0013\u0011_A\u0019!)\t\u00190!?\u0002<\u0005}\u0013qN\u0007\u0003\u0003kT1!a>r\u0003\u001d\u0011XO\u001c;j[\u0016LA!a?\u0002v\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u00055\u0018!B1qa2LHCBA8\u0005\u0007\u0011)\u0001C\u0004\u00028\r\u0002\r!a\u000f\t\u000f\u0005m3\u00051\u0001\u0002`\u00059QO\\1qa2LH\u0003\u0002B\u0006\u0005/\u0001R\u0001\u001dB\u0007\u0005#I1Aa\u0004r\u0005\u0019y\u0005\u000f^5p]B9\u0001Oa\u0005\u0002<\u0005}\u0013b\u0001B\u000bc\n1A+\u001e9mKJB\u0011B!\u0007%\u0003\u0003\u0005\r!a\u001c\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0010!\u0011\t\u0019K!\t\n\t\t\r\u0012Q\u0015\u0002\u0007\u001f\nTWm\u0019;\u0003+%sW*Z7pef,%oZ8C_b\u0014V-\u00193feN)a%!\n\u0003*A!\u0011q\nB\u0016\u0013\u0011\u0011i#!\u0015\u0003\u001b\u0015\u0013xm\u001c\"pqJ+\u0017\rZ3s\u0003\u0019\u0001(o\u001c<feB\u0019!1G'\u000f\u0007\u0005E$*A\bWC2LG-\u0019;j_:\u001cF/\u0019;f!\r\t\th\u0013\u0002\u0010-\u0006d\u0017\u000eZ1uS>t7\u000b^1uKN)1*!\n\u00022Q\u0011!q\u0007\u0002\f\u0005\u0006$8\r\u001b)s_Z,'\u000f\u0005\u0005\u0003D\te#Q\fB=\u001b\t\u0011)E\u0003\u0003\u0003H\t%\u0013!\u00022bi\u000eD'\u0002\u0002B&\u0005\u001b\nq!\u0019<miJ,WM\u0003\u0003\u0003P\tE\u0013AB1vi\"$7O\u0003\u0003\u0003T\tU\u0013AB2ssB$xN\u0003\u0002\u0003X\u000511oY8sKbLAAa\u0017\u0003F\tq!)\u0019;dQ\u00063F\n\u0015:pm\u0016\u0014\b\u0003\u0002B0\u0005grAA!\u0019\u0003p9!!1\rB6\u001d\u0011\u0011)G!\u001b\u000f\u0007y\u00149'\u0003\u0002\u0003X%!!1\u000bB+\u0013\u0011\u0011iG!\u0015\u0002\t!\f7\u000f[\u0005\u0005\u0003\u000b\u0012\tH\u0003\u0003\u0003n\tE\u0013\u0002\u0002B;\u0005o\u0012\u0001\u0002R5hKN$8G\r\u0006\u0005\u0003\u000b\u0012\tH\u0004\u0003\u0003|\tuTB\u0001B9\u0013\u0011\u0011yH!\u001d\u0002\u0015\tc\u0017m[33EJ*d'A\u0005j]&$(\t\\8dWV\u0011\u0011qN\u0001\u000bS:LGO\u00117pG.\u0004\u0013\u0001D5oSRL\u0017\r\\*uCR,G\u0003\u0002BF\u0007\u000b!BA!$\u0004\u0004A\u0019\u0011\u0011\u000f\u001b\u0014\u000fQ\n)#a\u000b\u00022U\u0011!1\u0013\t\u0004Q\nU\u0015b\u0001BLS\ny!\t\\8dW\u000eD\u0017-\u001b8Ti\u0006$X-\u0001\u0004ti\u0006$X\rI\u0001\fE>DXm\u001d*fC\u0012,'/\u0006\u0002\u0003 B\u0019\u0011\u0011\u000f\u0014\u0002\u0019\t|\u00070Z:SK\u0006$WM\u001d\u0011\u0002\u0005%\u0013\u0006\u0003\u0002BT\u0005[k!A!+\u000b\u0007\t-6,\u0001\u0003fm\u0006d\u0017\u0002\u0002BX\u0005S\u0013\u0011\"\u0013*D_:$X\r\u001f;\u0015\r\tM&q\u0017B])\u0011\u0011iI!.\t\u000f\t\r&\bq\u0001\u0003&\"1\u0001P\u000fa\u0001\u0005'CqAa';\u0001\u0004\u0011y*A\u0005wC2LG-\u0019;peV\u0011!q\u0018\t\u0004Q\n\u0005\u0017b\u0001BbS\nARI]4p)J\fgn]1di&|gNV1mS\u0012\fGo\u001c:\u0002\u0015Y\fG.\u001b3bi>\u0014\b%\u0001\u0006baBd\u0017P\u00117pG.$bAa3\u0003X\nm\u0007C\u0002Bg\u0005'\u0014i)\u0004\u0002\u0003P*\u0019!\u0011[9\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005+\u0014yMA\u0002UefDqA!7>\u0001\u0004\ty'A\u0003cY>\u001c7\u000eC\u0005\u0003^v\u0002\n\u00111\u0001\u0002\u001a\u00059Q.\u0019=D_N$\u0018\u0001F1qa2L(\t\\8dW\u0012\"WMZ1vYR$#'\u0006\u0002\u0003d*\"\u0011\u0011DAC)\u0019\u00119Oa;\u0003nR!!Q\u0012Bu\u0011\u001d\u0011\u0019k\u0010a\u0002\u0005KC\u0001\u0002_ \u0011\u0002\u0003\u0007!1\u0013\u0005\n\u00057{\u0004\u0013!a\u0001\u0005?+\"A!=+\t\tM\u0015QQ\u000b\u0003\u0005kTCAa(\u0002\u0006R!\u0011q\u0017B}\u0011%\ty\fRA\u0001\u0002\u0004\tI\u0002\u0006\u0003\u0002V\nu\b\"CA`\r\u0006\u0005\t\u0019AA\\)\u0011\t)n!\u0001\t\u0013\u0005}\u0016*!AA\u0002\u0005]\u0006b\u0002BR!\u0002\u000f!Q\u0015\u0005\n\u00053\u0004\u0006\u0013!a\u0001\u0003_\na#\u001b8ji&\fGn\u0015;bi\u0016$C-\u001a4bk2$H%M\u000b\u0003\u0007\u0017QC!a\u001c\u0002\u0006R11qBB\n\u0007+!BA!$\u0004\u0012!9!1\u0015*A\u0004\t\u0015\u0006B\u0002=S\u0001\u0004\u0011\u0019\nC\u0004\u0003\u001cJ\u0003\rAa(\u0015\t\re1Q\u0004\t\u0006a\n511\u0004\t\ba\nM!1\u0013BP\u0011%\u0011IbUA\u0001\u0002\u0004\u0011i\t\u0006\u0003\u0003 \u000e\u0005\u0002b\u0002B\u0018Q\u0001\u0007!\u0011\u0007\u0002\b\u0017\u0016LH+\u001f9f!\u0011\u00199c!\u000e\u000f\t\r%2q\u0006\b\u0005\u0003\u000f\u001cY#\u0003\u0003\u0004.\u0005%\u0017aB7vi\u0006\u0014G.Z\u0005\u0005\u0007c\u0019\u0019$\u0001\u0007Xe\u0006\u0004\b/\u001a3BeJ\f\u0017P\u0003\u0003\u0004.\u0005%\u0017\u0002BB\u001c\u0007s\u0011aa\u001c4CsR,'\u0002BB\u0019\u0007g\taaZ3u\u0017\u0016LH\u0003BB \u0007\u0007\u00022a!\u0011*\u001b\u00051\u0003bBB#U\u0001\u0007\u0011qL\u0001\u0003S\u0012\fQAY8yKN,\"aa\u0013\u0011\u0011\r53qJB\u0013\u0007'j!aa\r\n\t\rE31\u0007\u0002\u0004\u001b\u0006\u0004\b\u0003BA(\u0007+JAaa\u0016\u0002R\t9QI]4p\u0005>D\u0018A\u00022pq\u0016\u001c\b%\u0001\u0003cs&#G\u0003BB0\u0007C\u0002bA!4\u0003T\u000eM\u0003bBB2[\u0001\u00071QM\u0001\u0006E>D\u0018\n\u001a\t\u0005\u0007O\u001ayG\u0004\u0003\u0004j\r5d\u0002\u0002B2\u0007WJAAa\u0014\u0003R%!\u0011Q\tB'\u0013\u0011\u0019\tha\u001d\u0003\u000b\u0005#5*Z=\u000b\t\u0005\u0015#Q\n\u000b\u0005\u0007?\u001a9\bC\u0004\u0004d9\u0002\raa\u0010\u0002\u0017I\fg\u000eZ8n\u0005>DXm\u001d\u000b\u0005\u0007{\u001a\u0019\t\u0005\u0004\u0002>\r}41K\u0005\u0005\u0007\u0003\u000bYE\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u0019)i\fa\u0001\u00033\tq\u0001[8x\u001b\u0006t\u00170A\u0005csR;x.\u00138ugRQ11RBG\u0007?\u001b\u0019ka*\u0011\u000bA\u0014iaa\u0015\t\u000f\r=\u0005\u00071\u0001\u0004\u0012\u0006!!/M%e!\u0011\u0019\u0019j!'\u000f\t\u0005=3QS\u0005\u0005\u0007/\u000b\t&A\u0004Fe\u001e|'i\u001c=\n\t\rm5Q\u0014\u0002\u000b%\u0016<\u0017n\u001d;fe&#'\u0002BBL\u0003#Bqa!)1\u0001\u0004\tI\"\u0001\u0003j]R\f\u0004bBBSa\u0001\u00071\u0011S\u0001\u0005eJJE\rC\u0004\u0004*B\u0002\r!!\u0007\u0002\t%tGOM\u0001\u0007C2d\u0017\nZ:\u0016\u0005\r=\u0006CBA\u001f\u0007\u007f\u001ay\u0004F\u0002p\u0007gCqA!73\u0001\u0004\ty'\u0001\u0004eS\u001e,7\u000f^\u000b\u0003\u0007s\u0003Baa\u001a\u0004<&!1QXB:\u0005!\tE\tR5hKN$\bbBBa\u0005\u0001\u000711Y\u0001\u0006[&tWM\u001d\t\u0004Q\u000e\u0015\u0017bABdS\nqRI]4p\u0019&\\W\rV3tiB\u0013xN^5oO&sG/\u001a:qe\u0016$XM\u001d\u0005\b\u0007\u0017\u0014\u0001\u0019AA\r\u00031\u0019WO\u001d:f]RdUM^3m\u0011\u001d\u0019yM\u0001a\u0001\u00033\tQ\u0001\\5nSRD\u0011ba5\u0003!\u0003\u0005\ra!6\u0002\u000fA\u0014x\u000e](qiB)\u0001O!\u0004\u0004XB!1\u0011\\Bp\u001d\ri81\\\u0005\u0004\u0007;\\\u0016A\u0002,bYV,7/\u0003\u0003\u0004b\u000e\r(\u0001C#sO>$&/Z3\u000b\u0007\ru7\fC\u0005\u0004h\n\u0001\n\u00111\u0001\u0004j\u0006IQ\r\u001f;f]NLwN\u001c\t\u0005\u0007W\u001c\t0\u0004\u0002\u0004n*\u00191q^.\u0002\u0017%tG/\u001a:qe\u0016$XM]\u0005\u0005\u0007g\u001ciO\u0001\tD_:$X\r\u001f;FqR,gn]5p]\"\u001a!aa>\u0011\t\re81`\u0007\u0003\u0003\u001fKAa!@\u0002\u0010\n9A/Y5me\u0016\u001c\u0017\u0001F2iK\u000e\\7\u000b^1uK\u0012\"WMZ1vYR$S'\u0006\u0002\u0005\u0004)\"1Q[AC\u0003Q\u0019\u0007.Z2l'R\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%mU\u0011A\u0011\u0002\u0016\u0005\u0007S\f))A\u0007hK:,'/\u0019;f\u00052|7m\u001b\u000b\r\t\u001f!\t\u0002b\u0005\u0005\u0016\u0011eA1\u0004\t\u0003u:AQ\u0001_\u0003A\u0002eDqAa\f\u0006\u0001\u0004\u0019\u0019\rC\u0004\u0005\u0018\u0015\u0001\r!!\u0007\u0002\r!,\u0017n\u001a5u\u0011%\u0019\u0019.\u0002I\u0001\u0002\u0004\u0019)\u000eC\u0005\u0004h\u0016\u0001\n\u00111\u0001\u0004j\u00069r-\u001a8fe\u0006$XM\u00117pG.$C-\u001a4bk2$H\u0005N\u0001\u0018O\u0016tWM]1uK\ncwnY6%I\u00164\u0017-\u001e7uIU\naB]1oI>lG)Z3q]\u0016\u001c8\u000f")
public interface BlockchainSimulationTestingCommons
extends SigmaTestingCommons {
    public static void registerIgnoredTest(String string, Seq<Tag> seq, Function0<Object> function0, Position position) {
        BlockchainSimulationTestingCommons$.MODULE$.registerIgnoredTest(string, seq, function0, position);
    }

    public static void registerTest(String string, Seq<Tag> seq, Function0<Object> function0, Position position) {
        BlockchainSimulationTestingCommons$.MODULE$.registerTest(string, seq, function0, position);
    }

    public static /* synthetic */ void checkState$(BlockchainSimulationTestingCommons $this, ValidationState state, ErgoLikeTestProvingInterpreter miner, int currentLevel, int limit, Option propOpt, ContextExtension extension) {
        $this.checkState(state, miner, currentLevel, limit, (Option<Values.ErgoTree>)propOpt, extension);
    }

    default public void checkState(ValidationState state, ErgoLikeTestProvingInterpreter miner, int currentLevel, int limit, Option<Values.ErgoTree> propOpt, ContextExtension extension) {
        while (true) {
            int n = ++currentLevel;
            switch (n) {
                default: 
            }
            if (n >= limit) break;
            FullBlock block = this.generateBlock(state, miner, currentLevel, propOpt, extension);
            Try<ValidationState> updStateTry = state.applyBlock(block, state.applyBlock$default$2());
            Helpers.TryOps$.MODULE$.getOrThrow$extension(Helpers$.MODULE$.TryOps(updStateTry));
            state = (ValidationState)updStateTry.get();
        }
    }

    public static /* synthetic */ Option checkState$default$5$(BlockchainSimulationTestingCommons $this) {
        return $this.checkState$default$5();
    }

    default public Option<Values.ErgoTree> checkState$default$5() {
        return None$.MODULE$;
    }

    public static /* synthetic */ ContextExtension checkState$default$6$(BlockchainSimulationTestingCommons $this) {
        return $this.checkState$default$6();
    }

    default public ContextExtension checkState$default$6() {
        return ContextExtension$.MODULE$.empty();
    }

    public static /* synthetic */ FullBlock generateBlock$(BlockchainSimulationTestingCommons $this, ValidationState state, ErgoLikeTestProvingInterpreter prover, int height, Option propOpt, ContextExtension extension) {
        return $this.generateBlock(state, prover, height, (Option<Values.ErgoTree>)propOpt, extension);
    }

    default public FullBlock generateBlock(ValidationState state, ErgoLikeTestProvingInterpreter prover, int height, Option<Values.ErgoTree> propOpt, ContextExtension extension) {
        Values.ErgoTree prop = (Values.ErgoTree)propOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> Values.ErgoTree$.MODULE$.fromProposition(Values.SigmaBooleanOps$.MODULE$.toSigmaProp$extension(Values$.MODULE$.SigmaBooleanOps((Values.SigmaBoolean)((DLogProtocol.DLogProverInput)prover.dlogSecrets().head()).publicImage()))));
        byte[] minerPubkey = ((DLogProtocol.DLogProverInput)prover.dlogSecrets().head()).publicImage().pkBytes();
        Iterable<ErgoBox> boxesToSpend = state.boxesReader().randomBoxes(30 + height);
        scala.collection.immutable.IndexedSeq txs = (scala.collection.immutable.IndexedSeq)Predef.Ensuring$.MODULE$.ensuring$extension3(Predef$.MODULE$.Ensuring((Object)((TraversableOnce)boxesToSpend.map((Function1 & Serializable & scala.Serializable)box -> {
            ErgoBoxCandidate newBoxCandidate = new ErgoBoxCandidate(10L, prop, height, sigmastate.eval.package$.MODULE$.Colls().emptyColl(RType$.MODULE$.pairRType(sigmastate.eval.package$.MODULE$.Digest32RType(), RType$.MODULE$.LongType())), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            UnsignedInput unsignedInput = new UnsignedInput(box.id());
            UnsignedErgoLikeTransaction tx = UnsignedErgoLikeTransaction$.MODULE$.apply((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnsignedInput[]{unsignedInput})), (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErgoBoxCandidate[]{newBoxCandidate})));
            ErgoLikeContext context = ErgoLikeContextTesting$.MODULE$.apply(height + 1, state.state().lastBlockUtxoRoot(), minerPubkey, (IndexedSeq<ErgoBox>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ErgoBox[]{box}))), (ErgoLikeTransactionTemplate<? extends UnsignedInput>)tx, (ErgoBox)box, extension, ErgoLikeContextTesting$.MODULE$.apply$default$8());
            Map env = Interpreter$.MODULE$.emptyEnv().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Interpreter$.MODULE$.ScriptNameProp()), (Object)new StringBuilder(13).append("height_").append(state.state().currentHeight()).append("_prove").toString()));
            CostedProverResult proverResult = (CostedProverResult)prover.prove((Map<String, Object>)env, box.ergoTree(), (InterpreterContext)context, tx.messageToSign(), prover.prove$default$5()).get();
            this.convertToAnyShouldWrapper(proverResult.extension(), new Position("BlockchainSimulationTestingCommons.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63), Prettifier$.MODULE$.default()).shouldBe((Object)extension);
            return tx.toSigned((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CostedProverResult[]{proverResult})));
        }, Iterable$.MODULE$.canBuildFrom())).toIndexedSeq()), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to create txs from boxes ").append(boxesToSpend).append(" at height ").append(height).toString());
        return new FullBlock((IndexedSeq<ErgoLikeTransaction>)txs, minerPubkey);
    }

    public static /* synthetic */ Option generateBlock$default$4$(BlockchainSimulationTestingCommons $this) {
        return $this.generateBlock$default$4();
    }

    default public Option<Values.ErgoTree> generateBlock$default$4() {
        return None$.MODULE$;
    }

    public static /* synthetic */ ContextExtension generateBlock$default$5$(BlockchainSimulationTestingCommons $this) {
        return $this.generateBlock$default$5();
    }

    default public ContextExtension generateBlock$default$5() {
        return ContextExtension$.MODULE$.empty();
    }

    public static /* synthetic */ int randomDeepness$(BlockchainSimulationTestingCommons $this) {
        return $this.randomDeepness();
    }

    default public int randomDeepness() {
        return 10 + Random$.MODULE$.nextInt(10);
    }

    public static void $init$(BlockchainSimulationTestingCommons $this) {
    }

    public static class FullBlock
    implements Product,
    scala.Serializable {
        private final IndexedSeq<ErgoLikeTransaction> txs;
        private final byte[] minerPubkey;

        public IndexedSeq<ErgoLikeTransaction> txs() {
            return this.txs;
        }

        public byte[] minerPubkey() {
            return this.minerPubkey;
        }

        public FullBlock copy(IndexedSeq<ErgoLikeTransaction> txs, byte[] minerPubkey) {
            return new FullBlock(txs, minerPubkey);
        }

        public IndexedSeq<ErgoLikeTransaction> copy$default$1() {
            return this.txs();
        }

        public byte[] copy$default$2() {
            return this.minerPubkey();
        }

        public String productPrefix() {
            return "FullBlock";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.txs();
                    break;
                }
                case 1: {
                    object = this.minerPubkey();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FullBlock;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FullBlock)) return false;
            boolean bl = true;
            if (!bl) return false;
            FullBlock fullBlock = (FullBlock)x$1;
            IndexedSeq<ErgoLikeTransaction> indexedSeq = this.txs();
            IndexedSeq<ErgoLikeTransaction> indexedSeq2 = fullBlock.txs();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            if (this.minerPubkey() != fullBlock.minerPubkey()) return false;
            if (!fullBlock.canEqual(this)) return false;
            return true;
        }

        public FullBlock(IndexedSeq<ErgoLikeTransaction> txs, byte[] minerPubkey) {
            this.txs = txs;
            this.minerPubkey = minerPubkey;
            Product.$init$((Product)this);
        }
    }

    public static class InMemoryErgoBoxReader
    implements ErgoBoxReader {
        private final BatchAVLProver<byte[], Blake2b256$> prover;
        private final scala.collection.mutable.Map<WrappedArray.ofByte, ErgoBox> boxes;

        private WrappedArray.ofByte getKey(byte[] id) {
            return new WrappedArray.ofByte(id);
        }

        private scala.collection.mutable.Map<WrappedArray.ofByte, ErgoBox> boxes() {
            return this.boxes;
        }

        public Try<ErgoBox> byId(byte[] boxId) {
            return this.byId(this.getKey(boxId));
        }

        public Try<ErgoBox> byId(WrappedArray.ofByte boxId) {
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ErgoBox)this.boxes().apply((Object)boxId));
        }

        public Iterable<ErgoBox> randomBoxes(int howMany) {
            return (Iterable)((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)this.boxes().values(), Iterable$.MODULE$.canBuildFrom())).take(howMany);
        }

        public Option<ErgoBox> byTwoInts(ErgoBox.RegisterId r1Id, int int1, ErgoBox.RegisterId r2Id, int int2) {
            return this.boxes().values().find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)InMemoryErgoBoxReader.$anonfun$byTwoInts$1(r1Id, int1, r2Id, int2, box)));
        }

        public Iterable<WrappedArray.ofByte> allIds() {
            return this.boxes().keys();
        }

        public void applyBlock(FullBlock block) {
            IndexedSeq toRemove = (IndexedSeq)((TraversableLike)block.txs().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.inputs(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.boxId(), IndexedSeq$.MODULE$.canBuildFrom());
            toRemove.foreach((Function1 & Serializable & scala.Serializable)k -> $this.prover.performOneOperation((Operation)new Remove(k)));
            toRemove.foreach((Function1 & Serializable & scala.Serializable)k -> this.boxes().remove((Object)this.getKey((byte[])k)));
            IndexedSeq toAdd = (IndexedSeq)block.txs().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.outputs(), IndexedSeq$.MODULE$.canBuildFrom());
            toAdd.foreach((Function1 & Serializable & scala.Serializable)b -> $this.prover.performOneOperation((Operation)new Insert(b.id(), (byte[])package.ADValue$.MODULE$.$at$at((Object)b.bytes(), package.Tagger$.MODULE$.baseRaw()))));
            toAdd.foreach((Function1 & Serializable & scala.Serializable)b -> this.boxes().put((Object)this.getKey(b.id()), b));
            this.prover.generateProof();
        }

        public byte[] digest() {
            return this.prover.digest();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final /* synthetic */ boolean $anonfun$byTwoInts$1(ErgoBox.RegisterId r1Id$1, int int1$1, ErgoBox.RegisterId r2Id$1, int int2$1, ErgoBox box) {
            Object object = box.get(r1Id$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> Values.LongConstant$.MODULE$.apply((long)(int1$1 + 1)));
            Values.Constant constant = Values.LongConstant$.MODULE$.apply((long)int1$1);
            if (object == null) {
                if (constant != null) {
                    return false;
                }
            } else if (!object.equals(constant)) return false;
            Object object2 = box.get(r2Id$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> Values.LongConstant$.MODULE$.apply((long)(int2$1 + 1)));
            Values.Constant constant2 = Values.LongConstant$.MODULE$.apply((long)int2$1);
            if (object2 == null) {
                if (constant2 == null) return true;
                return false;
            } else {
                if (!object2.equals(constant2)) return false;
                return true;
            }
        }

        public InMemoryErgoBoxReader(BatchAVLProver<byte[], Blake2b256$> prover) {
            this.prover = prover;
            this.boxes = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }

    public static class ValidationState
    implements Product,
    scala.Serializable {
        private final BlockchainState state;
        private final InMemoryErgoBoxReader boxesReader;
        private final IRContext IR;
        private final ErgoTransactionValidator validator;

        public BlockchainState state() {
            return this.state;
        }

        public InMemoryErgoBoxReader boxesReader() {
            return this.boxesReader;
        }

        public ErgoTransactionValidator validator() {
            return this.validator;
        }

        public Try<ValidationState> applyBlock(FullBlock block, int maxCost) {
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                long blockCost;
                int height = this.state().currentHeight() + 1;
                long $org_scalatest_assert_macro_left = blockCost = BoxesRunTime.unboxToLong((Object)block.txs().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToLong((long)ValidationState.$anonfun$applyBlock$9(this, height, block, BoxesRunTime.unboxToLong((Object)x0$1), x1$1))));
                int $org_scalatest_assert_macro_right = maxCost;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                BlockchainSimulationTestingCommons$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(26).append("Block cost ").append(blockCost).append(" exceeds limit ").append(maxCost).toString(), Prettifier$.MODULE$.default(), new Position("BlockchainSimulationTestingCommons.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                this.boxesReader().applyBlock(block);
                BlockchainState newState = new BlockchainState(height, this.state().lastBlockUtxoRoot().copy(this.boxesReader().digest(), this.state().lastBlockUtxoRoot().copy$default$2(), this.state().lastBlockUtxoRoot().copy$default$3(), this.state().lastBlockUtxoRoot().copy$default$4()));
                return new ValidationState(newState, this.boxesReader(), $this.IR);
            });
        }

        public int applyBlock$default$2() {
            return BlockchainSimulationTestingCommons$.MODULE$.sigmastate$utxo$blockchain$BlockchainSimulationTestingCommons$$MaxBlockCost();
        }

        public ValidationState copy(BlockchainState state, InMemoryErgoBoxReader boxesReader, IRContext IR) {
            return new ValidationState(state, boxesReader, IR);
        }

        public BlockchainState copy$default$1() {
            return this.state();
        }

        public InMemoryErgoBoxReader copy$default$2() {
            return this.boxesReader();
        }

        public String productPrefix() {
            return "ValidationState";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.state();
                    break;
                }
                case 1: {
                    object = this.boxesReader();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ValidationState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ValidationState)) return false;
            boolean bl = true;
            if (!bl) return false;
            ValidationState validationState = (ValidationState)x$1;
            BlockchainState blockchainState = this.state();
            BlockchainState blockchainState2 = validationState.state();
            if (blockchainState == null) {
                if (blockchainState2 != null) {
                    return false;
                }
            } else if (!((Object)blockchainState).equals(blockchainState2)) return false;
            InMemoryErgoBoxReader inMemoryErgoBoxReader = this.boxesReader();
            InMemoryErgoBoxReader inMemoryErgoBoxReader2 = validationState.boxesReader();
            if (inMemoryErgoBoxReader == null) {
                if (inMemoryErgoBoxReader2 != null) {
                    return false;
                }
            } else if (!inMemoryErgoBoxReader.equals(inMemoryErgoBoxReader2)) return false;
            if (!validationState.canEqual(this)) return false;
            return true;
        }

        public static final /* synthetic */ long $anonfun$applyBlock$9(ValidationState $this, int height$2, FullBlock block$1, long x0$1, ErgoLikeTransaction x1$1) {
            long l;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
            if (tuple2 != null) {
                long accCost = tuple2._1$mcJ$sp();
                ErgoLikeTransaction tx = (ErgoLikeTransaction)tuple2._2();
                Either<Throwable, Object> either = $this.validator().validate(tx, $this.state().copy(height$2, $this.state().copy$default$2()), block$1.minerPubkey(), $this.boxesReader());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable throwable = (Throwable)left.value();
                    throw throwable;
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Right right = (Right)either;
                long cost = BoxesRunTime.unboxToLong((Object)right.value());
                l = accCost + cost;
            } else {
                throw new MatchError((Object)tuple2);
            }
            long l2 = l;
            return l2;
        }

        public ValidationState(BlockchainState state, InMemoryErgoBoxReader boxesReader, IRContext IR) {
            this.state = state;
            this.boxesReader = boxesReader;
            this.IR = IR;
            Product.$init$((Product)this);
            this.validator = new ErgoTransactionValidator(IR);
        }
    }
}

