/*
 * Decompiled with CFR 0.152.
 */
package gf2t;

import gf2t.GF2_192;

public class GF2_192_Poly {
    private final GF2_192[] c;
    private int deg;

    public GF2_192_Poly(byte[] byArray, byte[] byArray2) {
        this.deg = byArray2.length / 24;
        this.c = new GF2_192[this.deg + 1];
        this.c[0] = new GF2_192(byArray);
        for (int i = 1; i <= this.deg; ++i) {
            this.c[i] = new GF2_192(byArray2, (i - 1) * 24);
        }
    }

    public static GF2_192_Poly fromByteArray(byte[] byArray, byte[] byArray2) {
        return new GF2_192_Poly(byArray, byArray2);
    }

    public static GF2_192_Poly interpolate(byte[] byArray, GF2_192[] gF2_192Array, GF2_192 gF2_192) {
        GF2_192 gF2_1922;
        if (byArray == null || gF2_192Array == null || gF2_192Array.length == 0 && gF2_192 == null || gF2_192Array.length != byArray.length) {
            return null;
        }
        int n = gF2_192Array.length - 1;
        if (gF2_192 != null) {
            ++n;
        }
        GF2_192_Poly gF2_192_Poly = new GF2_192_Poly(n, 0);
        GF2_192_Poly gF2_192_Poly2 = new GF2_192_Poly(n, 1);
        for (int i = 0; i < byArray.length; ++i) {
            gF2_1922 = gF2_192_Poly.evaluate(byArray[i]);
            GF2_192 gF2_1923 = gF2_192_Poly2.evaluate(byArray[i]);
            GF2_192.add(gF2_1922, gF2_1922, gF2_192Array[i]);
            GF2_192.invert(gF2_1923, gF2_1923);
            GF2_192.mul(gF2_1922, gF2_1922, gF2_1923);
            gF2_192_Poly.addMonicTimesConstantTo(gF2_192_Poly2, gF2_1922);
            if (i >= byArray.length - 1 && gF2_192 == null) continue;
            gF2_192_Poly2.monicTimesMonomial(byArray[i]);
        }
        if (gF2_192 != null) {
            GF2_192 gF2_1924 = new GF2_192(gF2_192_Poly.c[0]);
            gF2_1922 = new GF2_192(gF2_192_Poly2.c[0]);
            GF2_192.add(gF2_1924, gF2_1924, gF2_192);
            GF2_192.invert(gF2_1922, gF2_1922);
            GF2_192.mul(gF2_1924, gF2_1924, gF2_1922);
            gF2_192_Poly.addMonicTimesConstantTo(gF2_192_Poly2, gF2_1924);
        }
        return gF2_192_Poly;
    }

    public GF2_192 evaluate(byte by) {
        GF2_192 gF2_192 = new GF2_192(this.c[this.deg]);
        for (int i = this.deg - 1; i >= 0; --i) {
            GF2_192.mul(gF2_192, gF2_192, by);
            GF2_192.add(gF2_192, gF2_192, this.c[i]);
        }
        return gF2_192;
    }

    private void addMonicTimesConstantTo(GF2_192_Poly gF2_192_Poly, GF2_192 gF2_192) {
        GF2_192 gF2_1922 = new GF2_192();
        for (int i = 0; i < gF2_192_Poly.deg; ++i) {
            GF2_192.mul(gF2_1922, gF2_192_Poly.c[i], gF2_192);
            GF2_192.add(this.c[i], this.c[i], gF2_1922);
        }
        this.deg = gF2_192_Poly.deg;
        this.c[this.deg] = new GF2_192(gF2_192);
    }

    private void monicTimesMonomial(byte by) {
        ++this.deg;
        this.c[this.deg] = new GF2_192(1);
        for (int i = this.deg - 1; i > 0; --i) {
            GF2_192.mul(this.c[i], this.c[i], by);
            GF2_192.add(this.c[i], this.c[i], this.c[i - 1]);
        }
        GF2_192.mul(this.c[0], this.c[0], by);
    }

    private GF2_192_Poly(int n, int n2) {
        this.c = new GF2_192[n + 1];
        this.c[0] = new GF2_192(n2);
        this.deg = 0;
    }

    public String toString() {
        String string = "";
        if (this.deg >= 2) {
            string = string + this.c[this.deg].toString() + "*X^" + this.deg;
            for (int i = this.deg - 1; i >= 2; --i) {
                string = string + " + " + this.c[i] + "*X^" + i;
            }
            string = string + " + ";
        }
        if (this.deg >= 1) {
            string = string + this.c[1] + "*X + ";
        }
        string = string + this.c[0];
        return string;
    }

    public byte[] toByteArray(Boolean bl) {
        int n = bl != false ? 0 : 1;
        byte[] byArray = new byte[(this.deg + 1 - n) * 24];
        for (int i = n; i <= this.deg; ++i) {
            this.c[i].toByteArray(byArray, (i - n) * 24);
        }
        return byArray;
    }

    public byte[] coeff0Bytes() {
        return this.c[0].toByteArray();
    }
}

