/*
 * Decompiled with CFR 0.152.
 */
package scalan.util;

import java.io.File;
import scala.Console$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scalan.util.FileUtil$;
import scalan.util.ProcessOutput;
import scalan.util.StringUtil$;

public final class ProcessUtil$ {
    public static ProcessUtil$ MODULE$;

    static {
        new ProcessUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProcessOutput launch(Seq<String> command, File workingDir, Map<String, String> extraEnv, boolean printToConsole) {
        File absoluteWorkingDir = workingDir.getAbsoluteFile();
        ProcessBuilder builder = Process$.MODULE$.apply(command, absoluteWorkingDir, extraEnv.toSeq());
        ArrayBuffer stdOutBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer stdErrBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer interleavedBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ProcessLogger logger = ProcessLogger$.MODULE$.apply((Function1 & java.io.Serializable & Serializable)outLine -> {
            ProcessUtil$.$anonfun$launch$1(printToConsole, stdOutBuffer, interleavedBuffer, outLine);
            return BoxedUnit.UNIT;
        }, (Function1 & java.io.Serializable & Serializable)errLine -> {
            ProcessUtil$.$anonfun$launch$2(printToConsole, stdErrBuffer, interleavedBuffer, errLine);
            return BoxedUnit.UNIT;
        });
        int n = builder.$bang(logger);
        switch (n) {
            case 0: {
                return new ProcessOutput((Seq<String>)stdOutBuffer, (Seq<String>)stdErrBuffer, (Seq<String>)interleavedBuffer);
            }
            default: {
                String envPrefix = ((TraversableOnce)extraEnv.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String name = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    String string = new StringBuilder(2).append(name).append("=").append(MODULE$.escapeCommandLineArg(value)).append(" ").toString();
                    return string;
                }, Iterable$.MODULE$.canBuildFrom())).mkString("");
                String commandString = ((TraversableOnce)command.map((Function1 & java.io.Serializable & Serializable)arg -> MODULE$.escapeCommandLineArg((String)arg), Seq$.MODULE$.canBuildFrom())).mkString(" ");
                throw new RuntimeException(new StringBuilder(70).append("Executing `").append(envPrefix).append(commandString).append("` in directory ").append(absoluteWorkingDir).append(" returned exit code ").append(n).append(" with following output:\n").append(interleavedBuffer.mkString("\n")).toString());
            }
        }
    }

    public File launch$default$2() {
        return FileUtil$.MODULE$.currentWorkingDir();
    }

    public Map<String, String> launch$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean launch$default$4() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String escapeCommandLineArg(String arg) {
        String string;
        block5: {
            String escaped;
            block4: {
                if (arg.contains(" ") && !arg.contains("'")) {
                    string = new StringBuilder(2).append("'").append(arg).append("'").toString();
                    return string;
                }
                escaped = arg.replace("\\", "\\\\").replace("$", "\\$").replace("`", "\\`").replace("\"", "\\\"").replace("\n", "\\\n");
                if (escaped.contains(" ")) break block4;
                String string2 = escaped;
                String string3 = arg;
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block5;
            }
            string = StringUtil$.MODULE$.quote(escaped);
            return string;
        }
        string = arg;
        return string;
    }

    public static final /* synthetic */ void $anonfun$launch$1(boolean printToConsole$1, ArrayBuffer stdOutBuffer$1, ArrayBuffer interleavedBuffer$1, String outLine) {
        if (printToConsole$1) {
            Console$.MODULE$.out().println(outLine);
        }
        stdOutBuffer$1.$plus$eq((Object)outLine);
        interleavedBuffer$1.$plus$eq((Object)outLine);
    }

    public static final /* synthetic */ void $anonfun$launch$2(boolean printToConsole$1, ArrayBuffer stdErrBuffer$1, ArrayBuffer interleavedBuffer$1, String errLine) {
        if (printToConsole$1) {
            Console$.MODULE$.err().println(errLine);
        }
        stdErrBuffer$1.$plus$eq((Object)errLine);
        interleavedBuffer$1.$plus$eq((Object)errLine);
    }

    private ProcessUtil$() {
        MODULE$ = this;
    }
}

