/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.basics;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.bouncycastle.util.BigIntegers;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import sigmastate.basics.DiffieHellmanTupleProverInput;
import sigmastate.basics.FirstDiffieHellmanTupleProverMessage;
import sigmastate.basics.ProveDHTuple;
import sigmastate.basics.SecondDiffieHellmanTupleProverMessage;
import sigmastate.interpreter.CryptoConstants$;

public final class DiffieHellmanTupleInteractiveProver$ {
    public static DiffieHellmanTupleInteractiveProver$ MODULE$;

    static {
        new DiffieHellmanTupleInteractiveProver$();
    }

    public Tuple2<BigInteger, FirstDiffieHellmanTupleProverMessage> firstMessage(ProveDHTuple publicInput) {
        BigInteger qMinusOne = CryptoConstants$.MODULE$.dlogGroup().order().subtract(BigInteger.ONE);
        BigInteger r = BigIntegers.createRandomInRange((BigInteger)BigInteger.ZERO, (BigInteger)qMinusOne, (SecureRandom)CryptoConstants$.MODULE$.dlogGroup().secureRandom());
        SecP256K1Point a = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.g(), r);
        SecP256K1Point b = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.h(), r);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r), (Object)new FirstDiffieHellmanTupleProverMessage(a, b));
    }

    public SecondDiffieHellmanTupleProverMessage secondMessage(DiffieHellmanTupleProverInput privateInput, BigInteger rnd, byte[] challenge) {
        BigInteger q = CryptoConstants$.MODULE$.dlogGroup().order();
        BigInteger e = new BigInteger(1, challenge);
        BigInteger ew = e.multiply(privateInput.w()).mod(q);
        BigInteger z = rnd.add(ew).mod(q);
        return new SecondDiffieHellmanTupleProverMessage(z);
    }

    public Tuple2<FirstDiffieHellmanTupleProverMessage, SecondDiffieHellmanTupleProverMessage> simulate(ProveDHTuple publicInput, byte[] challenge) {
        BigInteger qMinusOne = CryptoConstants$.MODULE$.dlogGroup().order().subtract(BigInteger.ONE);
        BigInteger z = BigIntegers.createRandomInRange((BigInteger)BigInteger.ZERO, (BigInteger)qMinusOne, (SecureRandom)CryptoConstants$.MODULE$.dlogGroup().secureRandom());
        BigInteger e = new BigInteger(1, challenge);
        BigInteger minusE = CryptoConstants$.MODULE$.dlogGroup().order().subtract(e);
        SecP256K1Point hToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.h(), z);
        SecP256K1Point gToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.g(), z);
        SecP256K1Point uToMinusE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.u(), minusE);
        SecP256K1Point vToMinusE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.v(), minusE);
        SecP256K1Point a = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(gToZ, uToMinusE);
        SecP256K1Point b = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(hToZ, vToMinusE);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FirstDiffieHellmanTupleProverMessage(a, b)), (Object)new SecondDiffieHellmanTupleProverMessage(z));
    }

    public Tuple2<SecP256K1Point, SecP256K1Point> computeCommitment(ProveDHTuple proposition, byte[] challenge, SecondDiffieHellmanTupleProverMessage secondMessage) {
        SecP256K1Point g = proposition.g();
        SecP256K1Point h = proposition.h();
        SecP256K1Point u = proposition.u();
        SecP256K1Point v = proposition.v();
        BigInteger z = secondMessage.z();
        BigInteger e = new BigInteger(1, challenge);
        SecP256K1Point gToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(g, z);
        SecP256K1Point hToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(h, z);
        SecP256K1Point uToE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(u, e);
        SecP256K1Point vToE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(v, e);
        SecP256K1Point a = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(gToZ, CryptoConstants$.MODULE$.dlogGroup().inverseOf(uToE));
        SecP256K1Point b = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(hToZ, CryptoConstants$.MODULE$.dlogGroup().inverseOf(vToE));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a), (Object)b);
    }

    private DiffieHellmanTupleInteractiveProver$() {
        MODULE$ = this;
    }
}

