/*
 * Decompiled with CFR 0.152.
 */
package scalan.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scalan.util.CollectionUtil$;
import scalan.util.CollectionUtil$AnyOps$;
import scalan.util.StringUtil$;
import scalan.util.StringUtil$StringUtilExtensions$;

public final class FileUtil$ {
    public static FileUtil$ MODULE$;
    private final FilenameFilter AcceptAllFiles;
    private final FilenameFilter AcceptAllDirectories;

    static {
        new FileUtil$();
    }

    public void withFile(File file, Function1<PrintWriter, BoxedUnit> f) {
        if (file.isDirectory() && !file.delete()) {
            throw new RuntimeException(new StringBuilder(30).append("File ").append(file).append(" is a non-empty directory").toString());
        }
        file.getParentFile().mkdirs();
        try (PrintWriter stream = new PrintWriter(new FileOutputStream(file));){
            f.apply((Object)stream);
        }
    }

    public void write(File file, String text) {
        this.withFile(file, (Function1<PrintWriter, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$1 -> {
            x$1.print(text);
            return BoxedUnit.UNIT;
        });
    }

    public void withStdOutAndErr(PrintStream out, Function0<BoxedUnit> func) {
        PrintStream oldStdOut = System.out;
        PrintStream oldStdErr = System.err;
        try {
            System.setOut(out);
            System.setErr(out);
            Console$.MODULE$.withOut(out, (Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> Console$.MODULE$.withErr(out, func));
        }
        finally {
            out.flush();
            System.setOut(oldStdOut);
            System.setErr(oldStdErr);
        }
    }

    public String captureStdOutAndErr(Function0<BoxedUnit> func) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(out);){
            this.withStdOutAndErr(ps, func);
        }
        return out.toString();
    }

    public long classPathLastModified(String source, ClassLoader classLoader) {
        Enumeration<URL> urls = classLoader.getResources(source);
        if (!urls.hasMoreElements()) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Resource ").append(source).append(" not found on classpath").toString());
        }
        return BoxesRunTime.unboxToLong((Object)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(urls).asScala()).map((Function1 & java.io.Serializable & Serializable)url -> BoxesRunTime.boxToLong((long)this.urlLastModified$1(url))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public ClassLoader classPathLastModified$default$2() {
        return this.getClass().getClassLoader();
    }

    public File jarUrlToJarFile(URL url) {
        URL jarFileUrl = ((JarURLConnection)url.openConnection()).getJarFileURL();
        return this.urlToFile(jarFileUrl);
    }

    public void delete(File fileOrDirectory) {
        this.deleteRecursive(fileOrDirectory.toPath());
    }

    public void deleteIfExist(File fileOrDirectory) {
        block0: {
            if (!fileOrDirectory.exists()) break block0;
            this.delete(fileOrDirectory);
        }
    }

    public void deleteRecursive(Path path) {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public File currentWorkingDir() {
        return Paths.get("", new String[0]).toAbsolutePath().toFile();
    }

    public File file(String first, Seq<String> rest) {
        return this.file(new File(first), rest);
    }

    public File file(File first, Seq<String> rest) {
        return (File)rest.foldLeft((Object)first, (Function2 & java.io.Serializable & Serializable)(file, child) -> new File((File)file, (String)child));
    }

    public final FilenameFilter AcceptAllFiles() {
        return this.AcceptAllFiles;
    }

    public final FilenameFilter AcceptAllDirectories() {
        return this.AcceptAllDirectories;
    }

    public File[] listFiles(File dir, FilenameFilter filter) {
        File[] fileArray = dir.listFiles(filter);
        File[] fileArray2 = fileArray == null ? (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)) : fileArray;
        return fileArray2;
    }

    public FilenameFilter listFiles$default$2() {
        return this.AcceptAllFiles();
    }

    public File[] listDirectories(File dir) {
        return this.listFiles(dir, this.AcceptAllDirectories());
    }

    public File[] listDirectoriesRecursive(File dir) {
        return (File[])CollectionUtil$AnyOps$.MODULE$.traverseDepthFirst$extension(CollectionUtil$.MODULE$.AnyOps(dir), (Function1 & java.io.Serializable & Serializable)f -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.listDirectories((File)f))).toList()).toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public File[] listFilesRecursive(File dir) {
        File[] dirs = this.listDirectoriesRecursive(dir);
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dirs)).flatMap((Function1 & java.io.Serializable & Serializable)d -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listFiles(d, FileUtil$.MODULE$.listFiles$default$2()))).map((Function1 & java.io.Serializable & Serializable)f -> f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public String stripExtension(String fileName) {
        String string;
        int n = fileName.lastIndexOf(46);
        switch (n) {
            case -1: {
                string = fileName;
                break;
            }
            default: {
                string = fileName.substring(0, n);
                break;
            }
        }
        return string;
    }

    public String replaceOrAppendExtension(String fileName, String extension2) {
        return new StringBuilder(1).append(this.stripExtension(fileName)).append(".").append(extension2).toString();
    }

    public File modifyName(File file, Function1<String, String> f) {
        File parent = file.getParentFile();
        String name = file.getName();
        String newName = (String)f.apply((Object)name);
        return new File(parent, newName);
    }

    public File urlToFile(URL url) {
        return Paths.get(url.toURI()).toFile();
    }

    public String cleanFileName(String string) {
        return string.replaceAll("[ /\\\\:;<>|?*^]", "_").replaceAll("['\"]", "");
    }

    public boolean isBadFileName(String string) {
        String string2 = this.cleanFileName(string);
        String string3 = string;
        return string2 == null ? string3 != null : !string2.equals(string3);
    }

    public String extractModuleName(String path, String sourceDir) {
        String moduleDir = StringUtil$StringUtilExtensions$.MODULE$.prefixBefore$extension(StringUtil$.MODULE$.StringUtilExtensions(path), new StringBuilder(1).append("/").append(sourceDir).toString());
        if (moduleDir.length() == path.length()) {
            return "";
        }
        return StringUtil$StringUtilExtensions$.MODULE$.lastComponent$extension(StringUtil$.MODULE$.StringUtilExtensions(moduleDir), '/');
    }

    public String extractModuleName$default$2() {
        return "src/main/scala";
    }

    private final long urlLastModified$1(URL url) {
        long l;
        String string = url.getProtocol();
        if ("file".equals(string)) {
            long l2;
            File file = this.urlToFile(url);
            if (file.isDirectory()) {
                LongRef result = LongRef.create((long)file.lastModified());
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result){
                    private final LongRef result$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        this.result$1.elem = package$.MODULE$.max(this.result$1.elem, file.toFile().lastModified());
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        if (exc != null) {
                            throw exc;
                        }
                        this.result$1.elem = package$.MODULE$.max(this.result$1.elem, dir.toFile().lastModified());
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.result$1 = result$1;
                    }
                });
                l2 = result.elem;
            } else {
                l2 = file.lastModified();
            }
            l = l2;
        } else if ("jar".equals(string)) {
            l = this.jarUrlToJarFile(url).lastModified();
        } else {
            throw new MatchError((Object)string);
        }
        return l;
    }

    private FileUtil$() {
        MODULE$ = this;
        this.AcceptAllFiles = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !FileUtil$.MODULE$.file(dir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name})).isDirectory();
            }
        };
        this.AcceptAllDirectories = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return FileUtil$.MODULE$.file(dir, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name})).isDirectory();
            }
        };
    }
}

