/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.basics;

import java.math.BigInteger;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import sigmastate.basics.DiffieHellmanTupleProverInput;
import sigmastate.basics.FirstDiffieHellmanTupleProverMessage;
import sigmastate.basics.ProveDHTuple;
import sigmastate.basics.SecondDiffieHellmanTupleProverMessage;
import sigmastate.crypto.BigIntegers$;
import sigmastate.crypto.Platform;
import sigmastate.interpreter.CryptoConstants$;

public final class DiffieHellmanTupleInteractiveProver$ {
    public static DiffieHellmanTupleInteractiveProver$ MODULE$;

    static {
        new DiffieHellmanTupleInteractiveProver$();
    }

    public Tuple2<BigInteger, FirstDiffieHellmanTupleProverMessage> firstMessage(ProveDHTuple publicInput) {
        BigInteger qMinusOne = CryptoConstants$.MODULE$.dlogGroup().order().subtract(BigInteger.ONE);
        BigInteger r = BigIntegers$.MODULE$.createRandomInRange(BigInteger.ZERO, qMinusOne, CryptoConstants$.MODULE$.dlogGroup().secureRandom());
        Platform.Ecp a = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.g(), r);
        Platform.Ecp b = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.h(), r);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r), (Object)new FirstDiffieHellmanTupleProverMessage(a, b));
    }

    public SecondDiffieHellmanTupleProverMessage secondMessage(DiffieHellmanTupleProverInput privateInput, BigInteger rnd, byte[] challenge) {
        BigInteger q = CryptoConstants$.MODULE$.dlogGroup().order();
        BigInteger e = new BigInteger(1, challenge);
        BigInteger ew = e.multiply(privateInput.w()).mod(q);
        BigInteger z = rnd.add(ew).mod(q);
        return new SecondDiffieHellmanTupleProverMessage(z);
    }

    public Tuple2<FirstDiffieHellmanTupleProverMessage, SecondDiffieHellmanTupleProverMessage> simulate(ProveDHTuple publicInput, byte[] challenge) {
        BigInteger qMinusOne = CryptoConstants$.MODULE$.dlogGroup().order().subtract(BigInteger.ONE);
        BigInteger z = BigIntegers$.MODULE$.createRandomInRange(BigInteger.ZERO, qMinusOne, CryptoConstants$.MODULE$.dlogGroup().secureRandom());
        BigInteger e = new BigInteger(1, challenge);
        BigInteger minusE = CryptoConstants$.MODULE$.dlogGroup().order().subtract(e);
        Platform.Ecp hToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.h(), z);
        Platform.Ecp gToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.g(), z);
        Platform.Ecp uToMinusE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.u(), minusE);
        Platform.Ecp vToMinusE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(publicInput.v(), minusE);
        Platform.Ecp a = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(gToZ, uToMinusE);
        Platform.Ecp b = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(hToZ, vToMinusE);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FirstDiffieHellmanTupleProverMessage(a, b)), (Object)new SecondDiffieHellmanTupleProverMessage(z));
    }

    public Tuple2<Platform.Ecp, Platform.Ecp> computeCommitment(ProveDHTuple proposition, byte[] challenge, SecondDiffieHellmanTupleProverMessage secondMessage) {
        Platform.Ecp g = proposition.g();
        Platform.Ecp h = proposition.h();
        Platform.Ecp u = proposition.u();
        Platform.Ecp v = proposition.v();
        BigInteger z = secondMessage.z();
        BigInteger e = new BigInteger(1, challenge);
        Platform.Ecp gToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(g, z);
        Platform.Ecp hToZ = CryptoConstants$.MODULE$.dlogGroup().exponentiate(h, z);
        Platform.Ecp uToE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(u, e);
        Platform.Ecp vToE = CryptoConstants$.MODULE$.dlogGroup().exponentiate(v, e);
        Platform.Ecp a = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(gToZ, CryptoConstants$.MODULE$.dlogGroup().inverseOf(uToE));
        Platform.Ecp b = CryptoConstants$.MODULE$.dlogGroup().multiplyGroupElements(hToZ, CryptoConstants$.MODULE$.dlogGroup().inverseOf(vToE));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)a), (Object)b);
    }

    private DiffieHellmanTupleInteractiveProver$() {
        MODULE$ = this;
    }
}

