/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.crypto;

import java.math.BigInteger;
import java.security.SecureRandom;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class BigIntegers$ {
    public static BigIntegers$ MODULE$;
    private final BigInteger ZERO;
    private final int MAX_ITERATIONS;

    static {
        new BigIntegers$();
    }

    public BigInteger ZERO() {
        return this.ZERO;
    }

    private int MAX_ITERATIONS() {
        return this.MAX_ITERATIONS;
    }

    public byte[] createRandom(int bitLength, SecureRandom random) throws IllegalArgumentException {
        if (bitLength < 1) {
            throw new IllegalArgumentException("bitLength must be at least 1");
        }
        int nBytes = (bitLength + 7) / 8;
        byte[] rv = new byte[nBytes];
        random.nextBytes(rv);
        int xBits = 8 * nBytes - bitLength;
        rv[0] = (byte)(rv[0] & 255 >>> xBits);
        return rv;
    }

    public BigInteger createRandomBigInteger(int bitLength, SecureRandom random) {
        return new BigInteger(1, this.createRandom(bitLength, random));
    }

    public BigInteger createRandomInRange(BigInteger min, BigInteger max, SecureRandom random) {
        BigInteger bigInteger;
        Object object = new Object();
        try {
            int cmp = min.compareTo(max);
            if (cmp >= 0) {
                if (cmp > 0) {
                    throw new IllegalArgumentException("'min' may not be greater than 'max'");
                }
                return min;
            }
            if (min.bitLength() > max.bitLength() / 2) {
                return this.createRandomInRange(this.ZERO(), max.subtract(min), random).add(min);
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_ITERATIONS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
                BigInteger x = MODULE$.createRandomBigInteger(max.bitLength(), random);
                if (x.compareTo(min) >= 0 && x.compareTo(max) <= 0) {
                    throw new NonLocalReturnControl(object, (Object)x);
                }
            });
            bigInteger = this.createRandomBigInteger(max.subtract(min).bitLength() - 1, random).add(min);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bigInteger = (BigInteger)ex.value();
            }
            throw ex;
        }
        return bigInteger;
    }

    public byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    private BigIntegers$() {
        MODULE$ = this;
        this.ZERO = BigInteger.valueOf(0L);
        this.MAX_ITERATIONS = 1000;
    }
}

