/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.ergoplatform.ErgoBox$sigmaSerializer$;
import org.ergoplatform.validation.ValidationRules$CheckSerializableTypeCode$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IndexedSeq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scalan.RType$;
import sigmastate.AvlTreeData$serializer$;
import sigmastate.SAvlTree$;
import sigmastate.SBigInt$;
import sigmastate.SBoolean$;
import sigmastate.SBox$;
import sigmastate.SByte$;
import sigmastate.SCollectionType;
import sigmastate.SGroupElement$;
import sigmastate.SInt$;
import sigmastate.SLong$;
import sigmastate.SShort$;
import sigmastate.SSigmaProp$;
import sigmastate.SString$;
import sigmastate.STuple;
import sigmastate.SType;
import sigmastate.SUnit$;
import sigmastate.Values$SigmaBoolean$serializer$;
import sigmastate.eval.Evaluation$;
import sigmastate.lang.exceptions.SerializerException;
import sigmastate.lang.exceptions.SerializerException$;
import sigmastate.serialization.GroupElementSerializer$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;
import special.collection.Coll;
import special.collection.package$;
import special.sigma.AvlTree;
import special.sigma.BigInt;
import special.sigma.Box;
import special.sigma.GroupElement;
import special.sigma.SigmaProp;

public final class DataSerializer$ {
    public static DataSerializer$ MODULE$;

    static {
        new DataSerializer$();
    }

    public <T extends SType> void serialize(Object v, T tpe, SigmaByteWriter w) {
        T t = tpe;
        if (SUnit$.MODULE$.equals(t)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SBoolean$.MODULE$.equals(t)) {
            w.putBoolean(BoxesRunTime.unboxToBoolean((Object)v));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SByte$.MODULE$.equals(t)) {
            w.put(BoxesRunTime.unboxToByte((Object)v));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SShort$.MODULE$.equals(t)) {
            w.putShort(BoxesRunTime.unboxToShort((Object)v));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SInt$.MODULE$.equals(t)) {
            w.putInt(BoxesRunTime.unboxToInt((Object)v));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SLong$.MODULE$.equals(t)) {
            w.putLong(BoxesRunTime.unboxToLong((Object)v));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SString$.MODULE$.equals(t)) {
            byte[] bytes = ((String)v).getBytes(StandardCharsets.UTF_8);
            w.putUInt(bytes.length);
            w.putBytes(bytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SBigInt$.MODULE$.equals(t)) {
            byte[] data = sigmastate.eval.package$.MODULE$.SigmaDsl().toBigInteger((BigInt)v).toByteArray();
            w.putUShort(data.length);
            w.putBytes(data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SGroupElement$.MODULE$.equals(t)) {
            GroupElementSerializer$.MODULE$.serialize(sigmastate.eval.package$.MODULE$.groupElementToECPoint((GroupElement)v), w);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SSigmaProp$.MODULE$.equals(t)) {
            SigmaProp p = (SigmaProp)v;
            Values$SigmaBoolean$serializer$.MODULE$.serialize(sigmastate.eval.package$.MODULE$.sigmaPropToSigmaBoolean(p), w);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SBox$.MODULE$.equals(t)) {
            Box b = (Box)v;
            ErgoBox$sigmaSerializer$.MODULE$.serialize(sigmastate.eval.package$.MODULE$.boxToErgoBox(b), w);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (SAvlTree$.MODULE$.equals(t)) {
            AvlTreeData$serializer$.MODULE$.serialize(sigmastate.eval.package$.MODULE$.avlTreeToAvlTreeData((AvlTree)v), w);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (t instanceof SCollectionType) {
            SCollectionType sCollectionType = (SCollectionType)t;
            Coll coll = (Coll)v;
            w.putUShort(coll.length());
            Object t2 = sCollectionType.elemType();
            if (SBoolean$.MODULE$.equals(t2)) {
                w.putBits(coll.toArray$mcZ$sp());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (SByte$.MODULE$.equals(t2)) {
                w.putBytes(coll.toArray$mcB$sp());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Object arr = coll.toArray();
                for (int index$macro$1 = 0; index$macro$1 < ScalaRunTime$.MODULE$.array_length(arr); ++index$macro$1) {
                    Object x = ScalaRunTime$.MODULE$.array_apply(arr, index$macro$1);
                    this.serialize(x, sCollectionType.elemType(), w);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (t instanceof STuple) {
            STuple sTuple = (STuple)t;
            Coll<Object> arr = Evaluation$.MODULE$.fromDslTuple(v, sTuple);
            int len = arr.length();
            Predef$.MODULE$.assert(arr.length() == sTuple.items().length(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Type ").append(sTuple).append(" doesn't correspond to value ").append(arr).toString());
            if (len > 65535) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder(32).append("Length of tuple ").append(arr.length()).append(" exceeds ").append(65535).append(" limit.").toString());
            }
            for (int i = 0; i < arr.length(); ++i) {
                this.serialize(arr.apply(i), (SType)sTuple.items().apply(i), w);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ValidationRules$CheckSerializableTypeCode$.MODULE$.apply(tpe.typeCode());
            throw new SerializerException(new StringBuilder(32).append("Don't know how to serialize (").append(v).append(", ").append(tpe).append(")").toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public <T extends SType> Object deserialize(T tpe, SigmaByteReader r) {
        Object object;
        int depth = r.level();
        r.level_$eq(depth + 1);
        T t2 = tpe;
        if (SUnit$.MODULE$.equals(t2)) {
            object = BoxedUnit.UNIT;
        } else if (SBoolean$.MODULE$.equals(t2)) {
            object = BoxesRunTime.boxToBoolean((r.getUByte() != 0 ? 1 : 0) != 0);
        } else if (SByte$.MODULE$.equals(t2)) {
            object = BoxesRunTime.boxToByte((byte)r.getByte());
        } else if (SShort$.MODULE$.equals(t2)) {
            object = BoxesRunTime.boxToShort((short)r.getShort());
        } else if (SInt$.MODULE$.equals(t2)) {
            object = BoxesRunTime.boxToInteger((int)r.getInt());
        } else if (SLong$.MODULE$.equals(t2)) {
            object = BoxesRunTime.boxToLong((long)r.getLong());
        } else if (SString$.MODULE$.equals(t2)) {
            int size = r.getUIntExact();
            byte[] bytes = r.getBytes(size);
            object = new String(bytes, StandardCharsets.UTF_8);
        } else if (SBigInt$.MODULE$.equals(t2)) {
            short size = (short)r.getUShort();
            if ((long)size > SBigInt$.MODULE$.MaxSizeInBytes()) {
                throw new SerializerException(new StringBuilder(42).append("BigInt value doesn't not fit into ").append(SBigInt$.MODULE$.MaxSizeInBytes()).append(" bytes: ").append(size).toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
            byte[] valueBytes = r.getBytes(size);
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().BigInt(new BigInteger(valueBytes));
        } else if (SGroupElement$.MODULE$.equals(t2)) {
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().GroupElement(GroupElementSerializer$.MODULE$.parse(r));
        } else if (SSigmaProp$.MODULE$.equals(t2)) {
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().SigmaProp(Values$SigmaBoolean$serializer$.MODULE$.parse(r));
        } else if (SBox$.MODULE$.equals(t2)) {
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().Box(ErgoBox$sigmaSerializer$.MODULE$.parse(r));
        } else if (SAvlTree$.MODULE$.equals(t2)) {
            object = sigmastate.eval.package$.MODULE$.SigmaDsl().avlTree(AvlTreeData$serializer$.MODULE$.parse(r));
        } else if (t2 instanceof SCollectionType) {
            SCollectionType sCollectionType = (SCollectionType)t2;
            int len = r.getUShort();
            object = this.deserializeColl(len, sCollectionType.elemType(), r);
        } else if (t2 instanceof STuple) {
            STuple sTuple = (STuple)t2;
            Object[] arr = (Object[])((TraversableOnce)sTuple.items().map((Function1 & Serializable & scala.Serializable)t -> MODULE$.deserialize(t, r), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            Coll<Object> coll = sigmastate.eval.package$.MODULE$.Colls().fromArray(arr, RType$.MODULE$.AnyType());
            object = Evaluation$.MODULE$.toDslTuple(coll, sTuple);
        } else {
            ValidationRules$CheckSerializableTypeCode$.MODULE$.apply(t2.typeCode());
            throw new SerializerException(new StringBuilder(36).append("Not defined DataSerializer for type ").append(t2).toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
        }
        BoxedUnit res = object;
        r.level_$eq(r.level() - 1);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public <T extends SType> Coll<Object> deserializeColl(int len, T tpeElem, SigmaByteReader r) {
        block3: {
            block4: {
                block2: {
                    var6_4 = tpeElem;
                    if (!SBoolean$.MODULE$.equals(var6_4)) break block2;
                    var4_5 = sigmastate.eval.package$.MODULE$.Colls().fromArray$mZc$sp(r.getBits(len), RType$.MODULE$.BooleanType());
                    break block3;
                }
                if (!SByte$.MODULE$.equals(var6_4)) break block4;
                var4_5 = sigmastate.eval.package$.MODULE$.Colls().fromArray$mBc$sp(r.getBytes(len), RType$.MODULE$.ByteType());
                break block3;
            }
            var8_6 = false;
            var9_7 = null;
            var10_8 = tpeElem;
            if (!(var10_8 instanceof STuple)) ** GOTO lbl-1000
            var8_6 = true;
            var9_7 = (STuple)var10_8;
            if (var9_7.items().length() == 2) {
                var5_9 = Evaluation$.MODULE$.stypeToRType(tpeElem);
            } else lbl-1000:
            // 2 sources

            {
                var5_9 = var8_6 != false ? package$.MODULE$.collRType(RType$.MODULE$.AnyType()) : Evaluation$.MODULE$.stypeToRType(tpeElem);
            }
            tItem = var5_9;
            ct = tItem.classTag();
            b = ArrayBuilder$.MODULE$.make(ct);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$deserializeColl$1$adapted(scala.collection.mutable.ArrayBuilder sigmastate.SType sigmastate.utils.SigmaByteReader java.lang.Object ), (Ljava/lang/Object;)Lscala/collection/mutable/ArrayBuilder;)((ArrayBuilder)b, tpeElem, (SigmaByteReader)r));
            var4_5 = sigmastate.eval.package$.MODULE$.Colls().fromArray(b.result(), tItem);
        }
        return var4_5;
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$deserializeColl$1(ArrayBuilder b$1, SType tpeElem$1, SigmaByteReader r$2, int _) {
        return (ArrayBuilder)b$1.$plus$eq(MODULE$.deserialize(tpeElem$1, r$2));
    }

    private DataSerializer$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$deserializeColl$1$adapted(ArrayBuilder b$1, SType tpeElem$1, SigmaByteReader r$2, Object _) {
        return DataSerializer$.$anonfun$deserializeColl$1(b$1, tpeElem$1, r$2, BoxesRunTime.unboxToInt((Object)_));
    }
}

