/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import java.io.Serializable;
import java.util.Arrays;
import org.ergoplatform.validation.SigmaValidationSettings;
import org.ergoplatform.validation.ValidationException;
import org.ergoplatform.validation.ValidationRules$CheckDeserializedScriptIsSigmaProp$;
import org.ergoplatform.validation.ValidationRules$CheckHeaderSizeBit$;
import org.ergoplatform.validation.ValidationRules$CheckPositionLimit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import sigmastate.SSigmaProp$;
import sigmastate.SType;
import sigmastate.Values;
import sigmastate.Values$Constant$;
import sigmastate.Values$ErgoTree$;
import sigmastate.VersionContext$;
import sigmastate.lang.DeserializationSigmaBuilder$;
import sigmastate.lang.SourceContext;
import sigmastate.lang.Terms$;
import sigmastate.lang.Terms$ValueOps$;
import sigmastate.lang.exceptions.ReaderPositionLimitExceeded;
import sigmastate.lang.exceptions.SerializerException;
import sigmastate.serialization.ConstantSerializer;
import sigmastate.serialization.ConstantStore;
import sigmastate.serialization.ConstantStore$;
import sigmastate.serialization.ErgoTreeSerializer$;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.serialization.ValueSerializer$;
import sigmastate.util$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;
import sigmastate.utxo.ComplexityTable$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\n\u0019BQ\u0001\u0011\u0001\u0005\n\u0005CQ!\u0013\u0001\u0005\u0002)CQ\u0001\u0014\u0001\u0005\u00025CQ\u0001\u0014\u0001\u0005\u0002ACa\u0001\u0014\u0001\u0005\u0002]Y\u0006\"B2\u0001\t\u0013!\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007c\u0002\u0001\u000b\u0011\u00028\t\u000bI\u0004A\u0011B:\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!A\u00111\u0004\u0001\u0005\u0002]\ti\u0002C\u0004\u0002*\u0001!\t!a\u000b\b\u000f\u0005US\u0003#\u0001\u0002X\u00191A#\u0006E\u0001\u00033Ba!\t\t\u0005\u0002\u0005m\u0003\"CA/!\t\u0007I\u0011AA0\u0011\u001d\t\t\u0007\u0005Q\u0001\n\r\u0012!#\u0012:h_R\u0013X-Z*fe&\fG.\u001b>fe*\u0011acF\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0003a\t!b]5h[\u0006\u001cH/\u0019;f\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ#A\btKJL\u0017\r\\5{K\"+\u0017\rZ3s)\r9#\u0006\u000f\t\u00039!J!!K\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006W\t\u0001\r\u0001L\u0001\tKJ<w\u000e\u0016:fKB\u0011Q&\u000e\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!M\r\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012B\u0001\u001b\u0018\u0003\u00191\u0016\r\\;fg&\u0011ag\u000e\u0002\t\u000bJ<w\u000e\u0016:fK*\u0011Ag\u0006\u0005\u0006s\t\u0001\rAO\u0001\u0002oB\u00111HP\u0007\u0002y)\u0011QhF\u0001\u0006kRLGn]\u0005\u0003\u007fq\u0012qbU5h[\u0006\u0014\u0015\u0010^3Xe&$XM]\u0001\u0015g\u0016\u0014\u0018.\u00197ju\u0016<\u0016\u000e\u001e5pkR\u001c\u0016N_3\u0015\u0005\tC\u0005c\u0001\u000fD\u000b&\u0011A)\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039\u0019K!aR\u000f\u0003\t\tKH/\u001a\u0005\u0006W\r\u0001\r\u0001L\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016,%oZ8Ue\u0016,GC\u0001\"L\u0011\u0015YC\u00011\u0001-\u0003M!Wm]3sS\u0006d\u0017N_3Fe\u001e|GK]3f)\tac\nC\u0003P\u000b\u0001\u0007!)A\u0003csR,7\u000fF\u0002-#ZCQA\u0015\u0004A\u0002M\u000b\u0011A\u001d\t\u0003wQK!!\u0016\u001f\u0003\u001fMKw-\\1CsR,'+Z1eKJDQa\u0016\u0004A\u0002a\u000b\u0001#\\1y)J,WmU5{K\nKH/Z:\u0011\u0005qI\u0016B\u0001.\u001e\u0005\rIe\u000e\u001e\u000b\u0005Yqkf\fC\u0003S\u000f\u0001\u00071\u000bC\u0003X\u000f\u0001\u0007\u0001\fC\u0003`\u000f\u0001\u0007\u0001-A\u0005dQ\u0016\u001c7\u000eV=qKB\u0011A$Y\u0005\u0003Ev\u0011qAQ8pY\u0016\fg.\u0001\reKN,'/[1mSj,\u0007*Z1eKJ\fe\u000eZ*ju\u0016$\"!Z6\u0011\tq1W\t[\u0005\u0003Ov\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\u000fj1&\u0011!.\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bIC\u0001\u0019A*\u0002%\r|gn\u001d;b]R\u001cVM]5bY&TXM]\u000b\u0002]B\u0011Ae\\\u0005\u0003aV\u0011!cQ8ogR\fg\u000e^*fe&\fG.\u001b>fe\u0006\u00192m\u001c8ti\u0006tGoU3sS\u0006d\u0017N_3sA\u0005!B-Z:fe&\fG.\u001b>f\u0007>t7\u000f^1oiN$R\u0001^A\u0005\u0003\u001b\u00012!\u001e>~\u001d\t1\bP\u0004\u00020o&\ta$\u0003\u0002z;\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0006\u0003sv\u0001B!\f@\u0002\u0002%\u0011qp\u000e\u0002\t\u0007>t7\u000f^1oiB!\u00111AA\u0003\u001b\u00059\u0012bAA\u0004/\t)1\u000bV=qK\"1\u00111B\u0006A\u0002\u0015\u000ba\u0001[3bI\u0016\u0014\b\"\u0002*\f\u0001\u0004\u0019\u0016A\b3fg\u0016\u0014\u0018.\u00197ju\u0016DU-\u00193fe^KG\u000f\u001b+sK\u0016\u0014\u0015\u0010^3t)\u0011\t\u0019\"!\u0007\u0011\u000fq\t)\"\u00125u\u0005&\u0019\u0011qC\u000f\u0003\rQ+\b\u000f\\35\u0011\u0015\u0011F\u00021\u0001T\u0003M9W\r\u001e)pg&$\u0018n\u001c8t\u0005\u0006\u001c7N]3g)\u0019\ty\"!\t\u0002&A\u0019Ad\u0011-\t\u000f\u0005\rR\u00021\u0001\u0002 \u0005I\u0001o\\:ji&|gn\u001d\u0005\u0007\u0003Oi\u0001\u0019\u0001-\u0002\u001dA|7/\u001b;j_:\u001c(+\u00198hK\u0006\u00192/\u001e2ti&$X\u000f^3D_:\u001cH/\u00198ugRA\u0011QFA%\u0003\u001b\ny\u0005\u0006\u0003\u00020\u0005E\u0002\u0003\u0002\u000fg\u0005bCq!a\r\u000f\u0001\b\t)$\u0001\u0002wgB!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012A\u0003<bY&$\u0017\r^5p]*!\u0011qHA!\u00031)'oZ8qY\u0006$hm\u001c:n\u0015\t\t\u0019%A\u0002pe\u001eLA!a\u0012\u0002:\t92+[4nCZ\u000bG.\u001b3bi&|gnU3ui&twm\u001d\u0005\u0007\u0003\u0017r\u0001\u0019\u0001\"\u0002\u0017M\u001c'/\u001b9u\u0005f$Xm\u001d\u0005\b\u0003Gq\u0001\u0019AA\u0010\u0011\u001d\t\tF\u0004a\u0001\u0003'\nqA\\3x-\u0006d7\u000fE\u0002\u001d\u0007v\f!#\u0012:h_R\u0013X-Z*fe&\fG.\u001b>feB\u0011A\u0005E\n\u0003!m!\"!a\u0016\u0002#\u0011+g-Y;miN+'/[1mSj,'/F\u0001$\u0003I!UMZ1vYR\u001cVM]5bY&TXM\u001d\u0011")
public class ErgoTreeSerializer {
    private final ConstantSerializer constantSerializer = new ConstantSerializer(DeserializationSigmaBuilder$.MODULE$);

    public static ErgoTreeSerializer DefaultSerializer() {
        return ErgoTreeSerializer$.MODULE$.DefaultSerializer();
    }

    private void serializeHeader(Values.ErgoTree ergoTree, SigmaByteWriter w) {
        w.put(ergoTree.header());
        if (ergoTree.isConstantSegregation()) {
            ConstantSerializer constantSerializer = new ConstantSerializer(DeserializationSigmaBuilder$.MODULE$);
            IndexedSeq<Values.Constant<SType>> constants = ergoTree.constants();
            int nConstants = constants.length();
            w.putUInt(nConstants);
            for (int index$macro$1 = 0; index$macro$1 < nConstants; ++index$macro$1) {
                Values.Constant c = (Values.Constant)constants.apply(index$macro$1);
                constantSerializer.serialize(c, w);
            }
        }
    }

    private byte[] serializeWithoutSize(Values.ErgoTree ergoTree) {
        SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
        this.serializeHeader(ergoTree, w);
        Predef$.MODULE$.assert(ergoTree.isRightParsed(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Right parsed ErgoTree expected: ").append(ergoTree).toString());
        ValueSerializer$.MODULE$.serialize((Values.Value)ergoTree.root().right().get(), w);
        return w.toBytes();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] serializeErgoTree(Values.ErgoTree ergoTree) {
        void var3_11;
        byte[] byArray;
        Left left;
        Values.UnparsedErgoTree unparsedErgoTree;
        Either<Values.UnparsedErgoTree, Values.Value<SSigmaProp$>> either = ergoTree.root();
        if (either instanceof Left && (unparsedErgoTree = (Values.UnparsedErgoTree)(left = (Left)either).value()) != null) {
            WrappedArray<Object> bytes = unparsedErgoTree.bytes();
            byArray = (byte[])bytes.array();
        } else {
            byte[] byArray2;
            byte[] bytes = this.serializeWithoutSize(ergoTree);
            if (ergoTree.hasSize()) {
                SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
                byte header = bytes[0];
                int contentLength = bytes.length - 1;
                w.put(header);
                w.putUInt(contentLength);
                w.putBytes(bytes, 1, contentLength);
                byArray2 = w.toBytes();
            } else {
                byArray2 = bytes;
            }
            byArray = byArray2;
        }
        byte[] res = byArray;
        return var3_11;
    }

    public Values.ErgoTree deserializeErgoTree(byte[] bytes) {
        SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(bytes, SigmaSerializer$.MODULE$.startReader$default$2());
        return this.deserializeErgoTree(r, SigmaSerializer$.MODULE$.MaxPropositionSize());
    }

    public Values.ErgoTree deserializeErgoTree(SigmaByteReader r, int maxTreeSizeBytes) {
        return this.deserializeErgoTree(r, maxTreeSizeBytes, true);
    }

    public Values.ErgoTree deserializeErgoTree(SigmaByteReader r, int maxTreeSizeBytes, boolean checkType) {
        Values.ErgoTree ergoTree;
        int startPos = r.position();
        int previousPositionLimit = r.positionLimit();
        int previousComplexity = r.complexity();
        r.positionLimit_$eq(r.position() + maxTreeSizeBytes);
        r.complexity_$eq(0);
        Tuple2<Object, Option<Object>> tuple2 = this.deserializeHeaderAndSize(r);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte h = BoxesRunTime.unboxToByte((Object)tuple2._1());
        Option sizeOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)h), (Object)sizeOpt);
        Tuple2 tuple23 = tuple22;
        byte h2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
        Option sizeOpt2 = (Option)tuple23._2();
        int bodyPos = r.position();
        try {
            try {
                try {
                    IndexedSeq<Values.Constant<SType>> cs = this.deserializeConstants(h2, r);
                    ConstantStore previousConstantStore = r.constantStore();
                    r.constantStore_$eq(new ConstantStore(cs));
                    boolean wasDeserialize_saved = r.wasDeserialize();
                    r.wasDeserialize_$eq(false);
                    Object root = ValueSerializer$.MODULE$.deserialize(r);
                    boolean hasDeserialize = r.wasDeserialize();
                    r.wasDeserialize_$eq(wasDeserialize_saved);
                    if (checkType) {
                        ValidationRules$CheckDeserializedScriptIsSigmaProp$.MODULE$.apply((Values.Value<SType>)root);
                    }
                    r.constantStore_$eq(previousConstantStore);
                    int complexity = r.complexity();
                    int treeSize = r.position() - startPos;
                    r.position_$eq(startPos);
                    byte[] propositionBytes = r.getBytes(treeSize);
                    ergoTree = new Values.ErgoTree(h2, cs, (Either<Values.UnparsedErgoTree, Values.Value<SSigmaProp$>>)package$.MODULE$.Right().apply(Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps((Values.Value<SType>)root))), complexity, propositionBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)hasDeserialize)));
                }
                catch (ReaderPositionLimitExceeded e) {
                    throw ValidationRules$CheckPositionLimit$.MODULE$.throwValidationException(e);
                }
            }
            catch (ValidationException ve) {
                Option option = sizeOpt2;
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new SerializerException("Cannot handle ValidationException, ErgoTree serialized without size bit.", (Option<SourceContext>)None$.MODULE$, (Option<Throwable>)new Some((Object)ve));
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                int treeSize = BoxesRunTime.unboxToInt((Object)some.value());
                int numBytes = bodyPos - startPos + treeSize;
                r.position_$eq(startPos);
                byte[] bytes = r.getBytes(numBytes);
                int complexity = BoxesRunTime.unboxToInt((Object)ComplexityTable$.MODULE$.OpCodeComplexity().apply((Object)BoxesRunTime.boxToByte((byte)Values$Constant$.MODULE$.opCode())));
                Values.ErgoTree ergoTree2 = new Values.ErgoTree(Values$ErgoTree$.MODULE$.DefaultHeader(), Values$ErgoTree$.MODULE$.EmptyConstants(), (Either<Values.UnparsedErgoTree, Values.Value<SSigmaProp$>>)package$.MODULE$.Left().apply((Object)new Values.UnparsedErgoTree((WrappedArray<Object>)Predef$.MODULE$.wrapByteArray(bytes), ve)), complexity, bytes, (Option<Object>)None$.MODULE$);
                ergoTree = ergoTree2;
            }
        }
        finally {
            r.positionLimit_$eq(previousPositionLimit);
            r.complexity_$eq(previousComplexity);
        }
        Values.ErgoTree tree = ergoTree;
        return tree;
    }

    private Tuple2<Object, Option<Object>> deserializeHeaderAndSize(SigmaByteReader r) {
        None$ none$;
        byte header = r.getByte();
        ValidationRules$CheckHeaderSizeBit$.MODULE$.apply(header);
        if (Values$ErgoTree$.MODULE$.hasSize(header)) {
            int size = (int)r.getUInt();
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)size));
        } else {
            none$ = None$.MODULE$;
        }
        None$ sizeOpt = none$;
        return new Tuple2((Object)BoxesRunTime.boxToByte((byte)header), (Object)sizeOpt);
    }

    private ConstantSerializer constantSerializer() {
        return this.constantSerializer;
    }

    /*
     * WARNING - void declaration
     */
    private IndexedSeq<Values.Constant<SType>> deserializeConstants(byte header, SigmaByteReader r) {
        void var3_6;
        WrappedArray wrappedArray;
        if (Values$ErgoTree$.MODULE$.isConstantSegregation(header)) {
            int nConsts = (int)r.getUInt();
            if (nConsts > 0) {
                Values.Constant[] res = (Values.Constant[])util$.MODULE$.safeNewArray(nConsts, ClassTag$.MODULE$.apply(Values.Constant.class));
                for (int index$macro$1 = 0; index$macro$1 < nConsts; ++index$macro$1) {
                    res[index$macro$1] = this.constantSerializer().deserialize(r);
                }
                wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])res);
            } else {
                wrappedArray = Values$Constant$.MODULE$.EmptySeq();
            }
        } else {
            wrappedArray = Values$Constant$.MODULE$.EmptySeq();
        }
        WrappedArray constants = wrappedArray;
        return var3_6;
    }

    public Tuple4<Object, Option<Object>, IndexedSeq<Values.Constant<SType>>, byte[]> deserializeHeaderWithTreeBytes(SigmaByteReader r) {
        Tuple2<Object, Option<Object>> tuple2 = this.deserializeHeaderAndSize(r);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte header = BoxesRunTime.unboxToByte((Object)tuple2._1());
        Option sizeOpt = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToByte((byte)header), (Object)sizeOpt);
        Tuple2 tuple23 = tuple22;
        byte header2 = BoxesRunTime.unboxToByte((Object)tuple23._1());
        Option sizeOpt2 = (Option)tuple23._2();
        IndexedSeq<Values.Constant<SType>> constants = this.deserializeConstants(header2, r);
        byte[] treeBytes = r.getBytes(r.remaining());
        return new Tuple4((Object)BoxesRunTime.boxToByte((byte)header2), (Object)sizeOpt2, constants, (Object)treeBytes);
    }

    /*
     * WARNING - void declaration
     */
    public int[] getPositionsBackref(int[] positions, int positionsRange) {
        void var3_3;
        int[] positionsBackref = (int[])util$.MODULE$.safeNewArray(positionsRange, ClassTag$.MODULE$.Int());
        Arrays.fill(positionsBackref, -1);
        for (int index$macro$1 = 0; index$macro$1 < positions.length; ++index$macro$1) {
            int pos = positions[index$macro$1];
            if (0 > pos || pos >= positionsBackref.length || positionsBackref[pos] != -1) continue;
            positionsBackref[pos] = index$macro$1;
        }
        return var3_3;
    }

    public Tuple2<byte[], Object> substituteConstants(byte[] scriptBytes, int[] positions, Values.Constant<SType>[] newVals, SigmaValidationSettings vs) {
        Predef$.MODULE$.require(positions.length == newVals.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("expected positions and newVals to have the same length, got: positions: ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions)).toSeq()).append(",\n newVals: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newVals)).toSeq()).toString());
        SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(scriptBytes, SigmaSerializer$.MODULE$.startReader$default$2());
        Tuple4<Object, Option<Object>, IndexedSeq<Values.Constant<SType>>, byte[]> tuple4 = this.deserializeHeaderWithTreeBytes(r);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        byte header = BoxesRunTime.unboxToByte((Object)tuple4._1());
        IndexedSeq constants = (IndexedSeq)tuple4._3();
        byte[] treeBytes = (byte[])tuple4._4();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToByte((byte)header), (Object)constants, (Object)treeBytes);
        Tuple3 tuple32 = tuple3;
        byte header2 = BoxesRunTime.unboxToByte((Object)tuple32._1());
        IndexedSeq constants2 = (IndexedSeq)tuple32._2();
        byte[] treeBytes2 = (byte[])tuple32._3();
        SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
        w.put(header2);
        if (VersionContext$.MODULE$.current().isJitActivated()) {
            Object object = Values$ErgoTree$.MODULE$.isConstantSegregation(header2) ? w.putUInt(constants2.length()) : BoxedUnit.UNIT;
            int nConstants = constants2.length();
            if (nConstants > 0) {
                int[] backrefs = this.getPositionsBackref(positions, nConstants);
                for (int index$macro$1 = 0; index$macro$1 < nConstants; ++index$macro$1) {
                    Values.Constant c = (Values.Constant)constants2.apply(index$macro$1);
                    int iPos = backrefs[index$macro$1];
                    if (iPos == -1) {
                        this.constantSerializer().serialize(c, w);
                        continue;
                    }
                    Predef$.MODULE$.assert(positions[iPos] == index$macro$1);
                    Values.Constant<SType> newConst = newVals[iPos];
                    Object s = c.tpe();
                    Object s2 = newConst.tpe();
                    Predef$.MODULE$.require(!(s != null ? !s.equals(s2) : s2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected new constant to have the same ").append(c.tpe()).append(" tpe, got ").append(newConst.tpe()).toString());
                    this.constantSerializer().serialize(newConst, w);
                }
            }
        } else {
            w.putUInt(constants2.length());
            ((IterableLike)constants2.zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ErgoTreeSerializer.$anonfun$substituteConstants$3(this, positions, newVals, w, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        w.putBytes(treeBytes2);
        return new Tuple2((Object)w.toBytes(), (Object)BoxesRunTime.boxToInteger((int)constants2.length()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$substituteConstants$3(ErgoTreeSerializer $this, int[] positions$1, Values.Constant[] newVals$1, SigmaByteWriter w$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Values.Constant c = (Values.Constant)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions$1)).contains((Object)BoxesRunTime.boxToInteger((int)i))) {
                Values.Constant newVal = newVals$1[new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(positions$1)).indexOf((Object)BoxesRunTime.boxToInteger((int)i))];
                ConstantStore constantStore = new ConstantStore(ConstantStore$.MODULE$.$lessinit$greater$default$1());
                SigmaByteWriter valW = SigmaSerializer$.MODULE$.startWriter(constantStore);
                valW.putValue(newVal);
                IndexedSeq<Values.Constant<SType>> newConsts = constantStore.getAll();
                Predef$.MODULE$.require(newConsts.length() == 1);
                Values.Constant newConst = (Values.Constant)newConsts.head();
                Object s = c.tpe();
                Object s2 = newConst.tpe();
                Predef$.MODULE$.require(!(s != null ? !s.equals(s2) : s2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("expected new constant to have the same ").append(c.tpe()).append(" tpe, got ").append(newConst.tpe()).toString());
                $this.constantSerializer().serialize(newConst, w$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Values.Constant c = (Values.Constant)tuple2._1();
        $this.constantSerializer().serialize(c, w$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

