/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.ergoplatform.validation.ValidationRules$CheckPrimitiveTypeCode$;
import org.ergoplatform.validation.ValidationRules$CheckTypeCode$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import sigmastate.NoType$;
import sigmastate.SAny$;
import sigmastate.SAvlTree$;
import sigmastate.SBigInt$;
import sigmastate.SBoolean$;
import sigmastate.SBox$;
import sigmastate.SByte$;
import sigmastate.SCollection;
import sigmastate.SCollection$;
import sigmastate.SCollectionType;
import sigmastate.SCollectionType$;
import sigmastate.SContext$;
import sigmastate.SEmbeddable;
import sigmastate.SGlobal$;
import sigmastate.SGroupElement$;
import sigmastate.SHeader$;
import sigmastate.SInt$;
import sigmastate.SLong$;
import sigmastate.SOption;
import sigmastate.SOption$;
import sigmastate.SPreHeader$;
import sigmastate.SPrimType$;
import sigmastate.SShort$;
import sigmastate.SSigmaProp$;
import sigmastate.SString$;
import sigmastate.STuple;
import sigmastate.STuple$;
import sigmastate.SType;
import sigmastate.STypeVar;
import sigmastate.STypeVar$;
import sigmastate.SUnit$;
import sigmastate.lang.exceptions.InvalidTypePrefix;
import sigmastate.lang.exceptions.InvalidTypePrefix$;
import sigmastate.util$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;

public final class TypeSerializer$ {
    public static TypeSerializer$ MODULE$;
    private final SType[] embeddableIdToType;

    static {
        new TypeSerializer$();
    }

    public SType[] embeddableIdToType() {
        return this.embeddableIdToType;
    }

    public SType getEmbeddableType(int code) {
        ValidationRules$CheckPrimitiveTypeCode$.MODULE$.apply((byte)code);
        return this.embeddableIdToType()[code];
    }

    public void serialize(SType tpe, SigmaByteWriter w) {
        block35: {
            IndexedSeq<SType> items;
            SType sType;
            STuple sTuple;
            boolean bl;
            block36: {
                while (true) {
                    SType p;
                    SType p2;
                    SType t2;
                    bl = false;
                    sTuple = null;
                    sType = tpe;
                    if (sType instanceof SEmbeddable) {
                        SEmbeddable sEmbeddable = (SEmbeddable)sType;
                        w.put(sEmbeddable.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SString$.MODULE$.equals(sType)) {
                        w.put(SString$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SAny$.MODULE$.equals(sType)) {
                        w.put(SAny$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SUnit$.MODULE$.equals(sType)) {
                        w.put(SUnit$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SBox$.MODULE$.equals(sType)) {
                        w.put(SBox$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SAvlTree$.MODULE$.equals(sType)) {
                        w.put(SAvlTree$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SContext$.MODULE$.equals(sType)) {
                        w.put(SContext$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SGlobal$.MODULE$.equals(sType)) {
                        w.put(SGlobal$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SHeader$.MODULE$.equals(sType)) {
                        w.put(SHeader$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (SPreHeader$.MODULE$.equals(sType)) {
                        w.put(SPreHeader$.MODULE$.typeCode());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (sType instanceof SCollectionType) {
                        SCollectionType sCollectionType = (SCollectionType)sType;
                        Object t = sCollectionType.elemType();
                        if (t instanceof SEmbeddable) {
                            Object t3 = t;
                            byte code = ((SEmbeddable)t3).embedIn(SCollectionType$.MODULE$.CollectionTypeCode());
                            w.put(code);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (t instanceof SCollectionType) {
                            SCollectionType sCollectionType2 = (SCollectionType)t;
                            Object t4 = sCollectionType2.elemType();
                            if (!(t4 instanceof SEmbeddable)) {
                                w.put(SCollectionType$.MODULE$.CollectionTypeCode());
                                tpe = sCollectionType2;
                                continue;
                            }
                            Object t5 = t4;
                            byte code = ((SEmbeddable)t5).embedIn(SCollectionType$.MODULE$.NestedCollectionTypeCode());
                            w.put(code);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            w.put(SCollectionType$.MODULE$.CollectionTypeCode());
                            tpe = t;
                            continue;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (sType instanceof SOption) {
                        SOption sOption = (SOption)sType;
                        Object ElemType = sOption.elemType();
                        if (ElemType instanceof SEmbeddable) {
                            Object ElemType2 = ElemType;
                            byte code = ((SEmbeddable)ElemType2).embedIn(SOption$.MODULE$.OptionTypeCode());
                            w.put(code);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (ElemType instanceof SCollectionType) {
                            SCollectionType sCollectionType = (SCollectionType)ElemType;
                            Object t = sCollectionType.elemType();
                            if (!(t instanceof SEmbeddable)) {
                                w.put(SOption$.MODULE$.OptionTypeCode());
                                tpe = sCollectionType;
                                continue;
                            }
                            Object t6 = t;
                            byte code = ((SEmbeddable)t6).embedIn(SOption$.MODULE$.OptionCollectionTypeCode());
                            w.put(code);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            w.put(SOption$.MODULE$.OptionTypeCode());
                            tpe = ElemType;
                            continue;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block35;
                    }
                    if (!(sType instanceof STuple)) break block36;
                    bl = true;
                    sTuple = (STuple)sType;
                    IndexedSeq<SType> indexedSeq = sTuple.items();
                    Some some = Seq$.MODULE$.unapplySeq(indexedSeq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block36;
                    SType t1 = (SType)((SeqLike)some.get()).apply(0);
                    Tuple2 tuple2 = new Tuple2((Object)t1, (Object)(t2 = (SType)((SeqLike)some.get()).apply(1)));
                    if (tuple2 != null && (p2 = (SType)tuple2._1()) instanceof SEmbeddable) {
                        SEmbeddable sEmbeddable;
                        SEmbeddable sEmbeddable2 = sEmbeddable = (SEmbeddable)p2;
                        SType sType2 = t2;
                        if (sEmbeddable2 != null ? !sEmbeddable2.equals(sType2) : sType2 != null) {
                            byte code = sEmbeddable.embedIn(STuple$.MODULE$.Pair1TypeCode());
                            w.put(code);
                            tpe = t2;
                            continue;
                        }
                        byte code = sEmbeddable.embedIn(STuple$.MODULE$.PairSymmetricTypeCode());
                        w.put(code);
                        break;
                    }
                    if (tuple2 != null && (p = (SType)tuple2._2()) instanceof SEmbeddable) {
                        SEmbeddable sEmbeddable = (SEmbeddable)p;
                        byte code = sEmbeddable.embedIn(STuple$.MODULE$.Pair2TypeCode());
                        w.put(code);
                        tpe = t1;
                        continue;
                    }
                    w.put(STuple$.MODULE$.Pair1TypeCode());
                    this.serialize(t1, w);
                    tpe = t2;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                break block35;
            }
            if (bl && (items = sTuple.items()).length() < 2) {
                throw package$.MODULE$.error(new StringBuilder(42).append("Invalid Tuple type with less than 2 items ").append(items).toString());
            }
            if (bl) {
                BoxedUnit boxedUnit;
                int n = sTuple.items().length();
                switch (n) {
                    case 3: {
                        w.put(STuple$.MODULE$.TripleTypeCode());
                        sTuple.items().foreach((Function1 & Serializable & scala.Serializable)i -> {
                            TypeSerializer$.MODULE$.serialize(i, w);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 4: {
                        w.put(STuple$.MODULE$.QuadrupleTypeCode());
                        sTuple.items().foreach((Function1 & Serializable & scala.Serializable)i -> {
                            TypeSerializer$.MODULE$.serialize(i, w);
                            return BoxedUnit.UNIT;
                        });
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    default: {
                        this.serializeTuple(sTuple, w);
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                }
                BoxedUnit boxedUnit5 = boxedUnit;
            } else if (sType instanceof STypeVar) {
                STypeVar sTypeVar = (STypeVar)sType;
                w.put(sTypeVar.typeCode());
                byte[] bytes = sTypeVar.name().getBytes(StandardCharsets.UTF_8);
                w.putUByte(bytes.length).putBytes(bytes);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)sType);
            }
        }
    }

    public SType deserialize(SigmaByteReader r) {
        return this.deserialize(r, 0);
    }

    private SType deserialize(SigmaByteReader r, int depth) {
        SType sType;
        int c = r.getUByte();
        if (c <= 0) {
            throw new InvalidTypePrefix(new StringBuilder(63).append("Cannot deserialize type prefix ").append(c).append(". Unexpected buffer ").append((Object)r).append(" with bytes ").append(r.getBytes(r.remaining())).toString(), InvalidTypePrefix$.MODULE$.$lessinit$greater$default$2(), InvalidTypePrefix$.MODULE$.$lessinit$greater$default$3());
        }
        if (c < STuple$.MODULE$.TupleTypeCode()) {
            STuple sTuple;
            int constrId = c / SPrimType$.MODULE$.PrimRange();
            int primId = c % SPrimType$.MODULE$.PrimRange();
            int n = constrId;
            if (0 == n) {
                sTuple = this.getEmbeddableType(c);
            } else if (1 == n) {
                SType tElem = this.getArgType(r, primId, depth);
                sTuple = SCollection$.MODULE$.apply(tElem);
            } else if (2 == n) {
                SType tElem = this.getArgType(r, primId, depth);
                sTuple = SCollection$.MODULE$.apply(SCollection$.MODULE$.apply(tElem));
            } else if (3 == n) {
                SType tElem = this.getArgType(r, primId, depth);
                sTuple = new SOption<SType>(tElem);
            } else if (4 == n) {
                SType tElem = this.getArgType(r, primId, depth);
                sTuple = new SOption<SCollection<SType>>(SCollection$.MODULE$.apply(tElem));
            } else if (STuple$.MODULE$.Pair1TypeConstrId() == n) {
                Tuple2 tuple2;
                Tuple2 tuple22 = tuple2 = primId == 0 ? new Tuple2((Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1)) : new Tuple2((Object)this.getEmbeddableType(primId), (Object)this.deserialize(r, depth + 1));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SType t1 = (SType)tuple2._1();
                SType t2 = (SType)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)t1, (Object)t2);
                Tuple2 tuple24 = tuple23;
                SType t12 = (SType)tuple24._1();
                SType t22 = (SType)tuple24._2();
                sTuple = STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{t12, t22}));
            } else if (STuple$.MODULE$.Pair2TypeConstrId() == n) {
                STuple sTuple2;
                if (primId == 0) {
                    Tuple3 tuple3 = new Tuple3((Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1));
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    SType t1 = (SType)tuple3._1();
                    SType t2 = (SType)tuple3._2();
                    SType t3 = (SType)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)t1, (Object)t2, (Object)t3);
                    Tuple3 tuple33 = tuple32;
                    SType t13 = (SType)tuple33._1();
                    SType t23 = (SType)tuple33._2();
                    SType t32 = (SType)tuple33._3();
                    sTuple2 = STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{t13, t23, t32}));
                } else {
                    SType t2 = this.getEmbeddableType(primId);
                    SType t1 = this.deserialize(r, depth + 1);
                    sTuple2 = STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{t1, t2}));
                }
                sTuple = sTuple2;
            } else if (STuple$.MODULE$.PairSymmetricTypeConstrId() == n) {
                STuple sTuple3;
                if (primId == 0) {
                    Tuple4 tuple4 = new Tuple4((Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1), (Object)this.deserialize(r, depth + 1));
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    SType t1 = (SType)tuple4._1();
                    SType t2 = (SType)tuple4._2();
                    SType t3 = (SType)tuple4._3();
                    SType t4 = (SType)tuple4._4();
                    Tuple4 tuple42 = new Tuple4((Object)t1, (Object)t2, (Object)t3, (Object)t4);
                    Tuple4 tuple43 = tuple42;
                    SType t14 = (SType)tuple43._1();
                    SType t24 = (SType)tuple43._2();
                    SType t33 = (SType)tuple43._3();
                    SType t42 = (SType)tuple43._4();
                    sTuple3 = STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{t14, t24, t33, t42}));
                } else {
                    SType t = this.getEmbeddableType(primId);
                    sTuple3 = STuple$.MODULE$.apply((Seq<SType>)Predef$.MODULE$.wrapRefArray((Object[])new SType[]{t, t}));
                }
                sTuple = sTuple3;
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            sType = sTuple;
        } else {
            scala.Serializable serializable;
            int n = c;
            if (STuple$.MODULE$.TupleTypeCode() == n) {
                int len = r.getUByte();
                SType[] items = (SType[])util$.MODULE$.safeNewArray(len, ClassTag$.MODULE$.apply(SType.class));
                for (int index$macro$1 = 0; index$macro$1 < len; ++index$macro$1) {
                    items[index$macro$1] = this.deserialize(r, depth + 1);
                }
                serializable = new STuple((IndexedSeq<SType>)Predef$.MODULE$.wrapRefArray((Object[])items));
            } else if (SAny$.MODULE$.typeCode() == n) {
                serializable = SAny$.MODULE$;
            } else if (SUnit$.MODULE$.typeCode() == n) {
                serializable = SUnit$.MODULE$;
            } else if (SBox$.MODULE$.typeCode() == n) {
                serializable = SBox$.MODULE$;
            } else if (SAvlTree$.MODULE$.typeCode() == n) {
                serializable = SAvlTree$.MODULE$;
            } else if (SContext$.MODULE$.typeCode() == n) {
                serializable = SContext$.MODULE$;
            } else if (SString$.MODULE$.typeCode() == n) {
                serializable = SString$.MODULE$;
            } else if (STypeVar$.MODULE$.TypeCode() == n) {
                int nameLength = r.getUByte();
                String name = new String(r.getBytes(nameLength), StandardCharsets.UTF_8);
                serializable = new STypeVar(name);
            } else if (SHeader$.MODULE$.typeCode() == n) {
                serializable = SHeader$.MODULE$;
            } else if (SPreHeader$.MODULE$.typeCode() == n) {
                serializable = SPreHeader$.MODULE$;
            } else if (SGlobal$.MODULE$.typeCode() == n) {
                serializable = SGlobal$.MODULE$;
            } else {
                ValidationRules$CheckTypeCode$.MODULE$.apply((byte)c);
                serializable = NoType$.MODULE$;
            }
            sType = serializable;
        }
        SAny$ tpe = sType;
        return tpe;
    }

    private SType getArgType(SigmaByteReader r, int primId, int depth) {
        return primId == 0 ? this.deserialize(r, depth + 1) : this.getEmbeddableType(primId);
    }

    private void serializeTuple(STuple t, SigmaByteWriter w) {
        Predef$.MODULE$.assert(t.items().length() <= 255);
        w.put(STuple$.MODULE$.TupleTypeCode());
        w.putUByte(t.items().length());
        t.items().foreach((Function1 & Serializable & scala.Serializable)i -> {
            TypeSerializer$.MODULE$.serialize(i, w);
            return BoxedUnit.UNIT;
        });
    }

    private TypeSerializer$() {
        MODULE$ = this;
        this.embeddableIdToType = (SType[])((Object[])new SType[]{null, SBoolean$.MODULE$, SByte$.MODULE$, SShort$.MODULE$, SInt$.MODULE$, SLong$.MODULE$, SBigInt$.MODULE$, SGroupElement$.MODULE$, SSigmaProp$.MODULE$});
    }
}

