/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser.ast.global;

import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.MessageNode;
import org.scribble.ast.MessageSigNode;
import org.scribble.ast.global.GMessageTransfer;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.parser.AntlrConstants;
import org.scribble.parser.ScribParser;
import org.scribble.parser.ast.name.AntlrAmbigName;
import org.scribble.parser.ast.name.AntlrQualifiedName;
import org.scribble.parser.ast.name.AntlrSimpleName;
import org.scribble.parser.util.ScribParserUtil;
import org.scribble.util.ScribParserException;

public class AntlrGMessageTransfer {
    public static final int MESSAGE_CHILD_INDEX = 0;
    public static final int SOURCE_CHILD_INDEX = 1;
    public static final int DESTINATION_CHILDREN_START_INDEX = 2;

    public static GMessageTransfer parseGMessageTransfer(ScribParser parser, CommonTree ct) throws ScribParserException {
        RoleNode src = AntlrSimpleName.toRoleNode(AntlrGMessageTransfer.getSourceChild(ct));
        MessageNode msg = AntlrGMessageTransfer.parseMessage(parser, AntlrGMessageTransfer.getMessageChild(ct));
        List dests = AntlrGMessageTransfer.getDestChildren(ct).stream().map(d -> AntlrSimpleName.toRoleNode(d)).collect(Collectors.toList());
        return AstFactoryImpl.FACTORY.GMessageTransfer(ct, src, msg, dests);
    }

    protected static MessageNode parseMessage(ScribParser parser, CommonTree ct) throws ScribParserException {
        AntlrConstants.AntlrNodeType type = ScribParserUtil.getAntlrNodeType(ct);
        if (type == AntlrConstants.AntlrNodeType.MESSAGESIGNATURE) {
            return (MessageSigNode)parser.parse(ct);
        }
        return ct.getChildCount() == 1 ? AntlrAmbigName.toAmbigNameNode(ct) : AntlrQualifiedName.toMessageSigNameNode(ct);
    }

    public static CommonTree getMessageChild(CommonTree ct) {
        return (CommonTree)ct.getChild(0);
    }

    public static CommonTree getSourceChild(CommonTree ct) {
        return (CommonTree)ct.getChild(1);
    }

    public static List<CommonTree> getDestChildren(CommonTree ct) {
        return ScribParserUtil.toCommonTreeList(ct.getChildren().subList(2, ct.getChildCount()));
    }
}

