/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.cli.CommandLineArgParser;
import org.scribble.cli.CommandLineException;
import org.scribble.main.Job;
import org.scribble.main.JobContext;
import org.scribble.main.MainContext;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.DirectoryResourceLocator;
import org.scribble.main.resource.ResourceLocator;
import org.scribble.model.endpoint.EGraph;
import org.scribble.model.global.SGraph;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ScribParserException;
import org.scribble.util.ScribUtil;

public class CommandLine {
    private final Map<ArgFlag, String[]> args;

    public CommandLine(String ... args) throws CommandLineException {
        this.args = new CommandLineArgParser(args).getArgs();
        if (!this.args.containsKey((Object)ArgFlag.MAIN_MOD) && !this.args.containsKey((Object)ArgFlag.INLINE_MAIN_MOD)) {
            throw new CommandLineException("No main module has been specified\r\n");
        }
    }

    public static void main(String[] args) throws CommandLineException, ScribbleException {
        try {
            new CommandLine(args).run();
        }
        catch (CommandLineException | ScribParserException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (RuntimeScribbleException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public void run() throws ScribbleException, CommandLineException, ScribParserException {
        try {
            ScribbleException fail;
            Job job;
            block24: {
                job = this.newJob(this.newMainContext());
                fail = null;
                try {
                    job.checkWellFormedness();
                }
                catch (ScribbleException x) {
                    fail = x;
                }
                try {
                    if (this.args.containsKey((Object)ArgFlag.PROJECT)) {
                        this.outputProjections(job);
                    }
                    if (this.args.containsKey((Object)ArgFlag.EFSM)) {
                        this.outputEGraph(job, true, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.VALIDATION_EFSM)) {
                        this.outputEGraph(job, false, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.UNFAIR_EFSM)) {
                        this.outputEGraph(job, false, false);
                    }
                    if (this.args.containsKey((Object)ArgFlag.EFSM_PNG)) {
                        this.drawEGraph(job, true, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.VALIDATION_EFSM_PNG)) {
                        this.drawEGraph(job, false, true);
                    }
                    if (this.args.containsKey((Object)ArgFlag.UNFAIR_EFSM_PNG)) {
                        this.drawEGraph(job, false, false);
                    }
                    if (this.args.containsKey((Object)ArgFlag.SGRAPH) || this.args.containsKey((Object)ArgFlag.SGRAPH_PNG) || this.args.containsKey((Object)ArgFlag.UNFAIR_SGRAPH) || this.args.containsKey((Object)ArgFlag.UNFAIR_SGRAPH_PNG)) {
                        if (job.useOldWf) {
                            throw new CommandLineException("Global model flag(s) incompatible with: -oldwf");
                        }
                        if (this.args.containsKey((Object)ArgFlag.SGRAPH)) {
                            this.outputSGraph(job, true);
                        }
                        if (this.args.containsKey((Object)ArgFlag.UNFAIR_SGRAPH)) {
                            this.outputSGraph(job, false);
                        }
                        if (this.args.containsKey((Object)ArgFlag.SGRAPH_PNG)) {
                            this.drawSGraph(job, true);
                        }
                        if (this.args.containsKey((Object)ArgFlag.UNFAIR_SGRAPH_PNG)) {
                            this.drawSGraph(job, false);
                        }
                    }
                }
                catch (ScribbleException x) {
                    if (fail != null) break block24;
                    fail = x;
                }
            }
            if (fail != null) {
                throw fail;
            }
            if (this.args.containsKey((Object)ArgFlag.SESS_API_GEN)) {
                this.outputSessionApi(job);
            }
            if (this.args.containsKey((Object)ArgFlag.SCHAN_API_GEN)) {
                this.outputStateChannelApi(job);
            }
            if (this.args.containsKey((Object)ArgFlag.API_GEN)) {
                this.outputEndpointApi(job);
            }
        }
        catch (ScribbleException e) {
            if (this.args.containsKey((Object)ArgFlag.JUNIT) || this.args.containsKey((Object)ArgFlag.VERBOSE)) {
                throw e;
            }
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private void outputProjections(Job job) throws CommandLineException, ScribbleException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.PROJECT);
        for (int i = 0; i < args.length; i += 2) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map projections = job.getProjections(fullname, role);
            System.out.println("\n" + projections.values().stream().map(p -> p.toString()).collect(Collectors.joining("\n\n")));
        }
    }

    private void outputEGraph(Job job, boolean forUser, boolean fair) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = forUser ? this.args.get((Object)ArgFlag.EFSM) : (fair ? this.args.get((Object)ArgFlag.VALIDATION_EFSM) : this.args.get((Object)ArgFlag.UNFAIR_EFSM));
        for (int i = 0; i < args.length; i += 2) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            EGraph fsm = this.getEGraph(job, fullname, role, forUser, fair);
            String out = this.args.containsKey((Object)ArgFlag.AUT) ? fsm.toAut() : fsm.toDot();
            System.out.println("\n" + out);
        }
    }

    private void drawEGraph(Job job, boolean forUser, boolean fair) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = forUser ? this.args.get((Object)ArgFlag.EFSM_PNG) : (fair ? this.args.get((Object)ArgFlag.VALIDATION_EFSM_PNG) : this.args.get((Object)ArgFlag.UNFAIR_EFSM_PNG));
        for (int i = 0; i < args.length; i += 3) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            String png = args[i + 2];
            EGraph fsm = this.getEGraph(job, fullname, role, forUser, fair);
            CommandLine.runDot(fsm.toDot(), png);
        }
    }

    private EGraph getEGraph(Job job, GProtocolName fullname, Role role, boolean forUser, boolean fair) throws ScribbleException, CommandLineException {
        EGraph graph;
        JobContext jcontext = job.getContext();
        GProtocolDecl gpd = (GProtocolDecl)jcontext.getMainModule().getProtocolDecl((ProtocolName)fullname.getSimpleName());
        if (gpd == null || !gpd.header.roledecls.getRoles().contains(role)) {
            throw new CommandLineException("Bad FSM construction args: " + Arrays.toString(this.args.get((Object)ArgFlag.DOT)));
        }
        if (forUser) {
            graph = this.args.containsKey((Object)ArgFlag.LTSCONVERT_MIN) ? jcontext.getMinimisedEGraph(fullname, role) : jcontext.getEGraph(fullname, role);
        } else {
            EGraph eGraph = graph = !fair ? jcontext.getUnfairEGraph(fullname, role) : jcontext.getEGraph(fullname, role);
        }
        if (graph == null) {
            throw new RuntimeScribbleException("Shouldn't see this: " + fullname);
        }
        return graph;
    }

    private void outputSGraph(Job job, boolean fair) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = fair ? this.args.get((Object)ArgFlag.SGRAPH) : this.args.get((Object)ArgFlag.UNFAIR_SGRAPH);
        for (int i = 0; i < args.length; ++i) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            SGraph model = CommandLine.getSGraph(job, fullname, fair);
            String out = this.args.containsKey((Object)ArgFlag.AUT) ? model.toAut() : model.toDot();
            System.out.println("\n" + out);
        }
    }

    private void drawSGraph(Job job, boolean fair) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = fair ? this.args.get((Object)ArgFlag.SGRAPH_PNG) : this.args.get((Object)ArgFlag.UNFAIR_SGRAPH_PNG);
        for (int i = 0; i < args.length; i += 2) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            String png = args[i + 1];
            SGraph model = CommandLine.getSGraph(job, fullname, fair);
            CommandLine.runDot(model.toDot(), png);
        }
    }

    private static SGraph getSGraph(Job job, GProtocolName fullname, boolean fair) throws ScribbleException {
        SGraph model;
        JobContext jcontext = job.getContext();
        SGraph sGraph = model = fair ? jcontext.getSGraph(fullname) : jcontext.getUnfairSGraph(fullname);
        if (model == null) {
            throw new RuntimeScribbleException("Shouldn't see this: " + fullname);
        }
        return model;
    }

    private void outputEndpointApi(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.API_GEN);
        for (int i = 0; i < args.length; i += 2) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Map sessClasses = job.generateSessionApi(fullname);
            this.outputClasses(sessClasses);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map scClasses = job.generateStateChannelApi(fullname, role, this.args.containsKey((Object)ArgFlag.SCHAN_API_SUBTYPES));
            this.outputClasses(scClasses);
        }
    }

    private void outputSessionApi(Job job) throws ScribbleException, CommandLineException {
        String[] args;
        JobContext jcontext = job.getContext();
        for (String fullname : args = this.args.get((Object)ArgFlag.SESS_API_GEN)) {
            GProtocolName gpn = CommandLine.checkGlobalProtocolArg(jcontext, fullname);
            Map classes = job.generateSessionApi(gpn);
            this.outputClasses(classes);
        }
    }

    private void outputStateChannelApi(Job job) throws ScribbleException, CommandLineException {
        JobContext jcontext = job.getContext();
        String[] args = this.args.get((Object)ArgFlag.SCHAN_API_GEN);
        for (int i = 0; i < args.length; i += 2) {
            GProtocolName fullname = CommandLine.checkGlobalProtocolArg(jcontext, args[i]);
            Role role = CommandLine.checkRoleArg(jcontext, fullname, args[i + 1]);
            Map classes = job.generateStateChannelApi(fullname, role, this.args.containsKey((Object)ArgFlag.SCHAN_API_SUBTYPES));
            this.outputClasses(classes);
        }
    }

    private void outputClasses(Map<String, String> classes) throws ScribbleException {
        Consumer<String> f;
        if (this.args.containsKey((Object)ArgFlag.API_OUTPUT)) {
            String dir = this.args.get((Object)ArgFlag.API_OUTPUT)[0];
            f = path -> ScribUtil.handleLambdaScribbleException(() -> {
                String tmp = dir + "/" + path;
                if (this.args.containsKey((Object)ArgFlag.VERBOSE)) {
                    System.out.println("\n[DEBUG] Writing to: " + tmp);
                }
                ScribUtil.writeToFile((String)tmp, (String)((String)classes.get(path)));
                return null;
            });
        } else {
            f = path -> System.out.println(path + ":\n" + (String)classes.get(path));
        }
        classes.keySet().stream().forEach(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runDot(String dot, String png) throws ScribbleException, CommandLineException {
        String tmpName = png + ".tmp";
        File tmp = new File(tmpName);
        if (tmp.exists()) {
            throw new CommandLineException("Cannot overwrite: " + tmpName);
        }
        try {
            ScribUtil.writeToFile((String)tmpName, (String)dot);
            String[] res = ScribUtil.runProcess((String[])new String[]{"dot", "-Tpng", "-o" + png, tmpName});
            System.out.print(!res[1].isEmpty() ? res[1] : res[0]);
        }
        finally {
            tmp.delete();
        }
    }

    private Job newJob(MainContext mc) {
        return mc.newJob();
    }

    private MainContext newMainContext() throws ScribParserException, ScribbleException {
        boolean debug = this.args.containsKey((Object)ArgFlag.VERBOSE);
        boolean useOldWF = this.args.containsKey((Object)ArgFlag.OLD_WF);
        boolean noLiveness = this.args.containsKey((Object)ArgFlag.NO_LIVENESS);
        boolean minEfsm = this.args.containsKey((Object)ArgFlag.LTSCONVERT_MIN);
        boolean fair = this.args.containsKey((Object)ArgFlag.FAIR);
        boolean noLocalChoiceSubjectCheck = this.args.containsKey((Object)ArgFlag.NO_LOCAL_CHOICE_SUBJECT_CHECK);
        boolean noAcceptCorrelationCheck = this.args.containsKey((Object)ArgFlag.NO_ACCEPT_CORRELATION_CHECK);
        boolean noValidation = this.args.containsKey((Object)ArgFlag.NO_VALIDATION);
        boolean f17 = this.args.containsKey((Object)ArgFlag.F17);
        List impaths = this.args.containsKey((Object)ArgFlag.IMPORT_PATH) ? CommandLine.parseImportPaths(this.args.get((Object)ArgFlag.IMPORT_PATH)[0]) : Collections.emptyList();
        DirectoryResourceLocator locator = new DirectoryResourceLocator(impaths);
        if (this.args.containsKey((Object)ArgFlag.INLINE_MAIN_MOD)) {
            return new MainContext(debug, (ResourceLocator)locator, this.args.get((Object)ArgFlag.INLINE_MAIN_MOD)[0], useOldWF, noLiveness, minEfsm, fair, noLocalChoiceSubjectCheck, noAcceptCorrelationCheck, noValidation, f17);
        }
        Path mainpath = CommandLine.parseMainPath(this.args.get((Object)ArgFlag.MAIN_MOD)[0]);
        return new MainContext(debug, (ResourceLocator)locator, mainpath, useOldWF, noLiveness, minEfsm, fair, noLocalChoiceSubjectCheck, noAcceptCorrelationCheck, noValidation, f17);
    }

    private static Path parseMainPath(String path) {
        return Paths.get(path, new String[0]);
    }

    private static List<Path> parseImportPaths(String paths) {
        return Arrays.stream(paths.split(File.pathSeparator)).map(s -> Paths.get(s, new String[0])).collect(Collectors.toList());
    }

    private static GProtocolName checkGlobalProtocolArg(JobContext jcontext, String simpname) throws CommandLineException {
        GProtocolName simpgpn = new GProtocolName(simpname);
        Module main = jcontext.getMainModule();
        if (!main.hasProtocolDecl((ProtocolName)simpgpn)) {
            throw new CommandLineException("Global protocol not found: " + simpname);
        }
        ProtocolDecl pd = main.getProtocolDecl((ProtocolName)simpgpn);
        if (pd == null || !pd.isGlobal()) {
            throw new CommandLineException("Global protocol not found: " + simpname);
        }
        if (pd.isAuxModifier()) {
            throw new CommandLineException("Invalid aux protocol specified as root: " + simpname);
        }
        return new GProtocolName(jcontext.main, (ProtocolName)simpgpn);
    }

    private static Role checkRoleArg(JobContext jcontext, GProtocolName fullname, String rolename) throws CommandLineException {
        ProtocolDecl pd = jcontext.getMainModule().getProtocolDecl((ProtocolName)fullname.getSimpleName());
        Role role = new Role(rolename);
        if (!pd.header.roledecls.getRoles().contains(role)) {
            throw new CommandLineException("Role not declared for " + fullname + ": " + role);
        }
        return role;
    }

    protected static enum ArgFlag {
        JUNIT,
        MAIN_MOD,
        IMPORT_PATH,
        VERBOSE,
        SCHAN_API_SUBTYPES,
        OLD_WF,
        NO_LIVENESS,
        LTSCONVERT_MIN,
        FAIR,
        NO_LOCAL_CHOICE_SUBJECT_CHECK,
        NO_ACCEPT_CORRELATION_CHECK,
        DOT,
        AUT,
        NO_VALIDATION,
        INLINE_MAIN_MOD,
        F17,
        PROJECT,
        API_OUTPUT,
        EFSM,
        VALIDATION_EFSM,
        UNFAIR_EFSM,
        UNFAIR_EFSM_PNG,
        EFSM_PNG,
        VALIDATION_EFSM_PNG,
        SGRAPH,
        UNFAIR_SGRAPH,
        SGRAPH_PNG,
        UNFAIR_SGRAPH_PNG,
        API_GEN,
        SESS_API_GEN,
        SCHAN_API_GEN;

    }
}

