/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.cli;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.scribble.cli.CommandLine;
import org.scribble.cli.CommandLineException;

public class CommandLineArgParser {
    public static final String JUNIT_FLAG = "-junit";
    public static final String VERBOSE_FLAG = "-V";
    public static final String IMPORT_PATH_FLAG = "-ip";
    public static final String API_OUTPUT_DIR_FLAG = "-d";
    public static final String STATECHAN_SUBTYPES_FLAG = "-subtypes";
    public static final String OLD_WF_FLAG = "-oldwf";
    public static final String NO_LIVENESS_FLAG = "-nolive";
    public static final String LTSCONVERT_MIN_FLAG = "-minlts";
    public static final String FAIR_FLAG = "-fair";
    public static final String NO_LOCAL_CHOICE_SUBJECT_CHECK = "-nolocalchoicecheck";
    public static final String NO_ACCEPT_CORRELATION_CHECK = "-nocorrelation";
    public static final String DOT_FLAG = "-dot";
    public static final String AUT_FLAG = "-aut";
    public static final String NO_VALIDATION_FLAG = "-novalid";
    public static final String INLINE_MAIN_MOD_FLAG = "-inline";
    public static final String F17_FLAG = "-f17";
    public static final String PROJECT_FLAG = "-project";
    public static final String EFSM_FLAG = "-fsm";
    public static final String VALIDATION_EFSM_FLAG = "-vfsm";
    public static final String UNFAIR_EFSM_FLAG = "-ufsm";
    public static final String EFSM_PNG_FLAG = "-fsmpng";
    public static final String VALIDATION_EFSM_PNG_FLAG = "-vfsmpng";
    public static final String UNFAIR_EFSM_PNG_FLAG = "-ufsmpng";
    public static final String SGRAPH_FLAG = "-model";
    public static final String UNFAIR_SGRAPH_FLAG = "-umodel";
    public static final String SGRAPH_PNG_FLAG = "-modelpng";
    public static final String UNFAIR_SGRAPH_PNG_FLAG = "-umodelpng";
    public static final String API_GEN_FLAG = "-api";
    public static final String SESSION_API_GEN_FLAG = "-sessapi";
    public static final String STATECHAN_API_GEN_FLAG = "-chanapi";
    private static final Map<String, CommandLine.ArgFlag> UNIQUE_FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private static final Map<String, CommandLine.ArgFlag> NON_UNIQUE_FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private static final Map<String, CommandLine.ArgFlag> FLAGS = new HashMap<String, CommandLine.ArgFlag>();
    private final String[] args;
    private final Map<CommandLine.ArgFlag, String[]> parsed;

    public CommandLineArgParser(String[] args) throws CommandLineException {
        UNIQUE_FLAGS.put(JUNIT_FLAG, CommandLine.ArgFlag.JUNIT);
        UNIQUE_FLAGS.put(VERBOSE_FLAG, CommandLine.ArgFlag.VERBOSE);
        UNIQUE_FLAGS.put(IMPORT_PATH_FLAG, CommandLine.ArgFlag.IMPORT_PATH);
        UNIQUE_FLAGS.put(API_OUTPUT_DIR_FLAG, CommandLine.ArgFlag.API_OUTPUT);
        UNIQUE_FLAGS.put(STATECHAN_SUBTYPES_FLAG, CommandLine.ArgFlag.SCHAN_API_SUBTYPES);
        UNIQUE_FLAGS.put(OLD_WF_FLAG, CommandLine.ArgFlag.OLD_WF);
        UNIQUE_FLAGS.put(LTSCONVERT_MIN_FLAG, CommandLine.ArgFlag.LTSCONVERT_MIN);
        UNIQUE_FLAGS.put(FAIR_FLAG, CommandLine.ArgFlag.FAIR);
        UNIQUE_FLAGS.put(NO_LOCAL_CHOICE_SUBJECT_CHECK, CommandLine.ArgFlag.NO_LOCAL_CHOICE_SUBJECT_CHECK);
        UNIQUE_FLAGS.put(NO_ACCEPT_CORRELATION_CHECK, CommandLine.ArgFlag.NO_ACCEPT_CORRELATION_CHECK);
        UNIQUE_FLAGS.put(DOT_FLAG, CommandLine.ArgFlag.DOT);
        UNIQUE_FLAGS.put(AUT_FLAG, CommandLine.ArgFlag.AUT);
        UNIQUE_FLAGS.put(NO_VALIDATION_FLAG, CommandLine.ArgFlag.NO_VALIDATION);
        UNIQUE_FLAGS.put(INLINE_MAIN_MOD_FLAG, CommandLine.ArgFlag.INLINE_MAIN_MOD);
        UNIQUE_FLAGS.put(F17_FLAG, CommandLine.ArgFlag.F17);
        NON_UNIQUE_FLAGS.put(PROJECT_FLAG, CommandLine.ArgFlag.PROJECT);
        NON_UNIQUE_FLAGS.put(EFSM_FLAG, CommandLine.ArgFlag.EFSM);
        NON_UNIQUE_FLAGS.put(VALIDATION_EFSM_FLAG, CommandLine.ArgFlag.VALIDATION_EFSM);
        NON_UNIQUE_FLAGS.put(UNFAIR_EFSM_FLAG, CommandLine.ArgFlag.UNFAIR_EFSM);
        NON_UNIQUE_FLAGS.put(EFSM_PNG_FLAG, CommandLine.ArgFlag.EFSM_PNG);
        NON_UNIQUE_FLAGS.put(VALIDATION_EFSM_PNG_FLAG, CommandLine.ArgFlag.VALIDATION_EFSM_PNG);
        NON_UNIQUE_FLAGS.put(UNFAIR_EFSM_PNG_FLAG, CommandLine.ArgFlag.UNFAIR_EFSM_PNG);
        NON_UNIQUE_FLAGS.put(SGRAPH_FLAG, CommandLine.ArgFlag.SGRAPH);
        NON_UNIQUE_FLAGS.put(UNFAIR_SGRAPH_FLAG, CommandLine.ArgFlag.UNFAIR_SGRAPH);
        NON_UNIQUE_FLAGS.put(SGRAPH_PNG_FLAG, CommandLine.ArgFlag.SGRAPH_PNG);
        NON_UNIQUE_FLAGS.put(UNFAIR_SGRAPH_PNG_FLAG, CommandLine.ArgFlag.UNFAIR_SGRAPH_PNG);
        NON_UNIQUE_FLAGS.put(API_GEN_FLAG, CommandLine.ArgFlag.API_GEN);
        NON_UNIQUE_FLAGS.put(SESSION_API_GEN_FLAG, CommandLine.ArgFlag.SESS_API_GEN);
        NON_UNIQUE_FLAGS.put(STATECHAN_API_GEN_FLAG, CommandLine.ArgFlag.SCHAN_API_GEN);
        FLAGS.putAll(UNIQUE_FLAGS);
        FLAGS.putAll(NON_UNIQUE_FLAGS);
        this.parsed = new HashMap<CommandLine.ArgFlag, String[]>();
        this.args = args;
        this.parseArgs();
    }

    public Map<CommandLine.ArgFlag, String[]> getArgs() {
        return this.parsed;
    }

    private void parseArgs() throws CommandLineException {
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (FLAGS.containsKey(arg)) {
                i = this.parseFlag(i);
                continue;
            }
            if (this.isMainModuleParsed()) {
                if (arg.startsWith("-")) {
                    throw new CommandLineException("Unknown flag or bad main module arg: " + arg);
                }
                throw new CommandLineException("Bad/multiple main module arg: " + arg);
            }
            this.parseMain(i);
        }
    }

    private boolean isMainModuleParsed() {
        return this.parsed.containsKey((Object)CommandLine.ArgFlag.MAIN_MOD) || this.parsed.containsKey((Object)CommandLine.ArgFlag.INLINE_MAIN_MOD);
    }

    private int parseFlag(int i) throws CommandLineException {
        String flag;
        switch (flag = this.args[i]) {
            case "-ip": {
                return this.parseImportPath(i);
            }
            case "-inline": {
                if (this.isMainModuleParsed()) {
                    throw new CommandLineException("Multiple main modules given.");
                }
                return this.parseInlineMainModule(i);
            }
            case "-f17": {
                return this.parseF17(i);
            }
            case "-junit": 
            case "-V": 
            case "-subtypes": 
            case "-oldwf": 
            case "-nolive": 
            case "-minlts": 
            case "-fair": 
            case "-nolocalchoicecheck": 
            case "-nocorrelation": 
            case "-novalid": {
                this.checkAndAddNoArgUniqueFlag(flag, new String[0]);
                return i;
            }
            case "-d": {
                return this.parseOutput(i);
            }
            case "-dot": {
                if (this.parsed.containsKey((Object)UNIQUE_FLAGS.get(AUT_FLAG))) {
                    throw new CommandLineException("Incompatible flags: -dot and -aut");
                }
                this.checkAndAddNoArgUniqueFlag(flag, new String[0]);
                return i;
            }
            case "-aut": {
                if (this.parsed.containsKey((Object)UNIQUE_FLAGS.get(DOT_FLAG))) {
                    throw new CommandLineException("Incompatible flags: -dot and -aut");
                }
                this.checkAndAddNoArgUniqueFlag(flag, new String[0]);
                return i;
            }
            case "-project": {
                return this.parseProject(i);
            }
            case "-fsm": 
            case "-vfsm": 
            case "-ufsm": 
            case "-api": 
            case "-chanapi": {
                return this.parseProtoAndRoleArgs(flag, i);
            }
            case "-fsmpng": 
            case "-vfsmpng": 
            case "-ufsmpng": {
                return this.parseProtoRoleAndFileArgs(flag, i);
            }
            case "-model": 
            case "-umodel": 
            case "-sessapi": {
                return this.parseProtoArg(flag, i);
            }
            case "-modelpng": 
            case "-umodelpng": {
                return this.parseProtoAndFileArgs(flag, i);
            }
        }
        throw new RuntimeException("[TODO] Unknown flag: " + flag);
    }

    private void checkAndAddNoArgUniqueFlag(String flag, String[] args) throws CommandLineException {
        CommandLine.ArgFlag argFlag = UNIQUE_FLAGS.get(flag);
        if (this.parsed.containsKey((Object)argFlag)) {
            throw new CommandLineException("Duplicate flag: " + flag);
        }
        this.parsed.put(argFlag, args);
    }

    private int parseOutput(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing directory argument");
        }
        String dir = this.args[++i];
        this.parsed.put(UNIQUE_FLAGS.get(API_OUTPUT_DIR_FLAG), new String[]{dir});
        return i;
    }

    private void parseMain(int i) throws CommandLineException {
        String main = this.args[i];
        if (!CommandLineArgParser.validateModuleArg(main)) {
            throw new CommandLineException("Bad module arg: " + main);
        }
        this.parsed.put(CommandLine.ArgFlag.MAIN_MOD, new String[]{main});
    }

    private int parseImportPath(int i) throws CommandLineException {
        String path;
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing path argument");
        }
        if (!CommandLineArgParser.validatePaths(path = this.args[++i])) {
            throw new CommandLineException("Scribble module import path '" + path + "' is not valid\r\n");
        }
        this.checkAndAddNoArgUniqueFlag(IMPORT_PATH_FLAG, new String[]{path});
        return i;
    }

    private int parseInlineMainModule(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing module definition");
        }
        String inline = this.args[++i];
        this.checkAndAddNoArgUniqueFlag(INLINE_MAIN_MOD_FLAG, new String[]{inline});
        return i;
    }

    private int parseF17(int i) throws CommandLineException {
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing simple global protocol name argument");
        }
        String proto = this.args[++i];
        this.checkAndAddNoArgUniqueFlag(F17_FLAG, new String[]{proto});
        return i;
    }

    private int parseProject(int i) throws CommandLineException {
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(NON_UNIQUE_FLAGS.get(PROJECT_FLAG), proto, role);
        return i;
    }

    private int parseProtoAndRoleArgs(String f, int i) throws CommandLineException {
        CommandLine.ArgFlag flag = NON_UNIQUE_FLAGS.get(f);
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        this.concatArgs(flag, proto, role);
        return i;
    }

    private int parseProtoRoleAndFileArgs(String f, int i) throws CommandLineException {
        CommandLine.ArgFlag flag = NON_UNIQUE_FLAGS.get(f);
        if (i + 3 >= this.args.length) {
            throw new CommandLineException("Missing protocol/role/file arguments");
        }
        String proto = this.args[++i];
        String role = this.args[++i];
        String png = this.args[++i];
        this.concatArgs(flag, proto, role, png);
        return i;
    }

    private int parseProtoArg(String f, int i) throws CommandLineException {
        CommandLine.ArgFlag flag = NON_UNIQUE_FLAGS.get(f);
        if (i + 1 >= this.args.length) {
            throw new CommandLineException("Missing protocol argument");
        }
        String proto = this.args[++i];
        this.concatArgs(flag, proto);
        return i;
    }

    private int parseProtoAndFileArgs(String f, int i) throws CommandLineException {
        CommandLine.ArgFlag flag = NON_UNIQUE_FLAGS.get(f);
        if (i + 2 >= this.args.length) {
            throw new CommandLineException("Missing protocol/file arguments");
        }
        String proto = this.args[++i];
        String png = this.args[++i];
        this.concatArgs(flag, proto, png);
        return i;
    }

    private void concatArgs(CommandLine.ArgFlag flag, String ... toAdd) {
        String[] args = this.parsed.get((Object)flag);
        if (args == null) {
            args = Arrays.copyOf(toAdd, toAdd.length);
        } else {
            String[] tmp = new String[args.length + toAdd.length];
            System.arraycopy(args, 0, tmp, 0, args.length);
            System.arraycopy(toAdd, 0, tmp, args.length, toAdd.length);
            args = tmp;
        }
        this.parsed.put(flag, args);
    }

    private static boolean validateModuleArg(String arg) {
        return arg.chars().noneMatch(i -> !Character.isLetterOrDigit(i) && i != 46 && i != File.separatorChar && i != 58 && i != 45 && i != 95 && i != 47);
    }

    private static boolean validatePaths(String paths) {
        for (String path : paths.split(File.pathSeparator)) {
            if (new File(path).isDirectory()) continue;
            return false;
        }
        return true;
    }
}

