/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.main;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.scribble.ast.ImportDecl;
import org.scribble.ast.ImportModule;
import org.scribble.ast.Module;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.main.resource.DirectoryResourceLocator;
import org.scribble.main.resource.FileResource;
import org.scribble.main.resource.InlineResource;
import org.scribble.main.resource.Resource;
import org.scribble.main.resource.ResourceLocator;
import org.scribble.parser.AntlrParser;
import org.scribble.parser.ScribModuleLoader;
import org.scribble.parser.ScribParser;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.util.Pair;
import org.scribble.util.ScribParserException;

public class MainContext {
    public final boolean debug;
    public final boolean useOldWF;
    public final boolean noLiveness;
    public final boolean minEfsm;
    public final boolean fair;
    public final boolean noLocalChoiceSubjectCheck;
    public final boolean noAcceptCorrelationCheck;
    public final boolean noValidation;
    public final boolean f17;
    private final AntlrParser antlrParser = new AntlrParser();
    private final ScribParser scribParser = new ScribParser();
    private final ResourceLocator locator;
    private final ScribModuleLoader loader;
    private ModuleName main;
    private final Map<ModuleName, Pair<Resource, Module>> parsed = new HashMap<ModuleName, Pair<Resource, Module>>();

    protected MainContext(boolean debug, ResourceLocator locator, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck, boolean noAcceptCorrelationCheck, boolean noValidation, boolean f17) throws ScribParserException, ScribbleException {
        this.debug = debug;
        this.useOldWF = useOldWF;
        this.noLiveness = noLiveness;
        this.minEfsm = minEfsm;
        this.fair = fair;
        this.noLocalChoiceSubjectCheck = noLocalChoiceSubjectCheck;
        this.noAcceptCorrelationCheck = noAcceptCorrelationCheck;
        this.noValidation = noValidation;
        this.f17 = f17;
        this.locator = locator;
        this.loader = new ScribModuleLoader(this.locator, this.antlrParser, this.scribParser);
    }

    public MainContext(boolean debug, ResourceLocator locator, String inline, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck, boolean noAcceptCorrelationCheck, boolean noValidation, boolean f17) throws ScribParserException, ScribbleException {
        this(debug, locator, useOldWF, noLiveness, minEfsm, fair, noLocalChoiceSubjectCheck, noAcceptCorrelationCheck, noValidation, f17);
        InlineResource res = new InlineResource(inline);
        Module mod = (Module)this.scribParser.parse(this.antlrParser.parseAntlrTree((Resource)res));
        this.init((Resource)res, mod);
    }

    public MainContext(boolean debug, ResourceLocator locator, Path mainpath, boolean useOldWF, boolean noLiveness, boolean minEfsm, boolean fair, boolean noLocalChoiceSubjectCheck, boolean noAcceptCorrelationCheck, boolean noValidation, boolean f17) throws ScribParserException, ScribbleException {
        this(debug, locator, useOldWF, noLiveness, minEfsm, fair, noLocalChoiceSubjectCheck, noAcceptCorrelationCheck, noValidation, f17);
        FileResource res = DirectoryResourceLocator.getResourceByFullPath((Path)mainpath);
        Module mod = (Module)this.scribParser.parse(this.antlrParser.parseAntlrTree((Resource)res));
        this.checkMainModuleName(mainpath, mod);
        this.init((Resource)res, mod);
    }

    private void init(Resource res, Module mainmod) throws ScribParserException, ScribbleException {
        Pair p = new Pair((Object)res, (Object)mainmod);
        this.main = ((Module)p.right).getFullModuleName();
        this.loadAllModules((Pair<Resource, Module>)p);
    }

    private void loadAllModules(Pair<Resource, Module> module) throws ScribParserException, ScribbleException {
        this.parsed.put(((Module)module.right).getFullModuleName(), module);
        for (ImportDecl id : ((Module)module.right).getImportDecls()) {
            ModuleName modname;
            if (!id.isImportModule() || this.parsed.containsKey(modname = ((ImportModule)id).modname.toName())) continue;
            this.loadAllModules((Pair<Resource, Module>)this.loader.loadModule(modname));
        }
    }

    public Map<ModuleName, Module> getParsedModules() {
        return this.parsed.entrySet().stream().collect(Collectors.toMap(e -> (ModuleName)e.getKey(), e -> (Module)((Pair)e.getValue()).right));
    }

    public Job newJob() {
        return new Job(this.debug, this.getParsedModules(), this.main, this.useOldWF, this.noLiveness, this.minEfsm, this.fair, this.noLocalChoiceSubjectCheck, this.noAcceptCorrelationCheck, this.noValidation);
    }

    private void checkMainModuleName(Path mainpath, Module main) throws ScribbleException {
        String path;
        String tmp = path.substring((path = mainpath.toString()).lastIndexOf(File.separator) == -1 ? 0 : path.lastIndexOf(File.separator) + 1, path.lastIndexOf(46));
        if (!this.noValidation && !tmp.equals(main.getFullModuleName().getSimpleName().toString())) {
            throw new ScribbleException(main.moddecl.name.getSource(), "Simple module name at path " + path + " mismatch: " + main.getFullModuleName());
        }
    }
}

