/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Iterator;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.NonRoleArgList;
import org.scribble.ast.ProtocolDecl;
import org.scribble.ast.RoleArgList;
import org.scribble.ast.SimpleInteractionNode;
import org.scribble.ast.context.ModuleContext;
import org.scribble.ast.name.qualified.ProtocolNameNode;
import org.scribble.main.JobContext;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.ProtocolName;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.AstVisitor;

public abstract class Do<K extends ProtocolKind>
extends SimpleInteractionNode<K> {
    public final RoleArgList roles;
    public final NonRoleArgList args;
    public final ProtocolNameNode<K> proto;

    protected Do(CommonTree source, RoleArgList roleinstans, NonRoleArgList arginstans, ProtocolNameNode<K> proto) {
        super(source);
        this.roles = roleinstans;
        this.args = arginstans;
        this.proto = proto;
    }

    public abstract Do<K> reconstruct(RoleArgList var1, NonRoleArgList var2, ProtocolNameNode<K> var3);

    public abstract ProtocolNameNode<K> getProtocolNameNode();

    @Override
    public Do<K> visitChildren(AstVisitor nv) throws ScribbleException {
        RoleArgList ril = (RoleArgList)this.visitChild(this.roles, nv);
        NonRoleArgList al = (NonRoleArgList)this.visitChild(this.args, nv);
        ProtocolNameNode<K> proto = Do.visitChildWithClassEqualityCheck(this, this.proto, nv);
        return this.reconstruct(ril, al, proto);
    }

    public ProtocolName<K> getTargetProtocolDeclFullName(ModuleContext mcontext) {
        return this.proto.toName();
    }

    public ProtocolDecl<K> getTargetProtocolDecl(JobContext jcontext, ModuleContext mcontext) {
        ProtocolName<K> fullname = this.getTargetProtocolDeclFullName(mcontext);
        return jcontext.getModule(fullname.getPrefix()).getProtocolDecl(fullname.getSimpleName());
    }

    public Role getTargetRoleParameter(JobContext jcontext, ModuleContext mcontext, Role role) {
        Iterator<Role> args = this.roles.getRoles().iterator();
        Iterator<Role> params = this.getTargetProtocolDecl((JobContext)jcontext, (ModuleContext)mcontext).header.roledecls.getRoles().iterator();
        while (args.hasNext()) {
            Role arg = args.next();
            Role param = params.next();
            if (!arg.equals(role)) continue;
            return param;
        }
        throw new RuntimeException("Not an argument role: " + role);
    }

    public String toString() {
        String s = "do ";
        return s + this.proto + this.args + this.roles + ";";
    }
}

