/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.ImportDecl;
import org.scribble.ast.name.qualified.ModuleNameNode;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ModuleKind;
import org.scribble.sesstype.name.ModuleName;
import org.scribble.visit.AstVisitor;

public class ImportModule
extends ImportDecl<ModuleKind> {
    public final ModuleNameNode modname;
    public final ModuleNameNode alias;

    public ImportModule(CommonTree source, ModuleNameNode modname, ModuleNameNode alias) {
        super(source);
        this.modname = modname;
        this.alias = alias;
    }

    @Override
    protected ImportModule copy() {
        return new ImportModule(this.source, this.modname, this.alias);
    }

    @Override
    public ImportModule clone() {
        ModuleNameNode name = this.modname.clone();
        ModuleNameNode alias = this.alias.clone();
        return AstFactoryImpl.FACTORY.ImportModule(this.source, name, alias);
    }

    public ImportModule reconstruct(ModuleNameNode modname, ModuleNameNode alias) {
        ScribDel del = this.del();
        ImportModule im = new ImportModule(this.source, modname, alias);
        im = (ImportModule)im.del(del);
        return im;
    }

    @Override
    public ImportModule visitChildren(AstVisitor nv) throws ScribbleException {
        ModuleNameNode modname = (ModuleNameNode)this.visitChild(this.modname, nv);
        ModuleNameNode alias = this.isAliased() ? (ModuleNameNode)this.visitChild(this.alias, nv) : null;
        return this.reconstruct(modname, alias);
    }

    @Override
    public boolean isImportModule() {
        return true;
    }

    @Override
    public boolean isAliased() {
        return this.alias != null;
    }

    public ModuleName getAlias() {
        return this.alias.toName();
    }

    public String toString() {
        String s = "import " + this.modname;
        if (this.isAliased()) {
            s = s + " as " + this.alias;
        }
        return s + ";";
    }
}

