/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.MessageNode;
import org.scribble.ast.PayloadElemList;
import org.scribble.ast.ScribNodeBase;
import org.scribble.ast.name.simple.OpNode;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.MessageSig;
import org.scribble.visit.AstVisitor;

public class MessageSigNode
extends ScribNodeBase
implements MessageNode {
    public final OpNode op;
    public final PayloadElemList payloads;

    public MessageSigNode(CommonTree source, OpNode op, PayloadElemList payload) {
        super(source);
        this.op = op;
        this.payloads = payload;
    }

    @Override
    public MessageNode project() {
        return AstFactoryImpl.FACTORY.MessageSigNode(this.source, this.op, this.payloads.project());
    }

    @Override
    protected MessageSigNode copy() {
        return new MessageSigNode(this.source, this.op, this.payloads);
    }

    @Override
    public MessageSigNode clone() {
        OpNode op = this.op.clone();
        PayloadElemList payload = this.payloads.clone();
        return AstFactoryImpl.FACTORY.MessageSigNode(this.source, op, payload);
    }

    public MessageSigNode reconstruct(OpNode op, PayloadElemList payload) {
        ScribDel del = this.del();
        MessageSigNode msn = new MessageSigNode(this.source, op, payload);
        msn = (MessageSigNode)msn.del(del);
        return msn;
    }

    @Override
    public MessageSigNode visitChildren(AstVisitor nv) throws ScribbleException {
        OpNode op = (OpNode)this.visitChild(this.op, nv);
        PayloadElemList payload = (PayloadElemList)this.visitChild(this.payloads, nv);
        return this.reconstruct(op, payload);
    }

    @Override
    public boolean isMessageSigNode() {
        return true;
    }

    public MessageSig toArg() {
        return new MessageSig(this.op.toName(), this.payloads.toPayload());
    }

    @Override
    public MessageSig toMessage() {
        return this.toArg();
    }

    public String toString() {
        return this.op.toString() + this.payloads.toString();
    }
}

