/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.MessageNode;
import org.scribble.ast.SimpleInteractionNode;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.AstVisitor;

public abstract class MessageTransfer<K extends ProtocolKind>
extends SimpleInteractionNode<K> {
    public final RoleNode src;
    public final MessageNode msg;
    private final List<RoleNode> dests;

    protected MessageTransfer(CommonTree source, RoleNode src, MessageNode msg, List<RoleNode> dests) {
        super(source);
        this.src = src;
        this.msg = msg;
        this.dests = new LinkedList<RoleNode>(dests);
    }

    public abstract MessageTransfer<K> reconstruct(RoleNode var1, MessageNode var2, List<RoleNode> var3);

    @Override
    public MessageTransfer<K> visitChildren(AstVisitor nv) throws ScribbleException {
        RoleNode src = (RoleNode)this.visitChild(this.src, nv);
        MessageNode msg = (MessageNode)this.visitChild(this.msg, nv);
        List<RoleNode> dests = MessageTransfer.visitChildListWithClassEqualityCheck(this, this.dests, nv);
        return this.reconstruct(src, msg, dests);
    }

    public List<RoleNode> getDestinations() {
        return Collections.unmodifiableList(this.dests);
    }

    public List<Role> getDestinationRoles() {
        return this.dests.stream().map(rn -> rn.toName()).collect(Collectors.toList());
    }

    public abstract String toString();
}

