/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.CompoundInteractionNode;
import org.scribble.ast.ProtocolBlock;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.ProtocolKind;
import org.scribble.visit.AstVisitor;

public abstract class Parallel<K extends ProtocolKind>
extends CompoundInteractionNode<K> {
    private final List<? extends ProtocolBlock<K>> blocks;

    protected Parallel(CommonTree source, List<? extends ProtocolBlock<K>> blocks) {
        super(source);
        this.blocks = new LinkedList<ProtocolBlock<K>>(blocks);
    }

    public abstract Parallel<K> reconstruct(List<? extends ProtocolBlock<K>> var1);

    @Override
    public Parallel<K> visitChildren(AstVisitor nv) throws ScribbleException {
        List<? extends ProtocolBlock<K>> blocks = Parallel.visitChildListWithClassEqualityCheck(this, this.blocks, nv);
        return this.reconstruct(blocks);
    }

    public List<? extends ProtocolBlock<K>> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public String toString() {
        String sep = " and ";
        return "par " + this.blocks.stream().map(block -> block.toString()).collect(Collectors.joining(sep));
    }
}

