/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.PayloadElem;
import org.scribble.ast.ScribNodeBase;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.Payload;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.PayloadType;
import org.scribble.util.ScribUtil;
import org.scribble.visit.AstVisitor;

public class PayloadElemList
extends ScribNodeBase {
    private final List<PayloadElem<?>> elems;

    public PayloadElemList(CommonTree source, List<PayloadElem<?>> elems) {
        super(source);
        this.elems = new LinkedList(elems);
    }

    protected PayloadElemList project() {
        return AstFactoryImpl.FACTORY.PayloadElemList(this.source, this.elems.stream().map(pe -> pe.project()).collect(Collectors.toList()));
    }

    @Override
    protected PayloadElemList copy() {
        return new PayloadElemList(this.source, this.elems);
    }

    @Override
    public PayloadElemList clone() {
        List<PayloadElem<?>> elems = ScribUtil.cloneList(this.elems);
        return AstFactoryImpl.FACTORY.PayloadElemList(this.source, elems);
    }

    protected PayloadElemList reconstruct(List<PayloadElem<?>> elems) {
        ScribDel del = this.del();
        PayloadElemList pel = new PayloadElemList(this.source, elems);
        pel = (PayloadElemList)pel.del(del);
        return pel;
    }

    @Override
    public PayloadElemList visitChildren(AstVisitor nv) throws ScribbleException {
        List<PayloadElem<?>> elems = PayloadElemList.visitChildListWithClassEqualityCheck(this, this.elems, nv);
        return this.reconstruct(elems);
    }

    public List<PayloadElem<?>> getElements() {
        return Collections.unmodifiableList(this.elems);
    }

    public Payload toPayload() {
        List<PayloadType<? extends PayloadTypeKind>> pts = this.elems.stream().map(pe -> pe.toPayloadType()).collect(Collectors.toList());
        return new Payload(pts);
    }

    public boolean isEmpty() {
        return this.elems.isEmpty();
    }

    public String toString() {
        return "(" + this.elems.stream().map(pe -> pe.toString()).collect(Collectors.joining(", ")) + ")";
    }
}

