/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.global;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.Choice;
import org.scribble.ast.ProtocolBlock;
import org.scribble.ast.ScribNodeBase;
import org.scribble.ast.global.GCompoundInteractionNode;
import org.scribble.ast.global.GProtocolBlock;
import org.scribble.ast.local.LChoice;
import org.scribble.ast.local.LInteractionNode;
import org.scribble.ast.local.LProtocolBlock;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.del.ScribDel;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Global;
import org.scribble.sesstype.name.Role;
import org.scribble.util.ScribUtil;

public class GChoice
extends Choice<Global>
implements GCompoundInteractionNode {
    public GChoice(CommonTree source, RoleNode subj, List<GProtocolBlock> blocks) {
        super(source, subj, blocks);
    }

    public LChoice project(Role self, List<LProtocolBlock> blocks) {
        LChoice projection = null;
        if (!(blocks = blocks.stream().filter(b -> !b.isEmpty()).collect(Collectors.toList())).isEmpty()) {
            RoleNode subj = self.equals(this.subj.toName()) ? this.subj.clone() : AstFactoryImpl.FACTORY.DummyProjectionRoleNode();
            List cs = blocks.stream().map(b -> AstFactoryImpl.FACTORY.LChoice(this.source, subj, Arrays.asList(b))).collect(Collectors.toList());
            LChoice merged = (LChoice)cs.get(0);
            try {
                for (int i = 1; i < cs.size(); ++i) {
                    merged = merged.merge((LInteractionNode)cs.get(i));
                }
            }
            catch (ScribbleException e) {
                throw new RuntimeScribbleException(e);
            }
            projection = merged;
        }
        return projection;
    }

    @Override
    protected ScribNodeBase copy() {
        return new GChoice(this.source, this.subj, this.getBlocks());
    }

    @Override
    public GChoice clone() {
        RoleNode subj = this.subj.clone();
        List<GProtocolBlock> blocks = ScribUtil.cloneList(this.getBlocks());
        return AstFactoryImpl.FACTORY.GChoice(this.source, subj, blocks);
    }

    public GChoice reconstruct(RoleNode subj, List<? extends ProtocolBlock<Global>> blocks) {
        ScribDel del = this.del();
        GChoice gc = new GChoice(this.source, subj, GChoice.castBlocks(blocks));
        gc = (GChoice)gc.del(del);
        return gc;
    }

    @Override
    public List<GProtocolBlock> getBlocks() {
        return GChoice.castBlocks(super.getBlocks());
    }

    private static List<GProtocolBlock> castBlocks(List<? extends ProtocolBlock<Global>> blocks) {
        return blocks.stream().map(b -> (GProtocolBlock)b).collect(Collectors.toList());
    }

    @Override
    public Global getKind() {
        return GCompoundInteractionNode.super.getKind();
    }
}

