/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.ast.global;

import org.antlr.runtime.tree.CommonTree;
import org.scribble.ast.AstFactoryImpl;
import org.scribble.ast.PayloadElem;
import org.scribble.ast.ScribNodeBase;
import org.scribble.ast.local.LDelegationElem;
import org.scribble.ast.name.qualified.GProtocolNameNode;
import org.scribble.ast.name.simple.RoleNode;
import org.scribble.del.ScribDel;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.kind.Local;
import org.scribble.sesstype.name.GDelegationType;
import org.scribble.sesstype.name.PayloadType;
import org.scribble.visit.AstVisitor;
import org.scribble.visit.context.Projector;

public class GDelegationElem
extends ScribNodeBase
implements PayloadElem<Local> {
    public final GProtocolNameNode proto;
    public final RoleNode role;

    public GDelegationElem(CommonTree source, GProtocolNameNode proto, RoleNode role) {
        super(source);
        this.proto = proto;
        this.role = role;
    }

    public LDelegationElem project() {
        return AstFactoryImpl.FACTORY.LDelegationElem(this.source, Projector.makeProjectedFullNameNode(this.source, this.proto.toName(), this.role.toName()));
    }

    @Override
    public boolean isGlobalDelegationElem() {
        return true;
    }

    @Override
    protected GDelegationElem copy() {
        return new GDelegationElem(this.source, this.proto, this.role);
    }

    @Override
    public GDelegationElem clone() {
        GProtocolNameNode name = this.proto.clone();
        RoleNode role = this.role.clone();
        return AstFactoryImpl.FACTORY.GDelegationElem(this.source, name, role);
    }

    public GDelegationElem reconstruct(GProtocolNameNode proto, RoleNode role) {
        ScribDel del = this.del();
        GDelegationElem elem = new GDelegationElem(this.source, proto, role);
        elem = (GDelegationElem)elem.del(del);
        return elem;
    }

    @Override
    public GDelegationElem visitChildren(AstVisitor nv) throws ScribbleException {
        GProtocolNameNode name = (GProtocolNameNode)this.visitChild(this.proto, nv);
        RoleNode role = (RoleNode)this.visitChild(this.role, nv);
        return this.reconstruct(name, role);
    }

    public String toString() {
        return this.proto + "@" + this.role;
    }

    @Override
    public PayloadType<Local> toPayloadType() {
        return new GDelegationType(this.proto.toName(), this.role.toName());
    }
}

