/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.List;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;

public class AcceptSocketGenerator
extends ScribSocketGenerator {
    public AcceptSocketGenerator(StateChannelApiGenerator apigen, EState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.AcceptSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        super.addImports();
    }

    @Override
    protected void addMethods() {
        List as = this.curr.getActions();
        if (as.size() > 1) {
            throw new RuntimeException("AcceptSocket generation not yet supported for accept-branches: " + as);
        }
        EAction a = (EAction)as.iterator().next();
        EState succ = (EState)this.curr.getSuccessor(a);
        this.makeAcceptMethod(a, succ);
    }

    private void makeAcceptMethod(EAction a, EState succ) {
        MethodBuilder mb = this.makeAcceptHeader(a, succ);
        mb.addBodyLine("super.accept(ss, " + this.getSessionApiRoleConstant(a.obj) + ");");
        this.addReturnNextSocket(mb, succ);
    }

    private MethodBuilder makeAcceptHeader(EAction a, EState succ) {
        MethodBuilder mb = this.cb.newMethod();
        AcceptSocketGenerator.setAcceptHeaderWithoutReturnType(this.apigen, a, mb);
        AcceptSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
        return mb;
    }

    public static void setAcceptHeaderWithoutReturnType(StateChannelApiGenerator apigen, EAction a, MethodBuilder mb) {
        String ROLE_PARAM = "role";
        mb.setName("accept");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException");
        mb.addParameters(SessionApiGenerator.getRoleClassName(a.obj) + " " + "role", "org.scribble.net.scribsock.ScribServerSocket ss");
    }
}

