/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.LinkedList;
import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.AuxStateChannelTypeGenerator;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.ConstructorBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.PayloadType;

public class InputFutureGenerator
extends AuxStateChannelTypeGenerator {
    protected static final String SCRIBFUTURE_CLASS = "org.scribble.net.ScribFuture";
    private final EAction a;

    public InputFutureGenerator(StateChannelApiGenerator apigen, ClassBuilder parent, EAction a) {
        super(apigen, parent);
        this.a = a;
    }

    @Override
    public ClassBuilder generateType() throws ScribbleException {
        String FUTURE_PARAM = "fut";
        Module main = this.apigen.getMainModule();
        GProtocolName gpn = this.apigen.getGProtocolName();
        String futureClass = InputFutureGenerator.getInputFutureName(this.parent.getName());
        ClassBuilder future = new ClassBuilder();
        future.setPackage(SessionApiGenerator.getStateChannelPackageName(gpn, this.apigen.getSelf()));
        future.addImports("java.io.IOException");
        future.addImports("java.util.concurrent.CompletableFuture");
        future.addModifiers("public");
        future.setName(futureClass);
        future.setSuperClass(SCRIBFUTURE_CLASS);
        LinkedList<String> types = new LinkedList<String>();
        if (this.a.mid.isOp()) {
            if (!this.a.payload.isEmpty()) {
                int i = 1;
                for (PayloadType<? extends PayloadTypeKind> pt : this.a.payload.elems) {
                    if (!pt.isDataType()) {
                        throw new ScribbleException("[TODO] API generation not supported for non- data type payloads: " + pt);
                    }
                    DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                    ScribSocketGenerator.checkJavaDataTypeDecl(dtd);
                    String type = dtd.extName;
                    types.add(type);
                    FieldBuilder f = future.newField("pay" + i++);
                    f.setType(type);
                    f.addModifiers("public");
                }
            }
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)this.a.mid).getSimpleName());
            ScribSocketGenerator.checkMessageSigNameDecl(msd);
            String type = msd.extName;
            types.add(type);
            FieldBuilder f = future.newField("msg");
            f.setType(type);
            f.addModifiers("public");
        }
        ConstructorBuilder cons = future.newConstructor("CompletableFuture<org.scribble.net.ScribMessage> fut");
        cons.addModifiers("protected");
        cons.addBodyLine("super(fut);");
        MethodBuilder sync = future.newMethod("sync");
        sync.addModifiers("public");
        sync.setReturn(futureClass);
        sync.addExceptions("IOException");
        String ln = this.a.mid.isOp() && this.a.payload.isEmpty() ? "" : "org.scribble.net.ScribMessage m = ";
        ln = ln + "super.get();";
        sync.addBodyLine(ln);
        if (this.a.mid.isOp()) {
            if (!this.a.payload.isEmpty()) {
                int i = 1;
                for (String type : types) {
                    sync.addBodyLine("this.pay" + i + " = (" + type + ") m.payload[" + (i - 1) + "];");
                    ++i;
                }
            }
        } else {
            sync.addBodyLine("this.msg = (" + (String)types.get(0) + ") m;");
        }
        sync.addBodyLine("return this;");
        return future;
    }

    public static String getInputFutureName(String parent) {
        return parent + "_Future";
    }
}

