/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.ast.DataTypeDecl;
import org.scribble.ast.MessageSigNameDecl;
import org.scribble.ast.Module;
import org.scribble.codegen.java.endpointapi.ScribSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.DataType;
import org.scribble.sesstype.name.MessageSigName;
import org.scribble.sesstype.name.PayloadType;

public class OutputSocketGenerator
extends ScribSocketGenerator {
    public OutputSocketGenerator(StateChannelApiGenerator apigen, EState curr) {
        super(apigen, curr);
    }

    @Override
    protected String getSuperClassType() {
        return "org.scribble.net.scribsock.OutputSocket<" + this.getSessionClassName() + ", " + this.getSelfClassName() + ">";
    }

    @Override
    protected void addImports() {
        this.cb.addImports("java.io.IOException");
        super.addImports();
    }

    @Override
    protected void addMethods() throws ScribbleException {
        String ROLE_PARAM = "role";
        boolean hasConnect = false;
        boolean hasWrap = false;
        for (EAction a : this.curr.getActions()) {
            EState succ = (EState)this.curr.getSuccessor(a);
            MethodBuilder mb = this.cb.newMethod();
            if (a.isSend()) {
                OutputSocketGenerator.setSendHeaderWithoutReturnType(this.apigen, a, mb);
            } else if (a.isConnect()) {
                hasConnect = true;
                OutputSocketGenerator.setConnectHeaderWithoutReturnType(this.apigen, a, mb);
            } else if (a.isDisconnect()) {
                OutputSocketGenerator.setDisconnectHeaderWithoutReturnType(this.apigen, a, mb);
            } else if (a.isWrapClient()) {
                hasWrap = true;
                OutputSocketGenerator.setWrapClientHeaderWithoutReturnType(this.apigen, a, mb);
            } else {
                throw new RuntimeException("[TODO] OutputSocket API generation for: " + a);
            }
            OutputSocketGenerator.setNextSocketReturnType(this.apigen, mb, succ);
            if (a.mid.isOp()) {
                this.cb.addImports(this.getOpsPackageName() + ".*");
            }
            if (a.isSend()) {
                if (a.mid.isOp()) {
                    List<String> args = OutputSocketGenerator.getSendPayloadArgs(a);
                    String body = "super.writeScribMessage(role, " + this.getSessionApiOpConstant(a.mid);
                    if (!a.payload.isEmpty()) {
                        body = body + ", " + args.stream().collect(Collectors.joining(", "));
                    }
                    body = body + ");\n";
                    mb.addBodyLine(body);
                } else {
                    String MESSAGE_PARAM = "m";
                    mb.addBodyLine("super.writeScribMessage(role, m);");
                }
            } else if (a.isConnect()) {
                mb.addBodyLine("super.connect(role, cons, host, port);\n");
            } else if (a.isDisconnect()) {
                mb.addBodyLine("super.disconnect(role);\n");
            } else if (a.isWrapClient()) {
                mb.addBodyLine("super.wrapClient(role, wrapper);\n");
            } else {
                throw new RuntimeException("Shouldn't get in here: " + a);
            }
            this.addReturnNextSocket(mb, succ);
        }
        if (hasConnect) {
            this.cb.addImports("java.util.concurrent.Callable");
            this.cb.addImports("org.scribble.net.session.BinaryChannelEndpoint");
        }
        if (hasWrap) {
            this.cb.addImports("java.util.concurrent.Callable");
            this.cb.addImports("org.scribble.net.session.BinaryChannelWrapper");
        }
    }

    private static List<String> getSendPayloadArgs(EAction a) {
        String ARG_PREFIX = "arg";
        return IntStream.range(0, a.payload.elems.size()).mapToObj(i -> "arg" + i++).collect(Collectors.toList());
    }

    public static void setSendHeaderWithoutReturnType(StateChannelApiGenerator apigen, EAction a, MethodBuilder mb) throws ScribbleException {
        String ROLE_PARAM = "role";
        Module main = apigen.getMainModule();
        mb.setName("send");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException");
        mb.addParameters(SessionApiGenerator.getRoleClassName(a.obj) + " " + "role");
        if (a.mid.isOp()) {
            OutputSocketGenerator.addSendOpParams(apigen, mb, main, a);
        } else {
            MessageSigNameDecl msd = main.getMessageSigDecl(((MessageSigName)a.mid).getSimpleName());
            OutputSocketGenerator.addSendMessageSigNameParams(mb, msd);
        }
    }

    public static void setConnectHeaderWithoutReturnType(StateChannelApiGenerator apigen, EAction a, MethodBuilder mb) {
        String ROLE_PARAM = "role";
        mb.setName("connect");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException");
        mb.addParameters(SessionApiGenerator.getRoleClassName(a.obj) + " " + "role");
        mb.addParameters("Callable<? extends BinaryChannelEndpoint> cons");
        mb.addParameters("String host");
        mb.addParameters("int port");
    }

    public static void setDisconnectHeaderWithoutReturnType(StateChannelApiGenerator apigen, EAction a, MethodBuilder mb) {
        String ROLE_PARAM = "role";
        mb.setName("disconnect");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException");
        mb.addParameters(SessionApiGenerator.getRoleClassName(a.obj) + " " + "role");
    }

    public static void setWrapClientHeaderWithoutReturnType(StateChannelApiGenerator apigen, EAction a, MethodBuilder mb) {
        String ROLE_PARAM = "role";
        mb.setName("wrapClient");
        mb.addModifiers("public");
        mb.addExceptions("org.scribble.main.ScribbleRuntimeException", "IOException");
        mb.addParameters(SessionApiGenerator.getRoleClassName(a.obj) + " " + "role");
        mb.addParameters("Callable<? extends BinaryChannelWrapper> wrapper");
    }

    protected static void addSendOpParams(StateChannelApiGenerator apigen, MethodBuilder mb, Module main, EAction a) throws ScribbleException {
        List<String> args = OutputSocketGenerator.getSendPayloadArgs(a);
        mb.addParameters(SessionApiGenerator.getOpClassName(a.mid) + " op");
        if (!a.payload.isEmpty()) {
            Iterator<String> as = args.iterator();
            for (PayloadType<? extends PayloadTypeKind> pt : a.payload.elems) {
                if (!pt.isDataType()) {
                    throw new ScribbleException("[TODO] API generation not supported for non- data type payloads: " + pt);
                }
                DataTypeDecl dtd = main.getDataTypeDecl((DataType)pt);
                ScribSocketGenerator.checkJavaDataTypeDecl(dtd);
                mb.addParameters(dtd.extName + " " + as.next());
            }
        }
    }

    protected static void addSendMessageSigNameParams(MethodBuilder mb, MessageSigNameDecl msd) throws ScribbleException {
        String MESSAGE_PARAM = "m";
        ScribSocketGenerator.checkMessageSigNameDecl(msd);
        mb.addParameters(msd.extName + " " + "m");
    }
}

