/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.scribble.ast.Module;
import org.scribble.ast.global.GProtocolDecl;
import org.scribble.codegen.java.endpointapi.ApiGenerator;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.ConstructorBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.del.ModuleDel;
import org.scribble.main.Job;
import org.scribble.main.ScribbleException;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.MessageId;
import org.scribble.sesstype.name.Role;
import org.scribble.visit.util.MessageIdCollector;

public class SessionApiGenerator
extends ApiGenerator {
    public static final String GPROTOCOLNAME_CLASS = "org.scribble.sesstype.name.GProtocolName";
    public static final String OP_CLASS = "org.scribble.sesstype.name.Op";
    public static final String ROLE_CLASS = "org.scribble.sesstype.name.Role";
    public static final String SESSION_CLASS = "org.scribble.net.session.Session";
    public static final String SESSIONTYPEFACTORY_CLASS = "org.scribble.sesstype.SessionTypeFactory";
    private static final String IMPATH_FIELD = "IMPATH";
    private static final String SOURCE_FIELD = "SOURCE";
    private static final String PROTO_FIELD = "PROTO";
    private final Set<Role> roles = new HashSet<Role>();
    private final Set<MessageId<?>> mids = new HashSet();
    private final ClassBuilder cb = new ClassBuilder();
    private final Map<String, ClassBuilder> classes = new HashMap<String, ClassBuilder>();

    public SessionApiGenerator(Job job, GProtocolName fullname) throws ScribbleException {
        super(job, fullname);
        this.constructRoleClasses();
        this.constructOpClasses();
        this.constructSessionClass();
    }

    @Override
    public Map<String, String> generateApi() {
        String simpname = SessionApiGenerator.getSessionClassName(this.gpn);
        String path = SessionApiGenerator.makePath(this.gpn, simpname);
        StringBuilder sb = new StringBuilder(this.cb.build());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(path, sb.toString());
        this.classes.keySet().stream().forEach(n -> map.put((String)n, this.classes.get(n).build()));
        return map;
    }

    private static String makePath(GProtocolName gpn, String simpname) {
        return SessionApiGenerator.getEndpointApiRootPackageName(gpn).replace('.', '/') + "/" + simpname + ".java";
    }

    private void constructSessionClass() {
        String packname = SessionApiGenerator.getEndpointApiRootPackageName(this.gpn);
        String simpname = SessionApiGenerator.getSessionClassName(this.gpn);
        this.cb.setName(simpname);
        this.cb.setPackage(packname);
        this.cb.addImports("java.util.Arrays", "java.util.Collections", "java.util.LinkedList", "java.util.List");
        this.cb.addImports(ROLE_CLASS);
        this.cb.addImports(SessionApiGenerator.getRolesPackageName(this.gpn) + ".*");
        if (!this.mids.isEmpty()) {
            this.cb.addImports(SessionApiGenerator.getOpsPackageName(this.gpn) + ".*");
        }
        this.cb.addModifiers("public", "final");
        this.cb.setSuperClass(SESSION_CLASS);
        FieldBuilder fb1 = this.cb.newField(IMPATH_FIELD);
        fb1.setType("List<String>");
        fb1.addModifiers("public", "static", "final");
        fb1.setExpression("new LinkedList<>()");
        FieldBuilder fb2 = this.cb.newField(SOURCE_FIELD);
        fb2.setType("String");
        fb2.addModifiers("public", "static", "final");
        fb2.setExpression("\"getSource\"");
        FieldBuilder fb3 = this.cb.newField(PROTO_FIELD);
        fb3.setType(GPROTOCOLNAME_CLASS);
        fb3.addModifiers("public", "static", "final");
        fb3.setExpression("org.scribble.sesstype.SessionTypeFactory.parseGlobalProtocolName(\"" + this.gpn + "\")");
        this.roles.stream().forEach(r -> this.addRoleField(this.cb, (Role)r));
        this.mids.stream().forEach(mid -> this.addOpField(this.cb, (MessageId<?>)mid));
        ConstructorBuilder ctor = this.cb.newConstructor(new String[0]);
        ctor.addModifiers("public");
        ctor.addBodyLine("super(" + simpname + "." + IMPATH_FIELD + ", " + simpname + "." + SOURCE_FIELD + ", " + simpname + "." + PROTO_FIELD + ");");
        FieldBuilder fb4 = this.cb.newField("ROLES");
        fb4.setType("List<Role>");
        fb4.addModifiers("public", "static", "final");
        String roles = "Collections.unmodifiableList(Arrays.asList(new Role[] {";
        roles = roles + this.roles.stream().map(r -> r.toString()).collect(Collectors.joining(", "));
        roles = roles + "}))";
        fb4.setExpression(roles);
        MethodBuilder mb = this.cb.newMethod("getRoles");
        mb.addAnnotations("@Override");
        mb.addModifiers("public");
        mb.setReturn("List<Role>");
        mb.addParameters(new String[0]);
        mb.addBodyLine("return " + simpname + ".ROLES;");
    }

    private void addRoleField(ClassBuilder cb, Role role) {
        this.addSingletonConstant(cb, "roles", SessionApiGenerator.getRoleClassName(role));
    }

    private void addOpField(ClassBuilder cb, MessageId<?> mid) {
        this.addSingletonConstant(cb, "ops", SessionApiGenerator.getOpClassName(mid));
    }

    private void addSingletonConstant(ClassBuilder cb, String subpack, String type) {
        FieldBuilder fb = cb.newField(type);
        fb.setType(type);
        fb.addModifiers("public", "static", "final");
        fb.setExpression(SessionApiGenerator.getEndpointApiRootPackageName(this.gpn) + "." + subpack + "." + type + "." + type);
    }

    private void constructOpClasses() throws ScribbleException {
        Module mod = this.job.getContext().getModule(this.gpn.getPrefix());
        GProtocolName simpname = this.gpn.getSimpleName();
        GProtocolDecl gpd = (GProtocolDecl)mod.getProtocolDecl(simpname);
        MessageIdCollector coll = new MessageIdCollector(this.job, ((ModuleDel)mod.del()).getModuleContext());
        gpd.accept(coll);
        for (MessageId mid : coll.getNames()) {
            this.constructOpClass(new ClassBuilder(), SessionApiGenerator.getOpsPackageName(this.gpn), mid);
            this.mids.add(mid);
        }
    }

    private void constructRoleClasses() throws ScribbleException {
        Module mod = this.job.getContext().getModule(this.gpn.getPrefix());
        GProtocolName simpname = this.gpn.getSimpleName();
        GProtocolDecl gpd = (GProtocolDecl)mod.getProtocolDecl(simpname);
        for (Role r : gpd.header.roledecls.getRoles()) {
            this.constructRoleClass(new ClassBuilder(), SessionApiGenerator.getRolesPackageName(this.gpn), r);
            this.roles.add(r);
        }
    }

    private ClassBuilder constructRoleClass(ClassBuilder cb, String pack, Role r) {
        return this.constructSingletonClass(cb, pack, ROLE_CLASS, SessionApiGenerator.getRoleClassName(r));
    }

    private ClassBuilder constructOpClass(ClassBuilder cb, String pack, MessageId<?> mid) {
        return this.constructSingletonClass(cb, pack, OP_CLASS, SessionApiGenerator.getOpClassName(mid));
    }

    private ClassBuilder constructSingletonClass(ClassBuilder cb, String pack, String superc, String type) {
        cb.setName(type);
        cb.addModifiers("public", "final");
        cb.setPackage(pack);
        cb.setSuperClass(superc);
        FieldBuilder fb = cb.newField("serialVersionUID");
        fb.addModifiers("private", "static", "final");
        fb.setType("long");
        fb.setExpression("1L");
        FieldBuilder fb2 = cb.newField(type);
        fb2.addModifiers("public", "static", "final");
        fb2.setType(type);
        fb2.setExpression("new " + type + "()");
        ConstructorBuilder mb = cb.newConstructor(new String[0]);
        mb.addModifiers("private");
        mb.addBodyLine("super(\"" + type + "\");");
        this.classes.put(pack.replace('.', '/') + "/" + type + ".java", cb);
        return cb;
    }

    public static String getSessionClassName(GProtocolName gpn) {
        return gpn.getSimpleName().toString();
    }

    public static String getEndpointApiRootPackageName(GProtocolName gpn) {
        return gpn.toString();
    }

    public static String getRolesPackageName(GProtocolName gpn) {
        return SessionApiGenerator.getEndpointApiRootPackageName(gpn) + ".roles";
    }

    public static String getOpsPackageName(GProtocolName gpn) {
        return SessionApiGenerator.getEndpointApiRootPackageName(gpn) + ".ops";
    }

    public static String getStateChannelPackageName(GProtocolName gpn, Role self) {
        return SessionApiGenerator.getEndpointApiRootPackageName(gpn) + ".channels." + self;
    }

    public static String getRoleClassName(Role r) {
        return r.toString();
    }

    public static String getOpClassName(MessageId<?> mid) {
        String s = mid.toString();
        return s.isEmpty() || s.charAt(0) < 'A' ? "_" + s : s;
    }
}

