/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import org.scribble.codegen.java.endpointapi.OutputSocketGenerator;
import org.scribble.codegen.java.endpointapi.ReceiveSocketGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.model.endpoint.actions.EReceive;
import org.scribble.sesstype.kind.PayloadTypeKind;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.PayloadType;

public class ActionInterfaceGenerator
extends IOInterfaceGenerator {
    private final EAction a;
    private final InterfaceBuilder ib = new InterfaceBuilder();

    public ActionInterfaceGenerator(StateChannelApiGenerator apigen, EState curr, EAction a) {
        super(apigen, curr);
        this.a = a;
    }

    @Override
    public InterfaceBuilder generateType() throws ScribbleException {
        GProtocolName gpn = this.apigen.getGProtocolName();
        this.ib.setName(ActionInterfaceGenerator.getActionInterfaceName(this.a));
        this.ib.setPackage(IOInterfacesGenerator.getIOInterfacePackageName(this.apigen.getGProtocolName(), this.apigen.getSelf()));
        this.ib.addImports("java.io.IOException");
        this.ib.addImports(SessionApiGenerator.getEndpointApiRootPackageName(gpn) + ".*");
        this.ib.addImports(SessionApiGenerator.getRolesPackageName(gpn) + ".*");
        this.ib.addImports(SessionApiGenerator.getOpsPackageName(gpn) + ".*");
        this.ib.addModifiers("public");
        this.ib.addParameters("__Succ extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(this.a));
        AbstractMethodBuilder mb = this.ib.newAbstractMethod();
        if (this.a instanceof EReceive) {
            ReceiveSocketGenerator.setReceiveHeaderWithoutReturnType(this.apigen, this.a, mb);
        } else {
            OutputSocketGenerator.setSendHeaderWithoutReturnType(this.apigen, this.a, mb);
        }
        mb.setReturn("__Succ");
        return this.ib;
    }

    public static String getActionInterfaceName(EAction a) {
        String name = a instanceof EReceive ? "In" : "Out";
        name = name + "_" + ActionInterfaceGenerator.getActionString(a);
        return name;
    }

    public static String getActionString(EAction a) {
        String name = a.obj + "_" + a.mid;
        for (PayloadType<? extends PayloadTypeKind> pay : a.payload.elems) {
            name = name + "_" + pay;
        }
        return name;
    }
}

