/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.CaseInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.HandleInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.EnumBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.name.Role;

public class BranchInterfaceGenerator
extends IOStateInterfaceGenerator {
    public BranchInterfaceGenerator(StateChannelApiGenerator apigen, Map<EAction, InterfaceBuilder> actions, EState curr) {
        super(apigen, actions, curr);
    }

    @Override
    protected void constructInterface() throws ScribbleException {
        super.constructInterface();
        this.addBranchEnum();
        this.addBranchMethods();
    }

    protected void addBranchMethods() {
        Role self = this.apigen.getSelf();
        List as = this.curr.getActions();
        AbstractMethodBuilder bra = this.ib.newAbstractMethod("branch");
        String ret = CaseInterfaceGenerator.getCasesInterfaceName(self, this.curr) + "<" + IntStream.range(1, as.size() + 1).mapToObj(i -> "__Succ" + i).collect(Collectors.joining(", ")) + ">";
        bra.setReturn(ret);
        bra.addParameters(SessionApiGenerator.getRoleClassName(((EAction)as.iterator().next()).obj) + " role");
        bra.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        AbstractMethodBuilder bra2 = this.ib.newAbstractMethod("branch");
        bra2.setReturn("void");
        bra2.addParameters(SessionApiGenerator.getRoleClassName(((EAction)as.iterator().next()).obj) + " role");
        String next = HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr) + "<" + IntStream.range(1, as.size() + 1).mapToObj(i -> "__Succ" + i).collect(Collectors.joining(", ")) + ">";
        bra2.addParameters(next + " handler");
        bra2.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
        AbstractMethodBuilder bra3 = this.ib.newAbstractMethod("handle");
        bra3.setReturn("void");
        bra3.addParameters(SessionApiGenerator.getRoleClassName(((EAction)as.iterator().next()).obj) + " role");
        String handle = HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr) + "<" + as.stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).map(a -> SuccessorInterfaceGenerator.getSuccessorInterfaceName(a)).collect(Collectors.joining(", ")) + ">";
        bra3.addParameters(handle + " handler");
        bra3.addExceptions("org.scribble.main.ScribbleRuntimeException", "java.io.IOException", "ClassNotFoundException");
    }

    protected void addBranchEnum() {
        Role self = this.apigen.getSelf();
        EnumBuilder eb = this.ib.newMemberEnum(BranchInterfaceGenerator.getBranchInterfaceEnumName(self, this.curr));
        eb.addModifiers("public");
        eb.addInterfaces("org.scribble.net.session.OpEnum");
        this.curr.getActions().stream().forEach(a -> eb.addValues(SessionApiGenerator.getOpClassName(a.mid)));
    }

    @Override
    protected void addSuccessorParamsAndActionInterfaces() {
        int i = 1;
        for (EAction a : this.curr.getActions().stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            this.ib.addParameters("__Succ" + i + " extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
            ++i;
        }
    }

    public static String getBranchInterfaceEnumName(Role self, EState curr) {
        return BranchInterfaceGenerator.getIOStateInterfaceName(self, curr) + "_Enum";
    }
}

