/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scribble.codegen.java.endpointapi.HandlerInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.ActionInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOInterfacesGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public class HandleInterfaceGenerator
extends IOStateInterfaceGenerator {
    private final Map<EAction, InterfaceBuilder> caseActions;

    public HandleInterfaceGenerator(IOInterfacesGenerator iogen, Map<EAction, InterfaceBuilder> actions, EState curr, Map<EAction, InterfaceBuilder> caseActions) {
        super(iogen.apigen, actions, curr);
        this.caseActions = caseActions;
    }

    @Override
    protected void constructInterface() throws ScribbleException {
        super.constructInterface();
        this.addHandleMethods();
    }

    @Override
    protected void addHeader() {
        GProtocolName gpn = this.apigen.getGProtocolName();
        Role self = this.apigen.getSelf();
        String packname = IOInterfacesGenerator.getIOInterfacePackageName(gpn, self);
        String ifname = HandleInterfaceGenerator.getHandleInterfaceName(self, this.curr);
        this.ib.setName(ifname);
        this.ib.setPackage(packname);
        this.ib.addModifiers("public");
    }

    @Override
    protected void addCastField() {
    }

    @Override
    protected void addSuccessorParamsAndActionInterfaces() {
        int i = 1;
        for (EAction a : this.curr.getActions().stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            this.ib.addParameters("__Succ" + i + " extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
            this.ib.addInterfaces(this.caseActions.get(a).getName() + "<__Succ" + i + ">");
            ++i;
        }
    }

    protected void addHandleMethods() throws ScribbleException {
        GProtocolName gpn = this.apigen.getGProtocolName();
        List as = this.curr.getActions();
        this.ib.addImports(SessionApiGenerator.getOpsPackageName(gpn) + ".*");
        int i = 1;
        for (EAction a : as.stream().sorted(IOACTION_COMPARATOR).collect(Collectors.toList())) {
            AbstractMethodBuilder mb = this.ib.newAbstractMethod();
            HandlerInterfaceGenerator.setHandleMethodHeaderWithoutParamTypes(this.apigen, mb);
            mb.addParameters("__Succ" + i++ + " schan");
            HandlerInterfaceGenerator.addHandleMethodOpAndPayloadParams(this.apigen, a, mb);
        }
    }

    protected static void setHandleMethodSuccessorParam(IOInterfacesGenerator iogen, Role self, EState succ, MethodBuilder mb, List<EAction> as, Map<EAction, Integer> count) {
        if (succ.isTerminal()) {
            mb.addParameters("org.scribble.net.scribsock.EndSocket<?, ?> end");
        } else {
            InterfaceBuilder next = iogen.getIOStateInterface(IOStateInterfaceGenerator.getIOStateInterfaceName(self, succ));
            String ret = next.getName() + "<";
            boolean first = true;
            for (EAction a : succ.getActions().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList())) {
                int offset;
                if (!count.containsKey(a)) {
                    offset = 0;
                    count.put(a, 0);
                } else {
                    offset = count.get(a) + 1;
                    count.put(a, offset);
                }
                if (first) {
                    first = false;
                } else {
                    ret = ret + ", ";
                }
                ret = ret + "__Succ" + (as.indexOf(a) + 1 + offset);
            }
            ret = ret + ">";
            mb.addParameters(ret + " schan");
        }
    }

    public static String getHandleInterfaceName(Role self, EState s) {
        String name = "Handle_" + self + "_" + s.getActions().stream().sorted(IOACTION_COMPARATOR).map(a -> ActionInterfaceGenerator.getActionString(a)).collect(Collectors.joining("__"));
        IOStateInterfaceGenerator.checkIOStateInterfaceNameLength(name);
        return name;
    }
}

