/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.codegen.java.endpointapi.ioifaces;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.scribble.codegen.java.endpointapi.ApiGenerator;
import org.scribble.codegen.java.endpointapi.CaseSocketGenerator;
import org.scribble.codegen.java.endpointapi.HandlerInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.SessionApiGenerator;
import org.scribble.codegen.java.endpointapi.StateChannelApiGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.ActionInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.BranchInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.CaseInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.HandleInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.IOStateInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.ReceiveInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SelectInterfaceGenerator;
import org.scribble.codegen.java.endpointapi.ioifaces.SuccessorInterfaceGenerator;
import org.scribble.codegen.java.util.AbstractMethodBuilder;
import org.scribble.codegen.java.util.ClassBuilder;
import org.scribble.codegen.java.util.FieldBuilder;
import org.scribble.codegen.java.util.InterfaceBuilder;
import org.scribble.codegen.java.util.MethodBuilder;
import org.scribble.codegen.java.util.TypeBuilder;
import org.scribble.main.JobContext;
import org.scribble.main.RuntimeScribbleException;
import org.scribble.main.ScribbleException;
import org.scribble.model.endpoint.EState;
import org.scribble.model.endpoint.EStateKind;
import org.scribble.model.endpoint.actions.EAction;
import org.scribble.sesstype.name.GProtocolName;
import org.scribble.sesstype.name.Role;

public class IOInterfacesGenerator
extends ApiGenerator {
    private final boolean SUBTYPES;
    protected StateChannelApiGenerator apigen;
    private final Map<EAction, InterfaceBuilder> actions = new HashMap<EAction, InterfaceBuilder>();
    private final Map<EAction, InterfaceBuilder> succs = new HashMap<EAction, InterfaceBuilder>();
    private final Map<String, InterfaceBuilder> iostates = new HashMap<String, InterfaceBuilder>();
    private final Map<EAction, InterfaceBuilder> caseActions = new HashMap<EAction, InterfaceBuilder>();
    private final Map<EState, Set<EAction>> preActions = new HashMap<EState, Set<EAction>>();
    private final Map<EState, Set<InterfaceBuilder>> preds = new HashMap<EState, Set<InterfaceBuilder>>();
    private final Map<EState, Set<EAction>> branchPostActions = new HashMap<EState, Set<EAction>>();
    private final Map<String, List<EAction>> branchSuccs = new HashMap<String, List<EAction>>();
    private final Function<EState, String> getSuccName = succ -> succ.isTerminal() ? "EndSocket" : this.apigen.getSocketClassName((EState)succ);

    public IOInterfacesGenerator(StateChannelApiGenerator apigen, boolean subtypes) throws RuntimeScribbleException, ScribbleException {
        super(apigen.getJob(), apigen.getGProtocolName());
        this.apigen = apigen;
        this.SUBTYPES = subtypes;
        GProtocolName fullname = apigen.getGProtocolName();
        Role self = this.getSelf();
        JobContext jc = this.job.getContext();
        EState init = this.job.minEfsm ? jc.getMinimisedEGraph((GProtocolName)fullname, (Role)self).init : jc.getEGraph((GProtocolName)fullname, (Role)self).init;
        Set<EAction> as = EState.getReachableActions(init);
        if (as.stream().anyMatch(a -> !a.isSend() && !a.isReceive())) {
            throw new RuntimeScribbleException("[TODO] I/O Interface generation not supported for: " + as.stream().filter(a -> !a.isSend() && !a.isReceive()).collect(Collectors.toList()));
        }
        this.generateActionAndSuccessorInterfacesAndCollectPreActions(new HashSet<EState>(), init);
        this.generateIOStateInterfacesFirstPass(new HashSet<EState>(), init);
        this.collectPreds();
        EState term = EState.getTerminal(init);
        ClassBuilder endsock = null;
        if (term != null) {
            endsock = (ClassBuilder)this.apigen.getType("EndSocket");
            for (InterfaceBuilder ib : this.preds.get(term)) {
                endsock.addInterfaces(ib.getName());
                MethodBuilder mb2 = IOInterfacesGenerator.addToCastMethod(ib, "EndSocket");
                if (mb2 == null) continue;
                ib.addImports(SessionApiGenerator.getStateChannelPackageName(this.gpn, self) + ".EndSocket");
            }
            endsock.addImports(IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, self) + ".*");
        }
        this.generateIOStateInterfacesSecondPass(new HashSet<EState>(), init);
        this.collectBranchSuccs();
        this.generateHandleInterfaces(new HashSet<EState>(), init);
        this.generateHandleInterfacesSecondPass(new HashSet<EState>(), init);
        this.addIOStateInterfacesToStateChannels(new HashSet<EState>(), init);
        if (this.SUBTYPES) {
            this.addSupertypeInterfaces();
        }
        if (term != null) {
            for (InterfaceBuilder ib : this.preds.get(term)) {
                for (MethodBuilder cast : ib.getDefaultMethods()) {
                    MethodBuilder mb;
                    if (cast.getReturn().equals("EndSocket") || (mb = IOInterfacesGenerator.addEndSocketToCastMethod(endsock, cast.getReturn(), "throw new RuntimeScribbleException(\"Invalid cast of EndSocket: \" + cast);")) == null) continue;
                    mb.addModifiers("public");
                    mb.addAnnotations("@Override");
                    endsock.addImports("org.scribble.main.RuntimeScribbleException");
                }
            }
            MethodBuilder mb3 = IOInterfacesGenerator.addEndSocketToCastMethod(endsock, "EndSocket", "return (EndSocket) this;");
            if (mb3 != null) {
                mb3.addModifiers("public");
                mb3.addAnnotations("@Override");
            }
        }
    }

    @Override
    public Map<String, String> generateApi() {
        HashMap<String, String> output = new HashMap<String, String>();
        String prefix = IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, this.getSelf()).replace('.', '/') + "/";
        this.actions.values().stream().forEach(ib -> output.put(prefix + ib.getName() + ".java", ib.build()));
        this.succs.values().stream().forEach(ib -> output.put(prefix + ib.getName() + ".java", ib.build()));
        this.iostates.values().stream().forEach(tb -> output.put(prefix + tb.getName() + ".java", tb.build()));
        this.caseActions.values().stream().forEach(ib -> output.put(prefix + ib.getName() + ".java", ib.build()));
        return output;
    }

    private void generateActionAndSuccessorInterfacesAndCollectPreActions(Set<EState> visited, EState s) throws ScribbleException {
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        visited.add(s);
        List as = s.getActions();
        for (EAction a : as.stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList())) {
            if (!a.isSend() && !a.isReceive()) {
                throw new RuntimeException("TODO: " + a);
            }
            if (!this.actions.containsKey(a)) {
                this.actions.put(a, new ActionInterfaceGenerator(this.apigen, s, a).generateType());
                this.succs.put(a, new SuccessorInterfaceGenerator(this.apigen, s, a).generateType());
                if (s.getStateKind() == EStateKind.POLY_INPUT) {
                    InterfaceBuilder ib = new InterfaceBuilder();
                    ib.setName("Callback_" + ActionInterfaceGenerator.getActionString(a));
                    ib.setPackage(IOInterfacesGenerator.getIOInterfacePackageName(this.apigen.getGProtocolName(), this.apigen.getSelf()));
                    ib.addImports("java.io.IOException");
                    ib.addImports(SessionApiGenerator.getEndpointApiRootPackageName(this.gpn) + ".*");
                    ib.addImports(SessionApiGenerator.getRolesPackageName(this.gpn) + ".*");
                    ib.addImports(SessionApiGenerator.getOpsPackageName(this.gpn) + ".*");
                    ib.addModifiers("public");
                    ib.addParameters("__Succ extends " + SuccessorInterfaceGenerator.getSuccessorInterfaceName(a));
                    AbstractMethodBuilder mb = ib.newAbstractMethod();
                    HandlerInterfaceGenerator.setHandleMethodHeaderWithoutParamTypes(this.apigen, mb);
                    mb.addParameters("__Succ schan");
                    HandlerInterfaceGenerator.addHandleMethodOpAndPayloadParams(this.apigen, a, mb);
                    this.caseActions.put(a, ib);
                }
            }
            EState succ = (EState)s.getSuccessor(a);
            this.putPreAction(succ, a);
            if (s.getStateKind() == EStateKind.POLY_INPUT) {
                this.putBranchPostAction(s, a);
            }
            this.generateActionAndSuccessorInterfacesAndCollectPreActions(visited, succ);
        }
    }

    private void generateIOStateInterfacesFirstPass(Set<EState> visited, EState s) throws ScribbleException {
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        String key = IOStateInterfaceGenerator.getIOStateInterfaceName(this.getSelf(), s);
        if (!this.iostates.containsKey(key)) {
            IOStateInterfaceGenerator ifgen = null;
            switch (s.getStateKind()) {
                case OUTPUT: {
                    ifgen = new SelectInterfaceGenerator(this.apigen, this.actions, s);
                    break;
                }
                case UNARY_INPUT: {
                    ifgen = new ReceiveInterfaceGenerator(this.apigen, this.actions, s);
                    break;
                }
                case POLY_INPUT: {
                    InterfaceBuilder cases = new CaseInterfaceGenerator(this.apigen, this.actions, s).generateType();
                    this.iostates.put(cases.getName(), cases);
                    ifgen = new BranchInterfaceGenerator(this.apigen, this.actions, s);
                    break;
                }
                default: {
                    throw new RuntimeException("(TODO) I/O interface generation: " + (Object)((Object)s.getStateKind()));
                }
            }
            this.iostates.put(key, ifgen.generateType());
        }
        visited.add(s);
        for (EAction a : s.getActions()) {
            this.generateIOStateInterfacesFirstPass(visited, (EState)s.getSuccessor(a));
        }
    }

    private void generateIOStateInterfacesSecondPass(Set<EState> visited, EState s) {
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        Set<InterfaceBuilder> succifs = this.preds.get(s);
        if (succifs != null) {
            Object name;
            InterfaceBuilder iostate = this.iostates.get(IOStateInterfaceGenerator.getIOStateInterfaceName(this.getSelf(), s));
            if (this.SUBTYPES && ((String)(name = iostate.getName())).startsWith("Select")) {
                List<String> ifs = this.iostates.get(name).getInterfaces();
                List<String> outs = ifs.stream().filter(i -> i.startsWith("Out")).map(o -> {
                    o = o.substring(0, o.indexOf("<"));
                    return o.substring(o.indexOf("_") + 1, o.length());
                }).sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
                this.addSupertypeInterfaceToMethods(s, outs, "Select", "Out");
            }
            for (InterfaceBuilder pred : succifs) {
                iostate.addInterfaces(pred.getName());
                String ret = iostate.getName() + "<" + IntStream.range(0, iostate.getParameters().size()).mapToObj(i -> "?").collect(Collectors.joining(", ")) + ">";
                IOInterfacesGenerator.addToCastMethod(pred, ret);
                for (MethodBuilder cast : pred.getDefaultMethods()) {
                    MethodBuilder mb = IOInterfacesGenerator.addToCastMethod(iostate, cast.getReturn());
                    if (mb == null) continue;
                    mb.addAnnotations("@Override");
                }
            }
        }
        visited.add(s);
        for (EAction a : s.getActions()) {
            this.generateIOStateInterfacesSecondPass(visited, (EState)s.getSuccessor(a));
        }
    }

    private void generateHandleInterfaces(Set<EState> visited, EState s) throws ScribbleException {
        String key;
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        if (s.getStateKind() == EStateKind.POLY_INPUT && !this.iostates.containsKey(key = HandleInterfaceGenerator.getHandleInterfaceName(this.getSelf(), s))) {
            HandleInterfaceGenerator ifgen = new HandleInterfaceGenerator(this, this.actions, s, this.caseActions);
            this.iostates.put(key, ifgen.generateType());
        }
        visited.add(s);
        for (EAction a : s.getActions()) {
            this.generateHandleInterfaces(visited, (EState)s.getSuccessor(a));
        }
    }

    private void generateHandleInterfacesSecondPass(Set<EState> visited, EState s) {
        Role self;
        String key;
        List<EAction> succifs;
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        if (s.getStateKind() != EStateKind.POLY_INPUT || (succifs = this.branchSuccs.get(key = HandleInterfaceGenerator.getHandleInterfaceName(self = this.apigen.getSelf(), s))) != null) {
            // empty if block
        }
        visited.add(s);
        for (EAction a : s.getActions()) {
            this.generateHandleInterfacesSecondPass(visited, (EState)s.getSuccessor(a));
        }
    }

    private void addIOStateInterfacesToStateChannels(Set<EState> visited, EState s) {
        if (visited.contains(s) || s.isTerminal()) {
            return;
        }
        Role self = this.getSelf();
        String scname = this.apigen.getSocketClassName(s);
        String ioname = IOStateInterfaceGenerator.getIOStateInterfaceName(self, s);
        TypeBuilder tb = this.apigen.getType(scname);
        tb.addImports(IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, self) + ".*");
        tb.addInterfaces(ioname + this.getConcreteSuccessorParameters(s));
        InterfaceBuilder iostate = this.iostates.get(ioname);
        MethodBuilder mb = IOInterfacesGenerator.addToCastMethod(iostate, scname);
        if (mb != null) {
            iostate.addImports(SessionApiGenerator.getStateChannelPackageName(this.gpn, self) + ".*");
        }
        if (s.getStateKind() == EStateKind.POLY_INPUT) {
            TypeBuilder cases = this.apigen.getType(CaseSocketGenerator.getCaseSocketName(this.apigen.getSocketClassName(s)));
            cases.addImports(IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, self) + ".*");
            cases.addInterfaces(CaseInterfaceGenerator.getCasesInterfaceName(self, s) + this.getConcreteSuccessorParameters(s));
            InterfaceBuilder handler = (InterfaceBuilder)this.apigen.getType(HandlerInterfaceGenerator.getHandlerInterfaceName(this.apigen.getSocketClassName(s)));
            handler.addImports(IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, self) + ".*");
            String tmp = "";
            boolean first = true;
            String handle = HandleInterfaceGenerator.getHandleInterfaceName(self, s);
            for (EAction a : s.getActions().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList())) {
                if (first) {
                    first = false;
                } else {
                    tmp = tmp + ", ";
                }
                EState succ = (EState)s.getSuccessor(a);
                if (succ.isTerminal()) {
                    tmp = tmp + "EndSocket";
                    continue;
                }
                tmp = tmp + this.apigen.getSocketClassName(succ);
            }
            handler.addInterfaces(handle + "<" + tmp + ">");
        }
        visited.add(s);
        for (EAction a : s.getActions()) {
            this.addIOStateInterfacesToStateChannels(visited, (EState)s.getSuccessor(a));
        }
    }

    private void addSupertypeInterfaces() {
        String name;
        HashMap<String, InterfaceBuilder> subtypeifs = new HashMap<String, InterfaceBuilder>();
        for (InterfaceBuilder ib : this.iostates.values()) {
            name = ib.getName();
            if (subtypeifs.containsKey(name) || !name.startsWith("Select") && !name.startsWith("Handle")) continue;
            subtypeifs.put(name, ib);
            HashMap<String, InterfaceBuilder> res = new HashMap<String, InterfaceBuilder>();
            if (name.startsWith("Select")) {
                List<String> ifs = ib.getInterfaces();
                List<String> outs = ifs.stream().filter(i -> i.startsWith("Out")).map(o -> {
                    o = o.substring(0, o.indexOf("<"));
                    return o.substring(o.indexOf("_") + 1, o.length());
                }).sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
                this.buildIOStateSuperInterfaces(res, outs, "Select", "Out", "Out");
            } else {
                List<String> params = ib.getParameters();
                List<String> ins = params.stream().map(i -> i.substring(i.indexOf("Succ_In_") + "Succ_In_".length())).sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
                this.buildIOStateSuperInterfaces(res, ins, "Handle", "Callback", "In");
            }
            res.values().forEach(r -> subtypeifs.put(r.getName(), (InterfaceBuilder)r));
        }
        subtypeifs.values().forEach(r -> this.iostates.put(r.getName(), (InterfaceBuilder)r));
        for (InterfaceBuilder ib : this.iostates.values()) {
            name = ib.getName();
            if (name.startsWith("Select")) {
                List<String> ifs = ib.getInterfaces();
                List<String> outs = ifs.stream().filter(i -> i.startsWith("Out")).map(o -> {
                    o = o.substring(0, o.indexOf("<"));
                    return o.substring(o.indexOf("_") + 1, o.length());
                }).sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
                this.addIOStateSuperInterfaces(ib, outs, "Select", "Out");
                continue;
            }
            if (!name.startsWith("Handle")) continue;
            List<String> params = ib.getParameters();
            List<String> ins = params.stream().map(i -> i.substring(i.indexOf("Succ_In_") + "Succ_In_".length())).sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
            this.addIOStateSuperInterfaces(ib, ins, "Handle", "In");
        }
    }

    private void buildIOStateSuperInterfaces(Map<String, InterfaceBuilder> res, List<String> as, String superPref, String actPref, String succPref) {
        for (String exclude : as) {
            List<String> foo = as.stream().filter(s -> !s.equals(exclude)).collect(Collectors.toList());
            if (foo.size() <= 0) continue;
            String tmp = foo.stream().collect(Collectors.joining("__"));
            String superName = superPref + "_" + this.getSelf() + "_" + tmp;
            if (this.iostates.containsKey(superName) || res.containsKey(superName)) continue;
            InterfaceBuilder ib = new InterfaceBuilder(superName);
            ib.setPackage(IOInterfacesGenerator.getIOInterfacePackageName(this.gpn, this.getSelf()));
            ib.addModifiers("public");
            int i = 1;
            for (String a : foo) {
                ib.addParameters("__Succ" + i + " extends Succ_" + succPref + "_" + a);
                if (!superPref.equals("Branch")) {
                    ib.addInterfaces(actPref + "_" + a + "<__Succ" + i + ">");
                }
                ++i;
            }
            FieldBuilder cast = ib.newField("cast");
            cast.addModifiers("public", "static", "final");
            cast.setType(superName + "<" + IntStream.range(0, foo.size()).mapToObj(x -> "?").collect(Collectors.joining(", ")) + ">");
            cast.setExpression("null");
            res.put(superName, ib);
            this.buildIOStateSuperInterfaces(res, foo, superPref, actPref, succPref);
        }
    }

    private void addIOStateSuperInterfaces(InterfaceBuilder ib, List<String> as, String superPref, String succPref) {
        for (String exclude : as) {
            List foo = as.stream().filter(s -> !s.equals(exclude)).collect(Collectors.toList());
            if (foo.size() <= 0) continue;
            LinkedList<String> params = new LinkedList<String>();
            for (String a : foo) {
                int i = 1;
                for (String param : ib.getParameters()) {
                    if (param.endsWith("Succ_" + succPref + "_" + a)) break;
                    ++i;
                }
                params.add("__Succ" + i);
            }
            String tmp = foo.stream().collect(Collectors.joining("__"));
            String select = superPref + "_" + this.getSelf() + "_" + tmp + "<" + params.stream().collect(Collectors.joining(", ")) + ">";
            ib.addInterfaces(select);
        }
    }

    private void addSupertypeInterfaceToMethods(EState s, List<String> as, String superPref, String succPref) {
        for (String exclude : as) {
            List<String> foo = as.stream().filter(x -> !x.equals(exclude)).collect(Collectors.toList());
            if (foo.size() <= 0) continue;
            String tmp = foo.stream().collect(Collectors.joining("__"));
            String superName = superPref + "_" + this.getSelf() + "_" + tmp;
            for (InterfaceBuilder succif : this.preds.get(s)) {
                IOInterfacesGenerator.addToCastMethod(succif, superName + "<" + IntStream.range(0, foo.size()).mapToObj(f -> "?").collect(Collectors.joining(", ")) + ">");
            }
            if (this.iostates.containsKey(superName)) continue;
            this.addSupertypeInterfaceToMethods(s, foo, superPref, succPref);
        }
    }

    private static MethodBuilder addToCastMethod(InterfaceBuilder ib, String ret) {
        if (ib.getDefaultMethods().stream().filter(def -> def.getReturn().equals(ret)).count() > 0L) {
            return null;
        }
        MethodBuilder mb = ib.newDefaultMethod("to");
        mb.setReturn(ret);
        mb.addParameters(ret + " cast");
        if (!ret.equals("EndSocket") || ib.getName().startsWith("Succ")) {
            mb.addBodyLine("return (" + ret + ") this;");
        } else {
            ib.addImports("org.scribble.main.RuntimeScribbleException");
            mb.addBodyLine("throw new RuntimeScribbleException(\"Invalid cast to EndSocket: \" + cast);");
        }
        return mb;
    }

    private static MethodBuilder addEndSocketToCastMethod(ClassBuilder cb, String ret, String body) {
        if (cb.hasMethodSignature(ret, ret + " ")) {
            return null;
        }
        MethodBuilder mb = cb.newMethod("to");
        mb.setReturn(ret);
        mb.addParameters(ret + " cast");
        mb.addBodyLine(body);
        return mb;
    }

    private String getConcreteSuccessorParameters(EState s) {
        return "<" + s.getActions().stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).map(a -> this.getSuccName.apply((EState)s.getSuccessor(a))).collect(Collectors.joining(", ")) + ">";
    }

    private void putPreAction(EState s, EAction a) {
        IOInterfacesGenerator.putMapSet(this.preActions, s, a);
    }

    private void putBranchPostAction(EState s, EAction a) {
        IOInterfacesGenerator.putMapSet(this.branchPostActions, s, a);
    }

    private static <K, V> void putMapSet(Map<K, Set<V>> map, K k, V v) {
        Set<V> tmp = map.get(k);
        if (tmp == null) {
            tmp = new LinkedHashSet<V>();
            map.put(k, tmp);
        }
        tmp.add(v);
    }

    private void collectPreds() {
        for (EState s : this.preActions.keySet()) {
            HashSet<InterfaceBuilder> tmp = new HashSet<InterfaceBuilder>();
            for (EAction a : this.preActions.get(s)) {
                if (!a.isSend() && !a.isReceive()) {
                    throw new RuntimeException("TODO: " + a);
                }
                tmp.add(this.succs.get(a));
            }
            this.preds.put(s, tmp);
        }
    }

    private void collectBranchSuccs() {
        Role self = this.getSelf();
        for (EState s : this.branchPostActions.keySet()) {
            String key = HandleInterfaceGenerator.getHandleInterfaceName(self, s);
            LinkedList curr1 = new LinkedList();
            this.branchPostActions.get(s).forEach(a -> curr1.addAll(((EState)s.getSuccessor(a)).getActions()));
            List<EAction> tmp = this.branchSuccs.get(key);
            if (tmp == null) {
                tmp = new LinkedList<EAction>();
                tmp.addAll(curr1);
            } else {
                for (EAction a2 : curr1) {
                    long m;
                    long n = curr1.stream().filter(x -> x.equals(a2)).count();
                    if (n <= (m = tmp.stream().filter(x -> x.equals(a2)).count())) continue;
                    int i = 0;
                    while ((long)i < n - m) {
                        tmp.add(a2);
                        ++i;
                    }
                }
            }
            this.branchSuccs.put(key, tmp.stream().sorted(IOStateInterfaceGenerator.IOACTION_COMPARATOR).collect(Collectors.toList()));
        }
    }

    protected Role getSelf() {
        return this.apigen.getSelf();
    }

    protected static String getIOInterfacePackageName(GProtocolName gpn, Role self) {
        return SessionApiGenerator.getStateChannelPackageName(gpn, self) + ".ioifaces";
    }

    protected InterfaceBuilder getIOStateInterface(String name) {
        return this.iostates.get(name);
    }
}

